/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import java.util.Objects;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.ui.RPGSkillUIManager;

public class UpdateClientEquippedActiveSkillsPacket
extends Packet {
    public final String playerName;
    public final EquippedActiveSkill[] equippedActiveSkills;

    public UpdateClientEquippedActiveSkillsPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.playerName = reader.getNextString();
        this.equippedActiveSkills = new EquippedActiveSkill[PlayerData.EQUIPPED_SKILLS_MAX];
        for (int i = 0; i < PlayerData.EQUIPPED_SKILLS_MAX; ++i) {
            this.equippedActiveSkills[i] = EquippedActiveSkill.applyPacket(reader);
        }
    }

    public UpdateClientEquippedActiveSkillsPacket(PlayerData playerData) {
        this.equippedActiveSkills = playerData.equippedActiveSkills;
        this.playerName = playerData.playerName;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextString(this.playerName);
        for (EquippedActiveSkill activeSkill : this.equippedActiveSkills) {
            activeSkill.setupPacket(writer);
        }
    }

    public void processClient(NetworkPacket packet, Client client) {
        PlayerData playerData = PlayerDataList.getPlayerData(this.playerName, false);
        if (playerData != null) {
            playerData.equippedActiveSkills = this.equippedActiveSkills;
            if (Objects.equals(client.getPlayer().playerName, this.playerName)) {
                RPGSkillUIManager.updateContent(playerData);
            }
        }
    }
}

