/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import rpgclasses.content.player.Attribute;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class UpdateClientAttributesPacket
extends Packet {
    public final String playerName;
    public final int[] attributes;

    public UpdateClientAttributesPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.playerName = reader.getNextString();
        this.attributes = new int[Attribute.attributes.size()];
        for (int i = 0; i < Attribute.attributes.size(); ++i) {
            this.attributes[i] = reader.getNextInt();
        }
    }

    public UpdateClientAttributesPacket(PlayerData playerData) {
        this.attributes = playerData.getAttributePointsUsed();
        this.playerName = playerData.playerName;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextString(this.playerName);
        for (int i = 0; i < Attribute.attributes.size(); ++i) {
            writer.putNextInt(playerData.getAttributePoints(i));
        }
    }

    public void processClient(NetworkPacket packet, Client client) {
        PlayerData playerData = PlayerDataList.getPlayerData(this.playerName, false);
        if (playerData != null) {
            playerData.setAttributes(this.attributes);
        }
    }
}

