/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import necesse.engine.GameLog;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.client.ClientClient;
import necesse.engine.network.packet.PacketDisconnect;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.Mob;
import rpgclasses.mobs.mount.TransformationMountMob;

public class TransformationAbility1Packet
extends Packet {
    public final int slot;
    public final int x;
    public final int y;

    public TransformationAbility1Packet(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.slot = reader.getNextByteUnsigned();
        this.x = reader.getNextInt();
        this.y = reader.getNextInt();
    }

    public TransformationAbility1Packet(int slot, int x, int y) {
        this.slot = slot;
        this.x = x;
        this.y = y;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextByteUnsigned(slot);
        writer.putNextInt(x);
        writer.putNextInt(y);
    }

    public void processClient(NetworkPacket packet, Client client) {
        Mob mount2;
        ClientClient target;
        if (client.getLevel() != null && (target = client.getClient(this.slot)) != null && target.isSamePlace(client.getLevel()) && (mount2 = target.playerMob.getMount()) instanceof TransformationMountMob) {
            TransformationMountMob transformation = (TransformationMountMob)mount2;
            transformation.clickRunClient(client.getLevel(), this.x, this.y, target.playerMob);
        }
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        if (client.slot == this.slot) {
            TransformationMountMob transformation;
            if (!client.checkHasRequestedSelf() || client.isDead()) {
                return;
            }
            Mob mount2 = client.playerMob.getMount();
            if (mount2 instanceof TransformationMountMob && (transformation = (TransformationMountMob)mount2).canRunClick(client.playerMob)) {
                transformation.clickRunServer(client.getLevel(), this.x, this.y, client.playerMob);
                server.network.sendToClientsAtEntireLevelExcept((Packet)new TransformationAbility1Packet(this.slot, this.x, this.y), client.getLevel(), client);
            }
        } else {
            GameLog.warn.println(client.getName() + " tried to run transformation ability from wrong slot, kicking him for desync");
            server.disconnectClient(client, PacketDisconnect.Code.STATE_DESYNC);
        }
    }
}

