/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.util.GameRandom;
import necesse.entity.particle.Particle;
import necesse.entity.particle.fireworks.FireworksExplosion;
import necesse.entity.particle.fireworks.FireworksRocketParticle;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.item.placeableItem.FireworkPlaceableItem;
import necesse.level.maps.Level;
import necesse.level.maps.hudManager.HudDrawElement;
import necesse.level.maps.hudManager.floatText.FloatTextFade;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.ui.CustomUIManager;

public class ShowModExpPacket
extends Packet {
    public final int x;
    public final int y;
    public final int exp;
    public final boolean levelUp;

    public ShowModExpPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.x = reader.getNextInt();
        this.y = reader.getNextInt();
        this.exp = reader.getNextInt();
        this.levelUp = reader.getNextBoolean();
    }

    public ShowModExpPacket(int x, int y, int exp, boolean levelUp) {
        this.x = x;
        this.y = y;
        this.exp = exp;
        this.levelUp = levelUp;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(x);
        writer.putNextInt(y);
        writer.putNextInt(exp);
        writer.putNextBoolean(levelUp);
    }

    public void processClient(NetworkPacket packet, Client client) {
        if (this.exp != 0) {
            FloatTextFade text = new FloatTextFade(this.x, this.y - 20, (this.exp > 0 ? "+" + this.exp : Integer.valueOf(this.exp)) + " " + Localization.translate((String)"message", (String)"xp") + (this.levelUp ? " - " + Localization.translate((String)"message", (String)"levelup") : ""), new FontOptions(16).outline().color(this.exp > 0 ? new Color(100, 200, 100) : new Color(200, 100, 100))){

                public int getAnchorX() {
                    return ShowModExpPacket.this.x;
                }

                public int getAnchorY() {
                    return ShowModExpPacket.this.y - 20;
                }
            };
            Level level = client.getLevel();
            level.hudManager.addElement((HudDrawElement)text);
            if (this.levelUp) {
                level.entityManager.addParticle((Particle)new FireworksRocketParticle(level, (float)this.x, (float)this.y, 600L, 300, ShowModExpPacket.getExplosion(GameRandom.globalRandom), GameRandom.globalRandom), true, Particle.GType.CRITICAL);
            }
            PlayerData playerData = PlayerDataList.getPlayerData(client.getPlayer());
            CustomUIManager.expBar.updateExpBar(playerData);
        }
    }

    public static FireworksExplosion getExplosion(GameRandom random) {
        FireworksExplosion explosion = new FireworksExplosion(null);
        FireworkPlaceableItem.FireworksShape.Star.explosionModifier.play(explosion, 250.0f, random);
        FireworkPlaceableItem.FireworkColor.Confetti.explosionModifier.accept(explosion);
        FireworkPlaceableItem.FireworkCrackle.Crackle.explosionModifier.accept(explosion);
        return explosion;
    }
}

