/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.level.maps.Level;

public class PacketMobUpdateIgniteBuff
extends Packet {
    public final int mobUniqueID;
    public final String buffStringID;
    public final int duration;
    public final float damage;

    public PacketMobUpdateIgniteBuff(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.mobUniqueID = reader.getNextInt();
        this.buffStringID = reader.getNextString();
        this.duration = reader.getNextInt();
        this.damage = reader.getNextFloat();
    }

    public PacketMobUpdateIgniteBuff(int mobUniqueID, ActiveBuff ab) {
        this.mobUniqueID = mobUniqueID;
        this.buffStringID = ab.buff.getStringID();
        this.duration = ab.getDurationLeft();
        this.damage = ab.getGndData().getFloat("igniteDamage");
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(mobUniqueID);
        writer.putNextString(this.buffStringID);
        writer.putNextInt(this.duration);
        writer.putNextFloat(this.damage);
    }

    public void processClient(NetworkPacket packet, Client client) {
        ActiveBuff ab;
        Mob mob = GameUtils.getLevelMob((int)this.mobUniqueID, (Level)client.getLevel());
        if (mob != null && (ab = mob.buffManager.getBuff(this.buffStringID)) != null) {
            ab.getGndData().setFloat("igniteDamage", this.damage);
            ab.setModifier(BuffModifiers.FIRE_DAMAGE_FLAT, (Object)Float.valueOf(this.damage));
            ab.setDurationLeft(this.duration);
        }
    }
}

