/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.level.maps.Level;

public class PacketMobResetBuffTime
extends Packet {
    public final int mobUniqueID;
    public final String buffStringID;

    public PacketMobResetBuffTime(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.mobUniqueID = reader.getNextInt();
        this.buffStringID = reader.getNextString();
    }

    public PacketMobResetBuffTime(int mobUniqueID, String buffStringID) {
        this.mobUniqueID = mobUniqueID;
        this.buffStringID = buffStringID;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(mobUniqueID);
        writer.putNextString(buffStringID);
    }

    public void processClient(NetworkPacket packet, Client client) {
        ActiveBuff ab;
        Mob mob = GameUtils.getLevelMob((int)this.mobUniqueID, (Level)client.getLevel());
        if (mob != null && (ab = mob.buffManager.getBuff(this.buffStringID)) != null) {
            ab.getGndData().setInt("time", 0);
            ab.getGndData().setBoolean("ready", false);
        }
    }
}

