/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import java.util.Objects;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.ui.CustomUIManager;
import rpgclasses.ui.RPGSkillUIManager;

public class LoadPlayerDataPacket
extends Packet {
    public final int slot;
    public final String playerName;
    public final PlayerData playerData;

    public LoadPlayerDataPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.slot = reader.getNextInt();
        this.playerName = reader.getNextString();
        this.playerData = reader.hasNext() ? PlayerData.applyPacket(reader) : null;
    }

    public LoadPlayerDataPacket(int slot, String playerName, PlayerData playerData) {
        this.slot = slot;
        this.playerName = playerName;
        this.playerData = playerData;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(slot);
        writer.putNextString(playerName);
        if (playerData != null) {
            playerData.setupPacket(writer);
        }
    }

    public void processClient(NetworkPacket packet, Client client) {
        PlayerDataList.setPlayerData(this.playerName, this.playerData, false);
        if (client.getPlayer() != null && Objects.equals(client.getPlayer().playerName, this.playerName) && CustomUIManager.expBar != null) {
            CustomUIManager.expBar.updateExpBar(this.playerData);
            RPGSkillUIManager.updateContent(this.playerData);
        }
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        PlayerData playerData = PlayerDataList.getPlayerData(this.playerName, true);
        long worldUniqueID = server.world.getUniqueID();
        if (playerData == null || playerData.worldUniqueID != worldUniqueID) {
            playerData = PlayerDataList.initPlayerData(this.playerName, worldUniqueID, true);
        }
        PlayerData finalPlayerData = playerData;
        server.network.sendToAllClients((Packet)new LoadPlayerDataPacket(this.slot, this.playerName, finalPlayerData));
        ServerClient clientTarget = server.getClient(this.slot);
        finalPlayerData.updateAllBuffs(clientTarget.playerMob);
    }
}

