/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.packets;

import necesse.engine.GameLog;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.client.ClientClient;
import necesse.engine.network.packet.PacketDisconnect;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.inventory.item.Item;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class ActiveAbilityRunPacket
extends Packet {
    public final int slot;
    public final int skillSlot;

    public ActiveAbilityRunPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.slot = reader.getNextByteUnsigned();
        this.skillSlot = reader.getNextInt();
    }

    public ActiveAbilityRunPacket(int slot, int skillSlot) {
        this.slot = slot;
        this.skillSlot = skillSlot;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextByteUnsigned(slot);
        writer.putNextInt(skillSlot);
    }

    public void processClient(NetworkPacket packet, Client client) {
        ClientClient target;
        if (client.getLevel() != null && (target = client.getClient(this.slot)) != null && target.playerMob.getLevel() != null) {
            int activeSkillLevel;
            PlayerMob player = client.getClient((int)this.slot).playerMob;
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            EquippedActiveSkill equippedActiveSkill = playerData.equippedActiveSkills[this.skillSlot];
            if (!equippedActiveSkill.isEmpty() && (activeSkillLevel = equippedActiveSkill.getActiveSkill().getLevel(playerData)) > 0) {
                int seed = Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom);
                equippedActiveSkill.getActiveSkill().runClient(player, playerData, activeSkillLevel, seed, equippedActiveSkill.isInUse());
            }
        }
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        if (client.slot == this.slot) {
            if (!client.checkHasRequestedSelf() || client.isDead()) {
                return;
            }
            PlayerMob player = client.playerMob;
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            EquippedActiveSkill equippedActiveSkill = playerData.equippedActiveSkills[this.skillSlot];
            if (equippedActiveSkill.getActiveSkill() != null) {
                int activeSkillLevel = equippedActiveSkill.getActiveSkill().getLevel(playerData);
                if (!equippedActiveSkill.isEmpty() && equippedActiveSkill.getActiveSkill().canActive(player, playerData, activeSkillLevel, equippedActiveSkill.isInUse()) == null && activeSkillLevel > 0) {
                    int seed = Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom);
                    equippedActiveSkill.getActiveSkill().runServer(player, playerData, activeSkillLevel, seed, equippedActiveSkill.isInUse());
                    server.network.sendToClientsWithEntityExcept((Packet)new ActiveAbilityRunPacket(this.slot, this.skillSlot), (RegionPositionGetter)client.playerMob, client);
                }
            }
        } else {
            GameLog.warn.println(client.getName() + " tried to run Active Skill from wrong slot, kicking him for desync");
            server.disconnectClient(client, PacketDisconnect.Code.STATE_DESYNC);
        }
    }
}

