/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.summons.passive;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.NetworkClient;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import rpgclasses.content.player.PlayerClasses.Ranger.Passives.WolfCompanion;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.ai.CustomSummonCollisionChaserAI;
import rpgclasses.mobs.summons.passive.PassiveFollowingMob;
import rpgclasses.utils.RPGUtils;

public class RangerWolfMob
extends PassiveFollowingMob {
    public static GameTexture texture;

    public RangerWolfMob() {
        super(10);
        this.setSpeed(45.0f);
        this.setFriction(4.0f);
        this.moveAccuracy = 8;
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle(-18, -24, 36, 36);
        this.swimMaskMove = 16;
        this.swimMaskOffset = 0;
        this.swimSinkOffset = -12;
        this.attackCooldown = 500;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new CustomSummonCollisionChaserAI<RangerWolfMob>(1024, this.getDamage(), 30, 500, 640, 64, null){

            @Override
            public Mob getCustomFocus(RangerWolfMob mob, int searchDistance) {
                if (!(RangerWolfMob.this.getFollowingMob() instanceof PlayerMob)) {
                    return null;
                }
                PlayerMob player = (PlayerMob)RangerWolfMob.this.getFollowingMob();
                return RPGUtils.findBestTarget((Mob)player, mob.x, mob.y, 1000, RPGUtils.isMarkedFilter(player));
            }
        });
    }

    public void playDeathSound() {
        SoundManager.playSound((GameSound)GameResources.teleport, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.8f));
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 36;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd body = texture.initDraw().sprite(sprite.x, sprite.y, 64).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)body){
            final /* synthetic */ DrawOptions val$body;
            {
                this.val$body = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$body.draw();
                swimMask.stop();
            }
        });
        TextureDrawOptionsEnd shadow = MobRegistry.Textures.snowWolf.shadow.initDraw().sprite(0, sprite.y, 64).light(light).pos(drawX, drawY);
        tileList.add(arg_0 -> RangerWolfMob.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
    }

    public int getRockSpeed() {
        return 7;
    }

    public GameDamage getDamage() {
        NetworkClient client = this.getFollowingClient();
        if (client == null) {
            return new GameDamage(0.0f);
        }
        PlayerData playerData = PlayerDataList.getPlayerData(client.playerMob);
        int skillLevel = this.getPassiveLevel(playerData);
        return new GameDamage(DamageTypeRegistry.SUMMON, WolfCompanion.params[0].value(playerData.getLevel(), skillLevel));
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
        shadow.draw();
    }
}

