/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.summons.damageable.necrotic;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.registries.MobRegistry;
import necesse.engine.seasons.GameSeasons;
import necesse.engine.seasons.SeasonalHat;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import rpgclasses.content.player.SkillsLogic.ComplexExtraToolTip;
import rpgclasses.data.PlayerData;
import rpgclasses.mobs.summons.damageable.necrotic.NecroticFollowingMob;

public class NecromancerSkeletonWarriorMob
extends NecroticFollowingMob {
    protected SeasonalHat hat;

    public NecromancerSkeletonWarriorMob() {
        super(50);
        this.setSpeed(60.0f);
        this.setFriction(3.0f);
        this.setKnockbackModifier(0.4f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle(-14, -41, 28, 48);
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
    }

    @Override
    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI(576, this.summonDamage, 100, 500, Integer.MAX_VALUE, 64));
        this.hat = GameSeasons.getHat((GameRandom)new GameRandom((long)this.getUniqueID()));
    }

    public void playHitSound() {
        float pitch = ((Float)GameRandom.globalRandom.getOneOf((Object[])new Float[]{Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f)})).floatValue();
        SoundManager.playSound((GameSound)GameResources.crack, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(1.6f).pitch(pitch));
    }

    public void playDeathSound() {
        float pitch = ((Float)GameRandom.globalRandom.getOneOf((Object[])new Float[]{Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f)})).floatValue();
        SoundManager.playSound((GameSound)GameResources.crackdeath, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.8f).pitch(pitch));
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.ancientArmoredSkeleton.body, GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, MobRegistry.Textures.ancientArmoredSkeleton).sprite(sprite).dir(dir).mask(swimMask).light(light);
        final DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable(){

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public int getRockSpeed() {
        return 20;
    }

    @Override
    public Stream<ModifierValue<?>> getDefaultModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.FRICTION, (Object)Float.valueOf(0.0f)).min((Object)Float.valueOf(0.75f)));
    }

    @Override
    public int getHealthStat(PlayerMob player, PlayerData playerData) {
        return ComplexExtraToolTip.get("necromancerskeletonwarrior")[0].valuePlayerInt(playerData.getLevel());
    }

    @Override
    public float getDamageStat(PlayerMob player, PlayerData playerData) {
        return ComplexExtraToolTip.get("necromancerskeletonwarrior")[1].valuePlayerInt(playerData.getLevel());
    }
}

