/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.summons.damageable;

import aphorea.utils.AphColors;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.MobRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import rpgclasses.content.player.PlayerClasses.Necromancer.ActiveSkills.Tomb;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.summons.damageable.DamageableFollowingMob;

public class NecromancerTombMob
extends DamageableFollowingMob {
    public static GameTexture texture;
    public static String prefixDataName;
    public static String skillLevelDataName;
    public static String timeToSpawnDataName;
    public int skillLevel = 0;
    public int timeToSpawn = 0;

    @Override
    public void applyLoadData(LoadData load) {
        super.applyLoadData(load);
        this.skillLevel = load.getInt(skillLevelDataName);
        this.timeToSpawn = load.getInt(timeToSpawnDataName);
    }

    @Override
    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt(skillLevelDataName, this.skillLevel);
        save.addInt(timeToSpawnDataName, this.timeToSpawn);
    }

    @Override
    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.skillLevel = reader.getNextInt();
    }

    @Override
    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.skillLevel);
    }

    public void setSkillLevel(int skillLevel) {
        this.skillLevel = skillLevel;
    }

    public NecromancerTombMob() {
        super(50);
        this.setSpeed(0.0f);
        this.setFriction(Float.MAX_VALUE);
        this.setKnockbackModifier(0.0f);
        this.collision = new Rectangle(-16, -28, 32, 32);
        this.hitBox = new Rectangle(-16, -28, 32, 32);
        this.selectBox = new Rectangle(-16, -28, 32, 32);
    }

    public boolean canPushMob(Mob other) {
        return false;
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        this.timeToSpawn -= 50;
        if (this.timeToSpawn <= 0 && this.isFollowing()) {
            this.timeToSpawn = (10 - this.skillLevel) * 1000;
            PlayerMob player = (PlayerMob)this.getFollowingMob();
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            DamageableFollowingMob mob = (DamageableFollowingMob)MobRegistry.getMob((String)"necromancerskeleton", (Level)this.getLevel());
            player.serverFollowersManager.addFollower(this.getStringID(), (Mob)mob, FollowPosition.WALK_CLOSE, null, 1.0f, Integer.MAX_VALUE, null, true);
            mob.updateStats(player, playerData);
            player.getLevel().entityManager.addMob((Mob)mob, this.x, this.y);
        }
    }

    public void playHitSound() {
        float pitch = ((Float)GameRandom.globalRandom.getOneOf((Object[])new Float[]{Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f)})).floatValue();
        SoundManager.playSound((GameSound)GameResources.crack, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(1.6f).pitch(pitch));
    }

    public void playDeathSound() {
        float pitch = ((Float)GameRandom.globalRandom.getOneOf((Object[])new Float[]{Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f)})).floatValue();
        SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.8f).pitch(pitch));
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        ParticleTypeSwitcher particleTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
        for (int i = 0; i < 20; ++i) {
            int angle = (int)(360.0f + GameRandom.globalRandom.nextFloat() * 360.0f);
            float dx = (float)Math.sin(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
            float dy = (float)Math.cos(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
            this.getLevel().entityManager.addParticle((Entity)this, particleTypeSwitcher.next()).movesFriction(dx, dy, 0.8f).color(AphColors.stone).heightMoves(10.0f, 30.0f).lifeTime(500);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 16;
        int drawY = camera.getDrawY(y) - 16 - 12;
        drawY += this.getBobbing(x, y);
        TextureDrawOptionsEnd drawOptions = texture.initDraw().light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)drawOptions){
            final /* synthetic */ DrawOptions val$drawOptions;
            {
                this.val$drawOptions = drawOptions;
            }

            public void draw(TickManager tickManager) {
                this.val$drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public Point getAnimSprite(int x, int y, int dir) {
        return new Point();
    }

    @Override
    public int getHealthStat(PlayerMob player, PlayerData playerData) {
        return Tomb.params[1].valueInt(playerData.getLevel(), this.skillLevel);
    }

    @Override
    public float getDamageStat(PlayerMob player, PlayerData playerData) {
        return 0.0f;
    }

    static {
        prefixDataName = "rpgmod_summon_";
        skillLevelDataName = prefixDataName + "skillLevel";
        timeToSpawnDataName = prefixDataName + "timeToSpawn";
    }
}

