/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.summons.damageable;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.util.GameMath;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.gfx.GameColor;
import necesse.gfx.Renderer;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.ProgressBarDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.InputTooltip;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.gfx.ui.GameInterfaceStyle;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import rpgclasses.RPGResources;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public abstract class DamageableFollowingMob
extends AttackingFollowingMob {
    public static String prefixDataName = "rpgmod_summon_";
    public static String initialMaxHealthDataName = prefixDataName + "initialMaxHealth";
    public static String keepDecreaseDataName = prefixDataName + "keepDecrease";
    int initialMaxHealth = 0;
    float keepDecrease = 0.0f;

    public DamageableFollowingMob(int health) {
        super(health);
        this.isStatic = false;
    }

    public void applyLoadData(LoadData load) {
        super.applyLoadData(load);
        this.initialMaxHealth = load.getInt(initialMaxHealthDataName);
        this.keepDecrease = load.getFloat(keepDecreaseDataName);
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt(initialMaxHealthDataName, this.initialMaxHealth);
        save.addFloat(keepDecreaseDataName, this.keepDecrease);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.initialMaxHealth = reader.getNextInt();
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.initialMaxHealth);
    }

    public boolean onMouseHover(GameCamera camera, PlayerMob perspective, boolean debug) {
        if (!debug && !this.isVisible()) {
            return false;
        }
        ListGameTooltips tips = new ListGameTooltips();
        this.addHoverTooltips(tips, debug);
        if (debug) {
            if (!WindowManager.getWindow().isKeyDown(340)) {
                this.addDebugTooltips(tips);
            } else {
                List modTips = this.buffManager.getModifierTooltips().stream().map(mf -> mf.toTooltip(true)).collect(Collectors.toList());
                if (modTips.isEmpty()) {
                    tips.add((Object)new StringTooltips(Localization.translate((String)"bufftooltip", (String)"nomodifiers"), GameColor.YELLOW));
                } else {
                    tips.addAll(modTips);
                }
            }
        }
        if (this.canInteract((Mob)perspective)) {
            String controlMsg;
            Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
            if (Settings.showControlTips && (controlMsg = this.getInteractTip(perspective, debug)) != null) {
                tips.add((Object)new InputTooltip(Control.MOUSE2, controlMsg, this.inInteractRange((Mob)perspective) ? 1.0f : 0.7f));
            }
        }
        GameTooltipManager.addTooltip((GameTooltips)tips, (TooltipLocation)TooltipLocation.INTERACT_FOCUS);
        return true;
    }

    public float getHealthDecreasePerSecond() {
        return 0.02f;
    }

    public void serverTick() {
        super.serverTick();
        if (this.getHealthDecreasePerSecond() > 0.0f) {
            int maxHealth = this.getMaxHealthFlat();
            if (maxHealth <= 1) {
                this.remove(0.0f, 0.0f, null, true);
            } else {
                int trueDecrease;
                float decrease = (float)this.initialMaxHealth * this.getHealthDecreasePerSecond() / 20.0f + this.keepDecrease;
                float keeping = decrease - (float)(trueDecrease = (int)decrease);
                if (keeping > 0.0f) {
                    this.keepDecrease = keeping;
                }
                this.setHealth(this.getHealth() - trueDecrease);
                this.setMaxHealth(maxHealth - trueDecrease);
            }
        }
    }

    public void clientTick() {
        super.clientTick();
        if (this.getHealthDecreasePerSecond() > 0.0f) {
            int maxHealth = this.getMaxHealthFlat();
            if (maxHealth <= 1) {
                this.remove(0.0f, 0.0f, null, true);
            } else {
                int trueDecrease;
                float decrease = (float)this.initialMaxHealth * this.getHealthDecreasePerSecond() / 20.0f + this.keepDecrease;
                float keeping = decrease - (float)(trueDecrease = (int)decrease);
                if (keeping > 0.0f) {
                    this.keepDecrease = keeping;
                }
                this.setMaxHealth(maxHealth - trueDecrease);
            }
        }
    }

    public abstract int getHealthStat(PlayerMob var1, PlayerData var2);

    public abstract float getDamageStat(PlayerMob var1, PlayerData var2);

    public void updateStats(PlayerMob player, PlayerData playerData) {
        this.updateStats(player, playerData, 1.0f);
    }

    public void updateStats(PlayerMob player, PlayerData playerData, float mod) {
        this.updateStats(player, playerData, mod, mod);
    }

    public void updateStats(PlayerMob player, PlayerData playerData, float healthMod, float damageMod) {
        this.updateStats((int)((float)this.getHealthStat(player, playerData) * healthMod), this.getDamageStat(player, playerData) * damageMod);
    }

    public void updateStats(int health, float damage) {
        this.setMaxHealth(Math.max(1, health));
        this.setHealthHidden(Math.max(1, health));
        this.initialMaxHealth = Math.max(1, health);
        this.updateDamage(new GameDamage(DamageTypeRegistry.SUMMON, damage));
    }

    public boolean isHealthBarVisible() {
        return super.isHealthBarVisible() && this.getHealth() < this.getMaxHealth() - 2;
    }

    public Rectangle getTimeBarBounds(int x, int y, int style) {
        Rectangle selectBox = this.getSelectBox(x, y);
        int width = GameMath.limit((int)selectBox.width, (int)32, (int)64);
        x = selectBox.x + selectBox.width / 2 - width / 2;
        y = selectBox.y - RPGResources.UI_TEXTURES.timebar_texture[style].getHeight() - 1;
        if (this.isHealthBarVisible()) {
            y -= 11;
        }
        return new Rectangle(x, y, width, RPGResources.UI_TEXTURES.timebar_texture[style].getHeight());
    }

    public void addStatusBarDrawable(OrderableDrawables list, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addStatusBarDrawable(list, level, x, y, tickManager, camera, perspective);
        if (this.getHealthDecreasePerSecond() > 0.0f) {
            int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
            Rectangle bounds = this.getTimeBarBounds(x, y, style);
            int maxHealth = this.getMaxHealth();
            float perc = GameMath.limit((float)(((float)maxHealth - 1.0f) / ((float)this.initialMaxHealth - 1.0f)), (float)0.0f, (float)1.0f);
            int drawX = camera.getDrawX(bounds.x);
            int drawY = camera.getDrawY(bounds.y);
            GameLight light = level.getLightLevel((bounds.x + bounds.width / 2) / 32, (bounds.y + 4) / 32);
            float alphaMod = GameMath.lerp((float)light.getFloatLevel(), (float)0.2f, (float)1.0f);
            Color statusColor = DamageableFollowingMob.getStatusColorOrangePref(perc, 0.75f, 0.7f, 2.2f);
            Color finalFillColor = new Color(statusColor.getRed(), statusColor.getGreen(), statusColor.getBlue(), (int)(240.0f * alphaMod));
            Color finalBackgroundColor = new Color(statusColor.getRed(), statusColor.getGreen(), statusColor.getBlue(), (int)(190.0f * alphaMod));
            DrawOptions options = new ProgressBarDrawOptions(Settings.UI.healthbar_small_fill, bounds.width).color(finalBackgroundColor).addBar(RPGResources.UI_TEXTURES.timebar_texture[style], perc).color(finalFillColor).minWidth(4).end().pos(drawX, drawY);
            list.add(tm -> options.draw());
        }
    }

    public static Color getStatusColorOrangePref(float percent, float saturation, float brightness, float exponent) {
        percent = (float)Math.pow(percent, exponent);
        float hue = 0.1f + 0.04f * percent;
        return Color.getHSBColor(hue, saturation, brightness);
    }

    public Stream<ModifierValue<?>> getDefaultModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.HEALTH_REGEN_FLAT).max((Object)Float.valueOf(0.0f)), new ModifierValue(BuffModifiers.COMBAT_HEALTH_REGEN_FLAT).max((Object)Float.valueOf(0.0f)), new ModifierValue(BuffModifiers.HEALTH_REGEN).max((Object)Float.valueOf(0.0f)), new ModifierValue(BuffModifiers.COMBAT_HEALTH_REGEN).max((Object)Float.valueOf(0.0f)));
    }

    public void init() {
        PlayerData playerData;
        super.init();
        Mob followingMob = this.getFollowingMob();
        if (followingMob instanceof PlayerMob && (playerData = PlayerDataList.getPlayerData((PlayerMob)followingMob)).hasMasterySkill(Mastery.IRON_INVOKER)) {
            Mastery.IRON_INVOKER.giveDatalessSecondaryPassiveBuff((Mob)this, 3600000);
        }
    }
}

