/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.summons.damageable;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import rpgclasses.buffs.MagicPoisonBuff;
import rpgclasses.content.player.PlayerClasses.Druid.ActiveSkills.QueenBeeTransformation;
import rpgclasses.content.player.SkillsLogic.ComplexExtraToolTip;
import rpgclasses.data.PlayerData;
import rpgclasses.mobs.ai.CustomSummonCollisionChaserAI;
import rpgclasses.mobs.summons.damageable.DamageableFollowingMob;
import rpgclasses.registry.RPGBuffs;

public class BeeDamageableSummonMob
extends DamageableFollowingMob {
    public BeeDamageableSummonMob() {
        super(1);
        this.setSpeed(100.0f);
        this.setFriction(2.0f);
        this.setSwimSpeed(1.0f);
        this.collision = new Rectangle(-7, -5, 14, 10);
        this.hitBox = new Rectangle(-12, -14, 24, 24);
        this.selectBox = new Rectangle(-16, -28, 32, 34);
    }

    @Override
    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new CustomSummonCollisionChaserAI<BeeDamageableSummonMob>(1024, this.summonDamage, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, 64, mob -> {
            if (!(this.getFollowingMob() instanceof PlayerMob)) {
                return false;
            }
            PlayerMob player = (PlayerMob)this.getFollowingMob();
            return player.buffManager.hasBuff(RPGBuffs.AGGRESSIVE_BEES) || !player.isRiding() || !(player.getMount() instanceof QueenBeeTransformation.QueenBeeMob);
        }){

            @Override
            public boolean attackTarget(BeeDamageableSummonMob mob, Mob target) {
                boolean hits = super.attackTarget(mob, target);
                if (hits) {
                    if (BeeDamageableSummonMob.this.getFollowingMob() instanceof PlayerMob) {
                        PlayerMob player = (PlayerMob)BeeDamageableSummonMob.this.getFollowingMob();
                        MagicPoisonBuff.apply((Mob)player, target, this.damage.damage * 0.2f, 10.0f);
                    }
                    mob.remove(0.0f, 0.0f, null, true);
                }
                return hits;
            }
        });
    }

    public void playHitSound() {
        float pitch = ((Float)GameRandom.globalRandom.getOneOf((Object[])new Float[]{Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f)})).floatValue();
        SoundManager.playSound((GameSound)GameResources.crack, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(1.6f).pitch(pitch));
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 16;
        int drawY = camera.getDrawY(y) - 22;
        int dir = this.getDir();
        int animationTime = 1000;
        long time = level.getTime();
        Point sprite = this.getAnimSprite(x, y, dir);
        TextureDrawOptionsEnd shadow = MobRegistry.Textures.honeyBee.shadow.initDraw().sprite(0, dir, 32).light(light).pos(drawX, drawY);
        tileList.add(arg_0 -> BeeDamageableSummonMob.lambda$addDrawables$1((TextureDrawOptions)shadow, arg_0));
        float bobbingFloat = GameUtils.getBobbing((long)(time += (long)new GameRandom((long)this.getUniqueID()).nextInt(animationTime)), (int)animationTime);
        drawY -= 6;
        drawY = (int)((float)drawY + bobbingFloat * 5.0f);
        TextureDrawOptionsEnd options = MobRegistry.Textures.honeyBee.body.initDraw().sprite(sprite.x, sprite.y, 32).light(light).pos(drawX, drawY);
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public Point getAnimSprite(int x, int y, int dir) {
        long time = this.getTime();
        return new Point(GameUtils.getAnim((long)(time += (long)new GameRandom((long)this.getUniqueID()).nextInt(200)), (int)2, (int)200), dir);
    }

    @Override
    public int getHealthStat(PlayerMob player, PlayerData playerData) {
        return ComplexExtraToolTip.get("bee")[0].valuePlayerInt(playerData.getLevel());
    }

    @Override
    public float getDamageStat(PlayerMob player, PlayerData playerData) {
        return ComplexExtraToolTip.get("bee")[1].valuePlayerInt(playerData.getLevel());
    }

    @Override
    public float getHealthDecreasePerSecond() {
        return 0.0f;
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    public boolean canPushMob(Mob other) {
        return false;
    }

    private static /* synthetic */ void lambda$addDrawables$1(TextureDrawOptions shadow, TickManager tm) {
        shadow.draw();
    }
}

