/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.summons;

import necesse.engine.network.NetworkClient;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.content.player.SkillsLogic.SkillsList;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class SkillFollowingMob
extends AttackingFollowingMob {
    public static String prefixDataName = "rpgmod_summon_";
    public static String classDataName = prefixDataName + "class";
    public static String isPassiveDataName = prefixDataName + "isPassive";
    public static String skillDataName = prefixDataName + "skill";
    public PlayerClass playerClass;
    boolean isPassive;
    public Skill skill;

    public SkillFollowingMob(int health) {
        super(health);
    }

    public void setSkill(Skill skill) {
        this.playerClass = skill.playerClass;
        this.isPassive = skill instanceof Passive;
        this.skill = skill;
    }

    public void applyLoadData(LoadData load) {
        super.applyLoadData(load);
        this.playerClass = PlayerClass.classesList.get(load.getInt(classDataName));
        this.isPassive = load.getBoolean(classDataName);
        this.skill = this.getSkillList(this.playerClass).get(load.getInt(skillDataName));
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt(classDataName, this.playerClass.id);
        save.addBoolean(isPassiveDataName, this.isPassive);
        save.addInt(skillDataName, this.skill.id);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.playerClass = PlayerClass.classesList.get(reader.getNextInt());
        this.isPassive = reader.getNextBoolean();
        this.skill = this.playerClass.passivesList.get(reader.getNextInt());
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.playerClass.id);
        writer.putNextBoolean(this.isPassive);
        writer.putNextInt(this.skill.id);
    }

    public SkillsList<?> getSkillList(PlayerClass playerClass) {
        return this.isPassive ? playerClass.passivesList : playerClass.activeSkillsList;
    }

    public PlayerData getPlayerData() {
        NetworkClient client = this.getFollowingClient();
        if (client == null) {
            return null;
        }
        return PlayerDataList.getPlayerData(client.playerMob);
    }

    public PlayerClassData getClassData(PlayerData playerData) {
        if (playerData == null) {
            return null;
        }
        return playerData.getClassesData()[this.playerClass.id];
    }
}

