/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.mount;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketMobMovement;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.ActiveMountAbility;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ParticleOption;
import necesse.entity.particle.SmokePuffParticle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.InventoryItem;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.RPGResources;
import rpgclasses.buffs.Interfaces.TransformationClassBuff;

public class TransformationMountMob
extends Mob
implements ActiveMountAbility {
    public int colorInt;
    public long nextRunClick = 0L;
    public long nextRunSecondaryClick = 0L;

    public TransformationMountMob() {
        super(100);
        this.setSpeed(40.0f);
        this.setFriction(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle(-14, -41, 28, 48);
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
    }

    protected void doMountedLogic() {
        super.doMountedLogic();
        TransformationClassBuff.apply(this);
    }

    public void onActiveMountAbilityUpdate(PlayerMob playerMob, Packet packet) {
    }

    public void onActiveMountAbilityStopped(PlayerMob playerMob) {
    }

    public boolean canRunMountAbility(PlayerMob player, Packet content) {
        return true;
    }

    public void onActiveMountAbilityStarted(PlayerMob playerMob, Packet packet) {
    }

    public boolean tickActiveMountAbility(PlayerMob playerMob, boolean isRunningClient) {
        return false;
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt("colorInt", this.colorInt);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.colorInt = save.getInt("colorInt");
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.colorInt);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.colorInt = reader.getNextInt();
    }

    public void init() {
        super.init();
        if (this.isClient()) {
            Level level = this.getLevel();
            level.entityManager.addParticle((ParticleOption)new SmokePuffParticle(level, this.x, this.y + 5.0f, new Color(this.colorInt)), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void remove(float knockbackX, float knockbackY, Attacker attacker, boolean isDeath) {
        Level level = this.getLevel();
        level.entityManager.addParticle((ParticleOption)new SmokePuffParticle(level, this.x, this.y + 5.0f, new Color(this.colorInt)), Particle.GType.IMPORTANT_COSMETIC);
        super.remove(knockbackX, knockbackY, attacker, isDeath);
    }

    public void tickSendSyncPackets() {
        if (this.isServer() && this.sendNextMovementPacket) {
            Mob rider = this.getRider();
            if (rider != null && !rider.isPlayer) {
                ++this.moveSent;
                this.getLevel().getServer().network.sendToClientsWithEntity((Packet)new PacketMobMovement((Mob)this, this.nextMovementPacketDirect), (RegionPositionGetter)this);
                this.nextMovementPacketDirect = false;
            }
            this.movementUpdateTime = this.getTime();
            this.sendNextMovementPacket = false;
        }
        super.tickSendSyncPackets();
    }

    public void tickCurrentMovement(float delta) {
        this.moveX = 0.0f;
        this.moveY = 0.0f;
        Mob mounted = this.getRider();
        if (this.isMounted() && mounted != null && mounted.isPlayer) {
            this.setDir(mounted.getDir());
            this.moveX = mounted.moveX;
            this.moveY = mounted.moveY;
        } else if (this.currentMovement != null) {
            this.hasArrivedAtTarget = this.currentMovement.tick((Mob)this);
            if (this.stopMoveWhenArrive && this.hasArrivedAtTarget) {
                this.stopMoving();
            }
        } else {
            this.hasArrivedAtTarget = true;
        }
    }

    public void serverTick() {
        super.serverTick();
        if (this.getRider() == null) {
            this.remove();
        }
    }

    public void clientTick() {
        super.clientTick();
    }

    public boolean isVisible() {
        return this.isMounted();
    }

    public boolean canLevelInteract() {
        return this.isMounted();
    }

    public boolean canPushMob(Mob other) {
        return this.isMounted();
    }

    public boolean canBePushed(Mob other) {
        return this.isMounted();
    }

    public boolean canTakeDamage() {
        return false;
    }

    public boolean shouldDrawRider() {
        return false;
    }

    public boolean forceFollowRiderLevelChange(Mob rider) {
        return true;
    }

    public GameMessage getMountDismountError(Mob rider, InventoryItem item) {
        return new StaticMessage("");
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        return this.getRiderModifiers().stream();
    }

    public List<ModifierValue<?>> getRiderModifiers() {
        ArrayList modifiers = new ArrayList();
        modifiers.add(new ModifierValue(BuffModifiers.INTIMIDATED, (Object)true));
        return modifiers;
    }

    public boolean onMouseHover(GameCamera camera, PlayerMob perspective, boolean debug) {
        Mob rider = this.getRider();
        if (rider != null) {
            return rider.onMouseHover(camera, perspective, debug);
        }
        return false;
    }

    public GameTexture getTexture() {
        return RPGResources.mobsTexture.get(this.getStringID());
    }

    public void clickRunServer(Level level, int x, int y, PlayerMob player) {
        this.clickRun(level, x, y, player);
        this.nextRunClick = player.getTime() + (long)this.clickCooldown() - 50L;
    }

    public void clickRunClient(Level level, int x, int y, PlayerMob player) {
        this.clickRun(level, x, y, player);
        this.nextRunClick = player.getTime() + (long)this.clickCooldown();
    }

    public void clickRun(Level level, int x, int y, PlayerMob player) {
    }

    public void secondaryClickRunServer(Level level, int x, int y, PlayerMob player) {
        this.secondaryClickRun(level, x, y, player);
        this.nextRunSecondaryClick = player.getTime() + (long)this.secondaryClickCooldown() - 50L;
    }

    public void secondaryClickRunClient(Level level, int x, int y, PlayerMob player) {
        this.secondaryClickRun(level, x, y, player);
        this.nextRunSecondaryClick = player.getTime() + (long)this.secondaryClickCooldown();
    }

    public void secondaryClickRun(Level level, int x, int y, PlayerMob player) {
    }

    public int clickCooldown() {
        return 0;
    }

    public int secondaryClickCooldown() {
        return this.clickCooldown();
    }

    public boolean canRunClick(PlayerMob player) {
        return this.hasClick() && this.nextRunClick <= player.getTime();
    }

    public boolean hasClick() {
        return true;
    }

    public boolean canRunSecondaryClick(PlayerMob player) {
        return this.hasSecondaryClick() && this.nextRunSecondaryClick <= player.getTime();
    }

    public boolean hasSecondaryClick() {
        return false;
    }

    public boolean staminaBasedMountAbility() {
        return false;
    }

    public void onBeforeHit(PlayerMob player, MobBeforeHitEvent event) {
    }

    public void doResilienceGain(Mob attackedMob, float resilienceGain) {
        TransformationMountMob.doResilienceGain(this.getRider(), attackedMob, resilienceGain);
    }

    public static void doResilienceGain(Mob attacker, Mob attackedMob, float resilienceGain) {
        if (attacker != null && attackedMob.canGiveResilience((Attacker)attacker)) {
            attacker.addResilience(resilienceGain);
        }
    }
}

