/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.mobs.ai;

import java.util.function.Predicate;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.AINodeResult;
import necesse.entity.mobs.ai.behaviourTree.Blackboard;
import necesse.entity.mobs.ai.behaviourTree.composites.SelectorAINode;
import necesse.entity.mobs.ai.behaviourTree.composites.SequenceAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.CollisionChaserAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.FollowerBaseSetterAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.PlayerFollowerAINode;
import rpgclasses.mobs.ai.CustomSummonTargetFinderAINode;

public class CustomSummonCollisionChaserAI<T extends Mob>
extends SelectorAINode<T> {
    public GameDamage damage;
    public int knockback;

    public CustomSummonCollisionChaserAI(int searchDistance, GameDamage damage, int knockback, int hitCooldown, int teleportDistance, int stoppingDistance, Predicate<Mob> defaultTargets) {
        this.damage = damage;
        this.knockback = knockback;
        SequenceAINode chaserSequence = new SequenceAINode();
        chaserSequence.addChild((AINode)new FollowerBaseSetterAINode());
        chaserSequence.addChild((AINode)new SkillSummonFocusTargetSetterAINode<T>(searchDistance){

            @Override
            public Mob getCustomFocus(T mob, int searchDistance) {
                return CustomSummonCollisionChaserAI.this.getCustomFocus(mob, searchDistance);
            }
        });
        if (defaultTargets != null) {
            chaserSequence.addChild(new CustomSummonTargetFinderAINode(defaultTargets, searchDistance));
        }
        CollisionChaserAINode chaser = new CollisionChaserAINode<T>(){

            public boolean attackTarget(T mob, Mob target) {
                return CustomSummonCollisionChaserAI.this.attackTarget(mob, target);
            }
        };
        chaser.hitCooldowns.hitCooldown = hitCooldown;
        chaser.attackMoveCooldown = 0;
        chaserSequence.addChild((AINode)chaser);
        this.addChild((AINode)chaserSequence);
        this.addChild((AINode)new PlayerFollowerAINode(teleportDistance, stoppingDistance));
    }

    public boolean attackTarget(T mob, Mob target) {
        return CollisionChaserAINode.simpleAttack(mob, (Mob)target, (GameDamage)this.damage, (int)this.knockback);
    }

    public Mob getCustomFocus(T mob, int searchDistance) {
        return null;
    }

    public static class SkillSummonFocusTargetSetterAINode<T extends Mob>
    extends AINode<T> {
        public String focusTargetKey;
        public int searchDistance;

        public SkillSummonFocusTargetSetterAINode(String focusTargetKey, int searchDistance) {
            this.focusTargetKey = focusTargetKey;
            this.searchDistance = searchDistance;
        }

        public SkillSummonFocusTargetSetterAINode(int searchDistance) {
            this("currentTarget", searchDistance);
        }

        protected void onRootSet(AINode<T> root, T mob, Blackboard<T> blackboard) {
        }

        public void init(T mob, Blackboard<T> blackboard) {
        }

        public AINodeResult tick(T mob, Blackboard<T> blackboard) {
            Mob customFocus = this.getCustomFocus(mob, this.searchDistance);
            blackboard.put((Object)this.focusTargetKey, (Object)customFocus);
            return AINodeResult.SUCCESS;
        }

        public Mob getCustomFocus(T mob, int searchDistance) {
            return null;
        }
    }
}

