/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.levelevents;

import java.awt.Color;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.utils.RPGUtils;

public class RPGExplosionLevelEvent
extends ExplosionEvent
implements Attacker {
    private int particleBuffer;
    protected ParticleTypeSwitcher explosionTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC, Particle.GType.CRITICAL});
    public Color initialColor;
    public Color finalColor;

    public RPGExplosionLevelEvent() {
        this(0.0f, 0.0f, 50, new GameDamage(0.0f), null, false, new Color(255, 225, 155), new Color(200, 25, 29));
    }

    public RPGExplosionLevelEvent(float x, float y, int range, GameDamage damage, Mob owner, boolean hitsOwner, Color initialColor, Color finalColor) {
        super(x, y, range, damage, false, 0.0f, owner);
        this.targetRangeMod = 0.0f;
        this.hitsOwner = hitsOwner;
        this.initialColor = initialColor;
        this.finalColor = finalColor;
        this.destroysObjects = false;
        this.destroysTiles = false;
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.initialColor.getRGB());
        writer.putNextInt(this.finalColor.getRGB());
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.initialColor = new Color(reader.getNextInt(), true);
        this.finalColor = new Color(reader.getNextInt(), true);
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt("initialColor", this.initialColor.getRGB());
        save.addInt("finalColor", this.finalColor.getRGB());
    }

    public void applyLoadData(LoadData load) {
        super.applyLoadData(load);
        this.initialColor = new Color(load.getInt("initialColor"), true);
        this.finalColor = new Color(load.getInt("finalColor"), true);
    }

    protected void playExplosionEffects() {
        if (this.damage.damage < 2.0f) {
            SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.1f).pitch(1.0f));
        } else {
            SoundManager.playSound((GameSound)GameResources.explosionHeavy, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.8f).pitch(1.0f));
            this.level.getClient().startCameraShake(this.x, this.y, 200, 40, 1.0f, 0.8f, true);
        }
    }

    public void spawnExplosionParticle(float x, float y, float dirX, float dirY, int lifeTime, float range) {
        if (this.particleBuffer < 10) {
            ++this.particleBuffer;
        } else {
            this.particleBuffer = 0;
            if (range <= Math.max((float)this.range * 0.65f, 25.0f)) {
                float dx = dirX * GameRandom.globalRandom.getFloatBetween(0.3f, 0.4f) * (float)this.range;
                float dy = dirY * GameRandom.globalRandom.getFloatBetween(0.3f, 0.4f) * (float)this.range * 0.9f;
                this.getLevel().entityManager.addParticle(x, y, this.explosionTypeSwitcher.next()).sprite(GameResources.puffParticles.sprite(GameRandom.globalRandom.getIntBetween(0, 4), 0, 12)).sizeFades(70, 100).givesLight(180.0f, 1.0f).movesFriction(dx * 0.05f, dy * 0.05f, 0.8f).color((options, lifeTime1, timeAlive, lifePercent) -> {
                    float clampedLifePercent = Math.max(0.0f, Math.min(1.0f, lifePercent));
                    options.color(new Color((int)((float)this.initialColor.getRed() + (float)(this.finalColor.getRed() - this.initialColor.getRed()) * clampedLifePercent), (int)((float)this.initialColor.getGreen() + (float)(this.finalColor.getGreen() - this.initialColor.getGreen()) * clampedLifePercent), (int)((float)this.initialColor.getBlue() + (float)(this.finalColor.getBlue() - this.initialColor.getBlue()) * clampedLifePercent), (int)((float)this.initialColor.getAlpha() + (float)(this.finalColor.getAlpha() - this.initialColor.getAlpha()) * clampedLifePercent)));
                }).heightMoves(0.0f, 10.0f).lifeTime(lifeTime * 3);
            }
        }
    }

    protected boolean canHitMob(Mob target) {
        return RPGUtils.isValidTarget(this.ownerMob, target);
    }

    protected void onMobWasHit(Mob mob, float distance) {
        if (this.damage.damage > 1.0f) {
            super.onMobWasHit(mob, distance);
        }
    }
}

