/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.levelevents;

import java.awt.Color;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import rpgclasses.buffs.MagicPoisonBuff;
import rpgclasses.levelevents.RPGExplosionLevelEvent;

public class NecroticExplosionLevelEvent
extends RPGExplosionLevelEvent {
    public float poisonDamage;
    public int poisonTime;

    public NecroticExplosionLevelEvent() {
        this.poisonDamage = 0.0f;
        this.poisonTime = 0;
    }

    public NecroticExplosionLevelEvent(float x, float y, int range, GameDamage damage, Mob owner, float poisonDamage, int poisonTime) {
        super(x, y, range, damage, owner, false, new Color(10, 40, 10, damage == null ? 153 : 255), new Color(80, 255, 120, damage == null ? 153 : 255));
        this.poisonDamage = poisonDamage;
        this.poisonTime = poisonTime;
    }

    public NecroticExplosionLevelEvent(float x, float y, int range, Mob owner, float poisonDamage, int poisonTime) {
        this(x, y, range, new GameDamage(0.0f), owner, poisonDamage, poisonTime);
    }

    public NecroticExplosionLevelEvent(float x, float y, int range, GameDamage damage, Mob owner) {
        this(x, y, range, damage, owner, 0.0f, 0);
    }

    public NecroticExplosionLevelEvent(float x, float y, int range, GameDamage damage, Mob owner, float poisonDamage, float poisonTime) {
        this(x, y, range, damage, owner, poisonDamage, (int)(poisonTime * 1000.0f));
    }

    public NecroticExplosionLevelEvent(float x, float y, int range, Mob owner, float poisonDamage, float poisonTime) {
        this(x, y, range, new GameDamage(0.0f), owner, poisonDamage, poisonTime);
    }

    @Override
    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextFloat(this.poisonDamage);
    }

    @Override
    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.poisonDamage = reader.getNextFloat();
    }

    @Override
    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addFloat("poisonDamage", this.poisonDamage);
    }

    @Override
    public void applyLoadData(LoadData load) {
        super.applyLoadData(load);
        this.poisonDamage = load.getFloat("poisonDamage");
    }

    @Override
    protected void onMobWasHit(Mob mob, float distance) {
        super.onMobWasHit(mob, distance);
        if (this.poisonTime > 0 && this.poisonDamage > 0.0f) {
            MagicPoisonBuff.apply(this.ownerMob, mob, this.poisonDamage, this.poisonTime);
        }
    }
}

