/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.levelevents;

import java.awt.Color;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.gfx.GameResources;
import rpgclasses.levelevents.RPGExplosionLevelEvent;

public class IceExplosionLevelEvent
extends RPGExplosionLevelEvent {
    public IceExplosionLevelEvent() {
    }

    public IceExplosionLevelEvent(float x, float y, int range, GameDamage damage, Mob owner, boolean hitsOwner) {
        super(x, y, range, damage, owner, hitsOwner, new Color(50, 100, 255), new Color(20, 20, 155));
    }

    @Override
    protected void playExplosionEffects() {
        SoundManager.playSound((GameSound)GameResources.explosionHeavy, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.5f).pitch(0.5f));
        this.level.getClient().startCameraShake(this.x, this.y, 200, 40, 1.0f, 0.8f, true);
    }

    public float getParticleCount(float currentRange, float lastRange) {
        return super.getParticleCount(currentRange, lastRange) * 1.5f;
    }

    @Override
    protected void onMobWasHit(Mob mob, float distance) {
        float changedDistance;
        float f = changedDistance = mob == this.ownerMob ? distance * 2.0f : distance;
        if (changedDistance < (float)this.range) {
            super.onMobWasHit(mob, changedDistance);
            mob.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.FREEZING, mob, 5.0f, null), true);
            if (!mob.isBoss()) {
                mob.buffManager.addBuff(new ActiveBuff(BuffRegistry.FROZEN_MOB, mob, 1.0f, null), true);
            }
            if (this.ownerMob.isHostile) {
                float duration = distance <= 32.0f ? 10.0f : Math.max(10.0f / (distance / 32.0f), 2.0f);
                mob.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.BROKEN_ARMOR, mob, duration, null), true);
            }
        }
    }
}

