/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.levelevents;

import java.awt.Color;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import rpgclasses.buffs.IgnitedBuff;
import rpgclasses.levelevents.RPGExplosionLevelEvent;

public class FireExplosionLevelEvent
extends RPGExplosionLevelEvent {
    public boolean applyIgnite;

    public FireExplosionLevelEvent() {
        this.applyIgnite = false;
    }

    public FireExplosionLevelEvent(float x, float y, int range, GameDamage damage, Mob owner, boolean hitsOwner, boolean applyIgnite) {
        super(x, y, range, damage, owner, hitsOwner, new Color(255, 225, 155), new Color(200, 25, 29));
        this.applyIgnite = applyIgnite;
    }

    @Override
    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextBoolean(this.applyIgnite);
    }

    @Override
    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.applyIgnite = reader.getNextBoolean();
    }

    @Override
    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addBoolean("applyIgnite", this.applyIgnite);
    }

    @Override
    public void applyLoadData(LoadData load) {
        super.applyLoadData(load);
        this.applyIgnite = load.getBoolean("applyIgnite");
    }

    @Override
    protected void onMobWasHit(Mob mob, float distance) {
        float changedDistance;
        float f = changedDistance = mob == this.ownerMob ? distance * 2.0f : distance;
        if (changedDistance < (float)this.range) {
            super.onMobWasHit(mob, changedDistance);
            if (this.applyIgnite) {
                IgnitedBuff.apply(this.getAttackOwner(), mob, this.damage.damage * 0.2f, 5.0f, false);
            }
            if (this.ownerMob.isHostile) {
                float duration = distance <= 32.0f ? 10.0f : Math.max(10.0f / (distance / 32.0f), 2.0f);
                mob.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.BROKEN_ARMOR, mob, duration, null), true);
            }
        }
    }
}

