/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.items;

import necesse.engine.localization.Localization;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.container.item.ItemInventoryContainer;
import necesse.inventory.item.Item;
import necesse.inventory.item.miscItem.InternalInventoryItemInterface;
import necesse.inventory.item.miscItem.PouchItem;
import rpgclasses.items.AttributeRing;
import rpgclasses.registry.RPGContainers;

public class RingsBox
extends PouchItem {
    public RingsBox() {
        this.rarity = Item.Rarity.LEGENDARY;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"ringsboxtip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"rclickinvopentip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"stored", (String)"items", (Object)this.getStoredItemAmounts(item)));
        tooltips.add(Localization.translate((String)"global", (String)"rpgmod"));
        return tooltips;
    }

    public boolean isValidPouchItem(InventoryItem inventoryItem) {
        return inventoryItem.item != null && this.isValidRequestItem(inventoryItem.item);
    }

    public boolean isValidRequestItem(Item item) {
        return item instanceof AttributeRing;
    }

    public boolean isValidRequestType(Item.Type type) {
        return false;
    }

    public int getInternalInventorySize() {
        return 100;
    }

    protected void openContainer(ServerClient client, PlayerInventorySlot inventorySlot) {
        PacketOpenContainer p = new PacketOpenContainer(RPGContainers.CUSTOM_ITEM_INVENTORY_CONTAINER, ItemInventoryContainer.getContainerContent((InternalInventoryItemInterface)this, (PlayerInventorySlot)inventorySlot));
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
    }

    public int getStackSize() {
        return 1;
    }
}

