/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.entries;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.data.PlayerDataList;
import rpgclasses.forms.rpgmenu.MenuContainer;
import rpgclasses.forms.rpgmenu.MenuContainerForm;
import rpgclasses.forms.rpgmenu.components.ClassComponent;
import rpgclasses.forms.rpgmenu.components.MasteryComponent;
import rpgclasses.forms.rpgmenu.entries.MenuEntry;

public class MasteryEntry
extends MenuEntry {
    public FormLabel pointsLabel;
    public FormLabel resetPointsLabel;
    public FormButton cancelButton;
    public FormButton confirmButton;

    public MasteryEntry() {
        super("mastery");
    }

    @Override
    public Color getTextColor(PlayerMob player) {
        this.playerData = PlayerDataList.getPlayerData(player);
        if (this.playerData.totalMasteryPoints() < this.playerData.masterySkills.size()) {
            int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
            if (style == 1) {
                return new Color(255, 0, 0);
            }
            return new Color(102, 0, 0);
        }
        return null;
    }

    @Override
    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container) {
        this.playerData = PlayerDataList.getPlayerData(this.player);
        this.updateContent(mainForm, entryForm, container, this.playerData.getResets(), this.playerData.masterySkills, new ArrayList<Integer>(this.playerData.masterySkills));
    }

    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container, int resetPoints, List<Integer> masterySkills, List<Integer> mutableMasterySkills) {
        super.updateContent(mainForm, entryForm, container);
        int numItems = Mastery.masterySkillsList.size();
        this.pointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(14), -1, 10, 20));
        this.updatePoints(mutableMasterySkills, 0);
        this.resetPointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(14), -1, 10, 38));
        this.updateResetPoints(masterySkills, mutableMasterySkills, resetPoints);
        this.cancelButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "cancelbutton", 0, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> this.updateContent(mainForm, entryForm, container, resetPoints, this.playerData.masterySkills, new ArrayList<Integer>(this.playerData.masterySkills))));
        this.cancelButton.setActive(false);
        this.confirmButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "confirmbutton", entryForm.getWidth() / 2 + 2, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> {
            if (!this.player.isInCombat()) {
                int reducedMastery = 0;
                for (Integer mastery : masterySkills) {
                    if (mutableMasterySkills.contains(mastery)) continue;
                    reducedMastery += 5;
                }
                this.updateContent(mainForm, entryForm, container, resetPoints - reducedMastery, mutableMasterySkills, new ArrayList<Integer>(mutableMasterySkills));
            }
            container.updateMasterySkills.runAndSend(mutableMasterySkills.stream().mapToInt(Integer::intValue).toArray());
        }));
        this.confirmButton.setActive(false);
        FormContentBox masterySkillsForm = (FormContentBox)entryForm.addComponent((FormComponent)new FormContentBox(8, 60, entryForm.getWidth() - 16, entryForm.getHeight() - 60 - 40));
        int maxPerRow = 6;
        int numRows = (numItems + maxPerRow - 1) / maxPerRow;
        boolean hasScrollbar = numRows >= 4;
        int contentWidth = masterySkillsForm.getWidth() - (hasScrollbar ? Settings.UI.scrollbar.active.getHeight() + 2 : 0);
        float verticalSpacing = hasScrollbar ? (float)(ClassComponent.height + 16) : 1.0f / (float)numRows;
        for (int i = 0; i < numItems; ++i) {
            int row = i / maxPerRow;
            int col = i % maxPerRow;
            int numCols = Math.min(maxPerRow, numItems - row * maxPerRow);
            float horizontalSpacing = 1.0f / (float)numCols;
            int x = Math.round((float)contentWidth * ((float)col + 0.5f) * horizontalSpacing);
            int y = hasScrollbar ? Math.round(verticalSpacing * (float)row + (float)ClassComponent.height / 2.0f) : Math.round((float)masterySkillsForm.getHeight() * ((float)row + 0.5f) * verticalSpacing);
            int finalI = i;
            masterySkillsForm.addComponent((FormComponent)new MasteryComponent(x, y, Mastery.masterySkillsList.get(i), mutableMasterySkills.contains(i), () -> {
                mutableMasterySkills.add(finalI);
                this.updateForm(resetPoints, masterySkills, mutableMasterySkills);
            }, () -> {
                mutableMasterySkills.remove((Object)finalI);
                this.updateForm(resetPoints, masterySkills, mutableMasterySkills);
            }));
        }
        if (hasScrollbar) {
            masterySkillsForm.setContentBox(new Rectangle(0, 0, masterySkillsForm.getWidth(), Math.round(verticalSpacing * (float)numRows)));
        }
    }

    public void updateForm(int resetPoints, List<Integer> masterySkills, List<Integer> mutableMasterySkills) {
        this.updatePoints(mutableMasterySkills, mutableMasterySkills.size() - masterySkills.size());
        this.updateResetPoints(masterySkills, mutableMasterySkills, resetPoints);
        this.cancelButton.setActive(this.cancelEnabled(masterySkills, mutableMasterySkills));
        this.confirmButton.setActive(this.confirmEnabled(resetPoints, masterySkills, mutableMasterySkills));
    }

    public void updatePoints(List<Integer> mutableMasterySkills, int pointsDifference) {
        int totalPoints = this.playerData.totalMasteryPoints();
        int unassignedPoints = totalPoints - mutableMasterySkills.size();
        String text = unassignedPoints + "/" + totalPoints;
        if (-pointsDifference != 0) {
            text = text + " (" + (-pointsDifference > 0 ? "+" + -pointsDifference : String.valueOf(-pointsDifference)) + ")";
        }
        this.pointsLabel.setText(Localization.translate((String)"ui", (String)"masterypoints", (String)"points", (String)text));
    }

    public void updateResetPoints(List<Integer> masterySkills, List<Integer> mutableMasterySkills, int resetPoints) {
        int reducedMastery = 0;
        for (Integer mastery : masterySkills) {
            if (mutableMasterySkills.contains(mastery)) continue;
            reducedMastery += 5;
        }
        String text = String.valueOf(resetPoints);
        if (reducedMastery > 0) {
            text = text + " (" + -reducedMastery + ")";
        }
        this.resetPointsLabel.setText(Localization.translate((String)"ui", (String)"resetpoints", (String)"points", (String)text));
    }

    public boolean cancelEnabled(List<Integer> masterySkills, List<Integer> mutableMasterySkills) {
        return !masterySkills.equals(mutableMasterySkills);
    }

    public boolean confirmEnabled(int resetPoints, List<Integer> masterySkills, List<Integer> mutableMasterySkills) {
        int reducedMastery = 0;
        for (Integer mastery : masterySkills) {
            if (mutableMasterySkills.contains(mastery)) continue;
            reducedMastery += 5;
        }
        return !masterySkills.equals(mutableMasterySkills) && mutableMasterySkills.size() <= this.playerData.totalMasteryPoints() && (reducedMastery >= 0 || reducedMastery <= resetPoints);
    }

    @Override
    public GameTexture getTexture() {
        return super.getTexture();
    }
}

