/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.entries;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.events.FormEventListener;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.data.PlayerDataList;
import rpgclasses.forms.rpgmenu.MenuContainer;
import rpgclasses.forms.rpgmenu.MenuContainerForm;
import rpgclasses.forms.rpgmenu.components.ClassComponent;
import rpgclasses.forms.rpgmenu.entries.MenuEntry;
import rpgclasses.settings.RPGSettings;

public class ClassesEntry
extends MenuEntry {
    public ClassesEntry() {
        super("classes");
    }

    @Override
    public Color getTextColor(PlayerMob player) {
        this.playerData = PlayerDataList.getPlayerData(player);
        if (this.playerData.totalClassPoints() < Arrays.stream(this.playerData.getClassLevels()).sum()) {
            int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
            if (style == 1) {
                return new Color(255, 0, 0);
            }
            return new Color(102, 0, 0);
        }
        return null;
    }

    @Override
    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container) {
        this.playerData = PlayerDataList.getPlayerData(this.player);
        this.updateContent(mainForm, entryForm, container, this.playerData.getResets(), this.playerData.getClassLevels(), (int[])this.playerData.getClassLevels().clone());
    }

    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container, int resetPoints, int[] classes, int[] mutableClasses) {
        super.updateContent(mainForm, entryForm, container);
        entryForm.addComponent((FormComponent)new FormContentIconButton(entryForm.getWidth() - 32 - 8, 8, FormInputSize.SIZE_32, ButtonColor.BASE, (ButtonTexture)(MenuContainerForm.showClassIcons ? Settings.UI.button_shown_big : Settings.UI.button_hidden_big), new GameMessage[]{new LocalMessage("settingsui", "showClassIcons")}).onClicked(c -> {
            MenuContainerForm.showClassIcons = !MenuContainerForm.showClassIcons;
            mainForm.updateEntries(container, this.player, null);
            ((FormContentIconButton)c.from).setIcon(MenuContainerForm.showClassIcons ? Settings.UI.button_shown_big : Settings.UI.button_hidden_big);
        }));
        int numItems = PlayerClass.classesList.size();
        int maxClasses = this.playerData.totalClassPoints();
        int classesTotal = Arrays.stream(classes).sum();
        AtomicInteger mutableClassesTotal = new AtomicInteger(Arrays.stream(mutableClasses).sum());
        FormLabel classPointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(14), -1, 10, 20));
        this.updateClassPoints(classPointsLabel, mutableClassesTotal.get(), 0);
        FormLabel resetPointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(14), -1, 10, 38));
        this.updateResetPoints(resetPointsLabel, classes, mutableClasses, resetPoints);
        FormButton cancelButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "cancelbutton", 0, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> this.updateContent(mainForm, entryForm, container, resetPoints, classes, (int[])classes.clone())));
        cancelButton.setActive(false);
        FormButton confirmButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "confirmbutton", entryForm.getWidth() / 2 + 2, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> {
            if (!this.player.isInCombat()) {
                int reducedClasses = 0;
                for (int i = 0; i < classes.length; ++i) {
                    int difference = classes[i] - mutableClasses[i];
                    if (difference <= 0) continue;
                    reducedClasses += difference;
                }
                this.updateContent(mainForm, entryForm, container, resetPoints - reducedClasses * 2, mutableClasses, (int[])mutableClasses.clone());
                mainForm.updateEntries(container, this.player, mutableClasses);
            }
            container.updateClasses.runAndSend(mutableClasses);
        }));
        confirmButton.setActive(false);
        FormContentBox classesForm = (FormContentBox)entryForm.addComponent((FormComponent)new FormContentBox(8, 60, entryForm.getWidth() - 16, entryForm.getHeight() - 60 - 40));
        int maxPerRow = 5;
        int numRows = (numItems + maxPerRow - 1) / maxPerRow;
        boolean hasScrollbar = numRows >= 3;
        int contentWidth = classesForm.getWidth() - (hasScrollbar ? Settings.UI.scrollbar.active.getHeight() + 2 : 0);
        float verticalSpacing = hasScrollbar ? (float)(ClassComponent.height + 16) : 1.0f / (float)numRows;
        for (int i = 0; i < numItems; ++i) {
            int row = i / maxPerRow;
            int col = i % maxPerRow;
            int numCols = Math.min(maxPerRow, numItems - row * maxPerRow);
            float horizontalSpacing = 1.0f / (float)numCols;
            int x = Math.round((float)contentWidth * ((float)col + 0.5f) * horizontalSpacing);
            int y = hasScrollbar ? Math.round(verticalSpacing * (float)row + (float)ClassComponent.height / 2.0f) : Math.round((float)classesForm.getHeight() * ((float)row + 0.5f) * verticalSpacing);
            int finalI = i;
            PlayerClass playerClass = PlayerClass.classesList.get(i);
            ClassComponent classComponent = (ClassComponent)classesForm.addComponent((FormComponent)new ClassComponent(x, y, playerClass, classes[i]));
            classComponent.addOnMod(newLevel -> {
                int oldLevel = mutableClasses[finalI];
                int mod = newLevel - oldLevel;
                if ((playerClass.isEnabled() || mod < 0) && newLevel >= 0 && newLevel <= 999 && mod != 0) {
                    mutableClasses[finalI] = newLevel;
                    int multiClass = RPGSettings.multiClass();
                    if (mod < 0 || multiClass == 0 || Arrays.stream(mutableClasses).filter(level -> level > 0).count() <= (long)multiClass) {
                        int currentClassesTotal = mutableClassesTotal.addAndGet(mod);
                        this.updateFormClasses(classPointsLabel, resetPointsLabel, cancelButton, confirmButton, classesTotal, currentClassesTotal, maxClasses, resetPoints, classes, mutableClasses);
                        return true;
                    }
                    mutableClasses[finalI] = oldLevel;
                }
                return false;
            });
            if (!playerClass.isEnabled()) continue;
            classComponent.onClick((FormEventListener<FormInputEvent<FormButton>>)((FormEventListener)c -> mainForm.changeEntry("classes." + playerClass.stringID, this.player)));
        }
        if (hasScrollbar) {
            classesForm.setContentBox(new Rectangle(0, 0, classesForm.getWidth(), Math.round(verticalSpacing * (float)numRows)));
        }
    }

    public void updateFormClasses(FormLabel classPointsLabel, FormLabel resetPointsLabel, FormButton cancelButton, FormButton confirmButton, int classesTotal, int currentClassesTotal, int maxClasses, int resetPoints, int[] classes, int[] mutableClasses) {
        this.updateClassPoints(classPointsLabel, currentClassesTotal, currentClassesTotal - classesTotal);
        this.updateResetPoints(resetPointsLabel, classes, mutableClasses, resetPoints);
        cancelButton.setActive(this.cancelEnabled(classes, mutableClasses));
        confirmButton.setActive(this.confirmEnabled(maxClasses, currentClassesTotal, resetPoints, classes, mutableClasses));
    }

    public void updateClassPoints(FormLabel classPointsLabel, int currentClassesTotal, int pointsDifference) {
        int totalPoints = this.playerData.totalClassPoints();
        int unassignedPoints = totalPoints - currentClassesTotal;
        String text = unassignedPoints + "/" + totalPoints;
        if (-pointsDifference != 0) {
            text = text + " (" + (-pointsDifference > 0 ? "+" + -pointsDifference : String.valueOf(-pointsDifference)) + ")";
        }
        classPointsLabel.setText(Localization.translate((String)"ui", (String)"classpoints", (String)"points", (String)text));
    }

    public void updateResetPoints(FormLabel resetPointsLabel, int[] classes, int[] mutableClasses, int resetPoints) {
        int reducedClasses = 0;
        for (int i = 0; i < classes.length; ++i) {
            int difference = classes[i] - mutableClasses[i];
            if (difference <= 0) continue;
            reducedClasses += difference;
        }
        String text = String.valueOf(resetPoints);
        if (reducedClasses > 0) {
            text = text + " (" + -reducedClasses * 2 + ")";
        }
        resetPointsLabel.setText(Localization.translate((String)"ui", (String)"resetpoints", (String)"points", (String)text));
    }

    public boolean cancelEnabled(int[] classes, int[] mutableClasses) {
        return !Arrays.equals(classes, mutableClasses);
    }

    public boolean confirmEnabled(int maxClasses, int mutableClassesTotal, int resetPoints, int[] classes, int[] mutableClasses) {
        int reducedClasses = 0;
        for (int i = 0; i < classes.length; ++i) {
            int difference = classes[i] - mutableClasses[i];
            if (difference <= 0) continue;
            reducedClasses += difference;
        }
        return !Arrays.equals(classes, mutableClasses) && mutableClassesTotal <= maxClasses && reducedClasses * 2 <= resetPoints;
    }
}

