/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.entries;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.events.FormEventListener;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.forms.rpgmenu.MenuContainer;
import rpgclasses.forms.rpgmenu.MenuContainerForm;
import rpgclasses.forms.rpgmenu.components.SkillComponent;
import rpgclasses.forms.rpgmenu.entries.MenuEntry;

public class ClassEntry
extends MenuEntry {
    final PlayerClass playerClass;

    public ClassEntry(String name, PlayerClass playerClass) {
        super(name);
        this.playerClass = playerClass;
    }

    @Override
    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container) {
        this.playerData = PlayerDataList.getPlayerData(this.player);
        PlayerClassData playerClassData = this.playerData.getClassesData()[this.playerClass.id];
        this.updateContent(mainForm, entryForm, container, playerClassData, playerClassData.getPassiveLevels(), (int[])playerClassData.getPassiveLevels().clone(), playerClassData.getActiveSkillLevels(), (int[])playerClassData.getActiveSkillLevels().clone());
    }

    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container, PlayerClassData playerClassData, int[] passiveLevels, int[] mutablePassiveLevels, int[] activeSkillLevels, int[] mutableActiveSkillLevels) {
        super.updateContent(mainForm, entryForm, container);
        int totalPassivePoints = playerClassData.totalPassivePoints(false);
        int usedPassivePoints = Arrays.stream(passiveLevels).sum();
        AtomicInteger mutableUsedPassivePoints = new AtomicInteger(Arrays.stream(mutablePassiveLevels).sum());
        entryForm.addComponent((FormComponent)new FormLocalLabel((GameMessage)new LocalMessage("ui", "classlevel", new Object[]{"class", Localization.translate((String)"classes", (String)playerClassData.playerClass.stringID), "level", playerClassData.getLevel(false)}), new FontOptions(16), -1, 10, 4));
        FormLabel passivePointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(12), -1, 12, 43));
        this.updatePassivePoints(passivePointsLabel, totalPassivePoints, mutableUsedPassivePoints.get(), 0);
        int totalActiveSkillPoints = playerClassData.totalActiveSkillPoints(false);
        int usedActiveSkillsPoints = Arrays.stream(activeSkillLevels).sum();
        AtomicInteger mutableUsedActiveSkillsPoints = new AtomicInteger(Arrays.stream(mutableActiveSkillLevels).sum());
        FormLabel activeSkillPointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(12), -1, 12, 25));
        this.updateActiveSkillPoints(activeSkillPointsLabel, totalActiveSkillPoints, mutableUsedActiveSkillsPoints.get(), 0);
        FormButton cancelButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "cancelbutton", 0, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> this.updateContent(mainForm, entryForm, container, playerClassData, passiveLevels, (int[])passiveLevels.clone(), activeSkillLevels, (int[])activeSkillLevels.clone())));
        cancelButton.setActive(false);
        FormButton confirmButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "confirmbutton", entryForm.getWidth() / 2 + 2, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> {
            if (!this.player.isInCombat()) {
                this.updateContent(mainForm, entryForm, container, playerClassData, mutablePassiveLevels, (int[])mutablePassiveLevels.clone(), mutableActiveSkillLevels, (int[])mutableActiveSkillLevels.clone());
            }
            container.updateClass.runAndSend(this.playerClass.id, mutablePassiveLevels, mutableActiveSkillLevels);
        }));
        confirmButton.setActive(false);
        int maxPassiveColumns = 4;
        int numPassiveItems = this.playerClass.passivesList.size();
        int passivesContainerWidth = 24 + maxPassiveColumns * (SkillComponent.width + 12);
        int startPassivesContainerX = entryForm.getWidth() - passivesContainerWidth;
        entryForm.addComponent((FormComponent)new FormLocalLabel("passives", "passives", new FontOptions(18), -1, startPassivesContainerX + 16, 6));
        int passiveRows = 0;
        int actualColumn = 0;
        int lastPassiveLevel = 0;
        int passiveSeparations = 0;
        FormContentBox passives = (FormContentBox)entryForm.addComponent((FormComponent)new FormContentBox(startPassivesContainerX, 30, passivesContainerWidth, entryForm.getHeight() - 32 - 30 - 4));
        List<Passive> passiveOrderedList = this.playerClass.passivesList.getDisplayOrderedList();
        for (int i = 0; i < numPassiveItems; ++i) {
            Passive passive = passiveOrderedList.get(i);
            boolean newSeparation = false;
            if (i == 0) {
                lastPassiveLevel = passive.requiredClassLevel;
                newSeparation = true;
            } else if (passive.requiredClassLevel != lastPassiveLevel) {
                ++passiveRows;
                actualColumn = 0;
                lastPassiveLevel = passive.requiredClassLevel;
                newSeparation = true;
            } else if (actualColumn < maxPassiveColumns - 1) {
                ++actualColumn;
            } else {
                ++passiveRows;
                actualColumn = 0;
            }
            int yPosition = 12 + passiveRows * (SkillComponent.height + 12);
            if (newSeparation) {
                passives.addComponent((FormComponent)new FormLocalLabel((GameMessage)new LocalMessage("ui", "classlevelseparation", new Object[]{"level", lastPassiveLevel}), new FontOptions(12), -1, 8, yPosition + passiveSeparations * 24 + 8));
                ++passiveSeparations;
            }
            int passiveID = passive.id;
            SkillComponent passiveSkillComponent = (SkillComponent)passives.addComponent((FormComponent)new SkillComponent(6 + actualColumn * (SkillComponent.width + 2), yPosition + passiveSeparations * 24, passive, this.player, playerClassData, passiveLevels[passiveID], mutablePassiveLevels));
            passiveSkillComponent.setOnAdd((FormEventListener<FormInputEvent<FormButton>>)((FormEventListener)c -> {
                int currentUsedPassives = mutableUsedPassivePoints.incrementAndGet();
                int n = passiveID;
                mutablePassiveLevels[n] = mutablePassiveLevels[n] + 1;
                passiveSkillComponent.addSkillLevel(1);
                this.updateForm(passivePointsLabel, activeSkillPointsLabel, cancelButton, confirmButton, usedPassivePoints, currentUsedPassives, totalPassivePoints, passiveLevels, mutablePassiveLevels, usedActiveSkillsPoints, mutableUsedActiveSkillsPoints.get(), totalActiveSkillPoints, activeSkillLevels, mutableActiveSkillLevels);
            }));
            passiveSkillComponent.setOnRemove((FormEventListener<FormInputEvent<FormButton>>)((FormEventListener)c -> {
                int currentUsedPassives = mutableUsedPassivePoints.decrementAndGet();
                int n = passiveID;
                mutablePassiveLevels[n] = mutablePassiveLevels[n] - 1;
                passiveSkillComponent.addSkillLevel(-1);
                this.updateForm(passivePointsLabel, activeSkillPointsLabel, cancelButton, confirmButton, usedPassivePoints, currentUsedPassives, totalPassivePoints, passiveLevels, mutablePassiveLevels, usedActiveSkillsPoints, mutableUsedActiveSkillsPoints.get(), totalActiveSkillPoints, activeSkillLevels, mutableActiveSkillLevels);
            }));
        }
        passives.setContentBox(new Rectangle(0, 0, passives.getWidth(), 12 + (passiveRows + 1) * (SkillComponent.height + 12) + passiveSeparations * 24));
        int numActiveItems = this.playerClass.activeSkillsList.size();
        int activeRows = 1;
        int activeColumns = 1;
        actualColumn = 0;
        int lastActiveLevel = 0;
        int activeSkillsStartY = 66;
        int activeSeparations = 0;
        FormContentBox activeSkills = (FormContentBox)entryForm.addComponent((FormComponent)new FormContentBox(0, activeSkillsStartY, entryForm.getWidth() - 16 - 4 - passivesContainerWidth, entryForm.getHeight() - 32 - 4 - activeSkillsStartY));
        List<ActiveSkill> activeOrderedList = this.playerClass.activeSkillsList.getDisplayOrderedList();
        for (int i = 0; i < numActiveItems; ++i) {
            ActiveSkill activeSkill = activeOrderedList.get(i);
            int requiredLevel = activeSkill.requiredClassLevel;
            if (i != 0 && (activeSkill.newRow || lastActiveLevel != requiredLevel)) {
                ++activeRows;
                actualColumn = 1;
            } else if (activeColumns < ++actualColumn) {
                activeColumns = actualColumn;
            }
            int yPosition = 6 + (activeRows - 1) * (SkillComponent.height + 12);
            if (i == 0 || requiredLevel != lastActiveLevel) {
                lastActiveLevel = requiredLevel;
                activeSkills.addComponent((FormComponent)new FormLocalLabel((GameMessage)new LocalMessage("ui", "classlevelseparation", new Object[]{"level", lastActiveLevel}), new FontOptions(12), -1, 8, yPosition + activeSeparations * 24 + 8));
                ++activeSeparations;
            }
            int activeSkillID = activeSkill.id;
            SkillComponent activeSkillComponent = (SkillComponent)activeSkills.addComponent((FormComponent)new SkillComponent(6 + (actualColumn - 1) * (SkillComponent.width + 2), yPosition + activeSeparations * 24, activeSkill, this.player, playerClassData, activeSkillLevels[activeSkillID], mutableActiveSkillLevels));
            activeSkillComponent.setOnAdd((FormEventListener<FormInputEvent<FormButton>>)((FormEventListener)c -> {
                int currentUsedActiveSkills = mutableUsedActiveSkillsPoints.incrementAndGet();
                int n = activeSkillID;
                mutableActiveSkillLevels[n] = mutableActiveSkillLevels[n] + 1;
                activeSkillComponent.addSkillLevel(1);
                this.updateForm(passivePointsLabel, activeSkillPointsLabel, cancelButton, confirmButton, usedPassivePoints, mutableUsedPassivePoints.get(), totalPassivePoints, passiveLevels, mutablePassiveLevels, usedActiveSkillsPoints, currentUsedActiveSkills, totalActiveSkillPoints, activeSkillLevels, mutableActiveSkillLevels);
            }));
            activeSkillComponent.setOnRemove((FormEventListener<FormInputEvent<FormButton>>)((FormEventListener)c -> {
                int currentUsedActiveSkills = mutableUsedActiveSkillsPoints.decrementAndGet();
                int n = activeSkillID;
                mutableActiveSkillLevels[n] = mutableActiveSkillLevels[n] - 1;
                activeSkillComponent.addSkillLevel(-1);
                this.updateForm(passivePointsLabel, activeSkillPointsLabel, cancelButton, confirmButton, usedPassivePoints, mutableUsedPassivePoints.get(), totalPassivePoints, passiveLevels, mutablePassiveLevels, usedActiveSkillsPoints, currentUsedActiveSkills, totalActiveSkillPoints, activeSkillLevels, mutableActiveSkillLevels);
            }));
        }
        activeSkills.setContentBox(new Rectangle(0, 0, 12 + activeColumns * (SkillComponent.width + 12), 12 + activeRows * (SkillComponent.height + 12) + activeSeparations * 24));
    }

    public void updateForm(FormLabel passivePointsLabel, FormLabel activeSkillPointsLabel, FormButton cancelButton, FormButton confirmButton, int passiveLevelsTotal, int currentUsedPassives, int totalPassivePoints, int[] passiveLevels, int[] mutablePassiveLevels, int activeSkillLevelsTotal, int currentUsedActiveSkill, int totalActiveSkillPoints, int[] activeSkillLevels, int[] mutableActiveSkillLevels) {
        int passivePointsDifference = currentUsedPassives - passiveLevelsTotal;
        int activeSkillPointsDifference = currentUsedActiveSkill - activeSkillLevelsTotal;
        this.updatePassivePoints(passivePointsLabel, totalPassivePoints, currentUsedPassives, passivePointsDifference);
        this.updateActiveSkillPoints(activeSkillPointsLabel, totalActiveSkillPoints, currentUsedActiveSkill, activeSkillPointsDifference);
        cancelButton.setActive(this.cancelEnabled(passiveLevels, mutablePassiveLevels, activeSkillLevels, mutableActiveSkillLevels));
        confirmButton.setActive(this.confirmEnabled(totalPassivePoints, totalActiveSkillPoints, currentUsedPassives, currentUsedActiveSkill, activeSkillLevels, mutableActiveSkillLevels, passiveLevels, mutablePassiveLevels));
    }

    public void updatePassivePoints(FormLabel passivePointsLabel, int totalPassivePoints, int currentUsedPassives, int pointsDifference) {
        int unassignedPoints = totalPassivePoints - currentUsedPassives;
        String text = unassignedPoints + "/" + totalPassivePoints;
        if (-pointsDifference != 0) {
            text = text + " (" + (-pointsDifference > 0 ? "+" + -pointsDifference : String.valueOf(-pointsDifference)) + ")";
        }
        passivePointsLabel.setText(Localization.translate((String)"ui", (String)"passivepoints", (String)"points", (String)text));
    }

    public void updateActiveSkillPoints(FormLabel activeSkillPointsLabel, int totalActiveSkillPoints, int currentUsedActiveSkills, int pointsDifference) {
        int unassignedPoints = totalActiveSkillPoints - currentUsedActiveSkills;
        String text = unassignedPoints + "/" + totalActiveSkillPoints;
        if (-pointsDifference != 0) {
            text = text + " (" + (-pointsDifference > 0 ? "+" + -pointsDifference : String.valueOf(-pointsDifference)) + ")";
        }
        activeSkillPointsLabel.setText(Localization.translate((String)"ui", (String)"activeskillpoints", (String)"points", (String)text));
    }

    public boolean confirmEnabled(int totalPassivePoints, int totalActiveSkillPoints, int mutablePassiveLevelsTotal, int mutableActiveSkillLevelsTotal, int[] activeSkillLevels, int[] mutableActiveSkillLevels, int[] passiveLevels, int[] mutablePassiveLevels) {
        int effectiveMax;
        int assignedLevel;
        int i;
        if (Arrays.equals(activeSkillLevels, mutableActiveSkillLevels) && Arrays.equals(passiveLevels, mutablePassiveLevels)) {
            return false;
        }
        if (totalPassivePoints < mutablePassiveLevelsTotal) {
            return false;
        }
        if (totalActiveSkillPoints < mutableActiveSkillLevelsTotal) {
            return false;
        }
        PlayerClassData classData = this.playerData.getClassesData()[this.playerClass.id];
        boolean confirm = true;
        HashSet<String> passiveFamilies = new HashSet<String>();
        for (i = 0; i < passiveLevels.length; ++i) {
            Passive passive = classData.playerClass.passivesList.get(i);
            assignedLevel = passiveLevels[i];
            if (assignedLevel > 0 && passive.family != null) {
                if (passiveFamilies.contains(passive.family)) {
                    confirm = false;
                    break;
                }
                passiveFamilies.add(passive.family);
            }
            effectiveMax = classData.getEffectiveSkillMaxLevel(passive, classData.getLevel(false), passiveLevels);
            if (assignedLevel >= 0 && assignedLevel <= effectiveMax) continue;
            confirm = false;
            break;
        }
        if (!confirm) {
            return false;
        }
        for (i = 0; i < mutableActiveSkillLevels.length; ++i) {
            boolean hasRequired;
            ActiveSkill skill = classData.playerClass.activeSkillsList.get(i);
            assignedLevel = mutableActiveSkillLevels[i];
            effectiveMax = classData.getEffectiveSkillMaxLevel(classData.playerClass.activeSkillsList.get(i), classData.getLevel(false), mutableActiveSkillLevels);
            if (assignedLevel < 0 || assignedLevel > effectiveMax) {
                confirm = false;
                break;
            }
            if (assignedLevel <= 0 || (hasRequired = ClassEntry.hasRequired(skill, mutableActiveSkillLevels))) continue;
            confirm = false;
            break;
        }
        return confirm;
    }

    public boolean cancelEnabled(int[] passiveLevels, int[] mutablePassiveLevels, int[] activeSkillLevels, int[] mutableActiveSkillLevels) {
        return !Arrays.equals(passiveLevels, mutablePassiveLevels) || !Arrays.equals(activeSkillLevels, mutableActiveSkillLevels);
    }

    @Override
    public Color getTextColor(PlayerMob player) {
        this.playerData = PlayerDataList.getPlayerData(player);
        PlayerClassData classData = this.playerData.getClassesData()[this.playerClass.id];
        if (classData.totalActiveSkillPoints(false) < classData.usedActiveSkillPoints() || classData.totalPassivePoints(false) < classData.usedPassivePoints()) {
            int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
            if (style == 1) {
                return new Color(255, 0, 0);
            }
            return new Color(102, 0, 0);
        }
        return null;
    }

    @Override
    public GameTexture getTexture() {
        return this.playerClass.texture;
    }

    public static boolean hasRequired(ActiveSkill skill, int[] activeSkillLevels) {
        boolean hasRequired = true;
        if (skill != null) {
            for (ActiveSkill.RequiredSkill requiredSkill : skill.requiredSkills) {
                if (activeSkillLevels[requiredSkill.activeSkill.id] >= requiredSkill.activeSkillLevel) continue;
                hasRequired = false;
                break;
            }
        }
        return hasRequired;
    }
}

