/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.entries;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.events.FormEventListener;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.content.player.Attribute;
import rpgclasses.data.PlayerDataList;
import rpgclasses.forms.rpgmenu.MenuContainer;
import rpgclasses.forms.rpgmenu.MenuContainerForm;
import rpgclasses.forms.rpgmenu.components.AttributeComponent;
import rpgclasses.forms.rpgmenu.components.ClassComponent;
import rpgclasses.forms.rpgmenu.entries.MenuEntry;

public class AttributesEntry
extends MenuEntry {
    public AttributesEntry() {
        super("attributes");
    }

    @Override
    public Color getTextColor(PlayerMob player) {
        this.playerData = PlayerDataList.getPlayerData(player);
        if (this.playerData.totalAttributePoints() < Arrays.stream(this.playerData.getAttributePointsUsed()).sum()) {
            int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
            if (style == 1) {
                return new Color(255, 0, 0);
            }
            return new Color(102, 0, 0);
        }
        return null;
    }

    @Override
    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container) {
        this.playerData = PlayerDataList.getPlayerData(this.player);
        this.updateContent(mainForm, entryForm, container, this.playerData.getResets(), this.playerData.getAttributePointsUsed(), (int[])this.playerData.getAttributePointsUsed().clone());
    }

    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container, int resetPoints, int[] attributes, int[] mutableAttributes) {
        super.updateContent(mainForm, entryForm, container);
        int numItems = Attribute.attributesList.size();
        int maxAttributes = this.playerData.totalAttributePoints();
        int attributesTotal = Arrays.stream(attributes).sum();
        AtomicInteger mutableAttributesTotal = new AtomicInteger(Arrays.stream(mutableAttributes).sum());
        FormLabel attributePointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(14), -1, 10, 20));
        this.updateAttributePoints(attributePointsLabel, mutableAttributesTotal.get(), 0);
        FormLabel resetPointsLabel = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel("", new FontOptions(14), -1, 10, 38));
        this.updateResetPoints(resetPointsLabel, attributes, mutableAttributes, resetPoints);
        FormButton cancelButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "cancelbutton", 0, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> this.updateContent(mainForm, entryForm, container, resetPoints, attributes, (int[])attributes.clone())));
        cancelButton.setActive(false);
        FormButton confirmButton = (FormButton)entryForm.addComponent((FormComponent)new FormLocalTextButton("ui", "confirmbutton", entryForm.getWidth() / 2 + 2, entryForm.getHeight() - 32, entryForm.getWidth() / 2 - 2, FormInputSize.SIZE_32, ButtonColor.BASE).onClicked(c -> {
            if (!this.player.isInCombat()) {
                int reducedAttributes = 0;
                for (int i = 0; i < attributes.length; ++i) {
                    int difference = attributes[i] - mutableAttributes[i];
                    if (difference <= 0) continue;
                    reducedAttributes += difference;
                }
                this.updateContent(mainForm, entryForm, container, resetPoints - reducedAttributes, mutableAttributes, (int[])mutableAttributes.clone());
            }
            container.updateAttributes.runAndSend(mutableAttributes);
        }));
        confirmButton.setActive(false);
        FormContentBox attributesForm = (FormContentBox)entryForm.addComponent((FormComponent)new FormContentBox(8, 60, entryForm.getWidth() - 16, entryForm.getHeight() - 60 - 40));
        int maxPerRow = 5;
        int numRows = (numItems + maxPerRow - 1) / maxPerRow;
        boolean hasScrollbar = numRows >= 3;
        int contentWidth = attributesForm.getWidth() - (hasScrollbar ? Settings.UI.scrollbar.active.getHeight() + 2 : 0);
        float verticalSpacing = hasScrollbar ? (float)(ClassComponent.height + 16) : 1.0f / (float)numRows;
        for (int i = 0; i < numItems; ++i) {
            int row = i / maxPerRow;
            int col = i % maxPerRow;
            int numCols = Math.min(maxPerRow, numItems - row * maxPerRow);
            float horizontalSpacing = 1.0f / (float)numCols;
            int x = Math.round((float)contentWidth * ((float)col + 0.5f) * horizontalSpacing);
            int y = hasScrollbar ? Math.round(verticalSpacing * (float)row + (float)ClassComponent.height / 2.0f) : Math.round((float)attributesForm.getHeight() * ((float)row + 0.5f) * verticalSpacing);
            int finalI = i;
            AttributeComponent attributeComponent = (AttributeComponent)attributesForm.addComponent((FormComponent)new AttributeComponent(this.client, x, y, Attribute.attributesList.get(i), attributes[i]));
            attributeComponent.addOnMod((FormEventListener<FormInputEvent<FormButton>>)((FormEventListener)c -> {
                int oldLevel;
                int newLevel = attributeComponent.attributePoints.get();
                int mod = newLevel - (oldLevel = mutableAttributes[finalI]);
                if (mod != 0) {
                    mutableAttributes[finalI] = newLevel;
                    int currentAttributesTotal = mutableAttributesTotal.addAndGet(mod);
                    this.updateFormAttributes(attributePointsLabel, resetPointsLabel, cancelButton, confirmButton, attributesTotal, currentAttributesTotal, maxAttributes, resetPoints, attributes, mutableAttributes);
                }
            }));
        }
        if (hasScrollbar) {
            attributesForm.setContentBox(new Rectangle(0, 0, attributesForm.getWidth(), Math.round(verticalSpacing * (float)numRows)));
        }
    }

    public void updateFormAttributes(FormLabel attributePointsLabel, FormLabel resetPointsLabel, FormButton cancelButton, FormButton confirmButton, int attributesTotal, int currentAttributesTotal, int maxAttributes, int resetPoints, int[] attributes, int[] mutableAttributes) {
        this.updateAttributePoints(attributePointsLabel, currentAttributesTotal, currentAttributesTotal - attributesTotal);
        this.updateResetPoints(resetPointsLabel, attributes, mutableAttributes, resetPoints);
        cancelButton.setActive(this.cancelEnabled(attributes, mutableAttributes));
        confirmButton.setActive(this.confirmEnabled(maxAttributes, currentAttributesTotal, resetPoints, attributes, mutableAttributes));
    }

    public void updateAttributePoints(FormLabel attributePointsLabel, int currentAttributesTotal, int pointsDifference) {
        int totalPoints = this.playerData.totalAttributePoints();
        int unassignedPoints = totalPoints - currentAttributesTotal;
        String text = unassignedPoints + "/" + totalPoints;
        if (-pointsDifference != 0) {
            text = text + " (" + (-pointsDifference > 0 ? "+" + -pointsDifference : String.valueOf(-pointsDifference)) + ")";
        }
        attributePointsLabel.setText(Localization.translate((String)"ui", (String)"attrpoints", (String)"points", (String)text));
    }

    public void updateResetPoints(FormLabel resetPointsLabel, int[] attributes, int[] mutableAttributes, int resetPoints) {
        int reducedAttributes = 0;
        for (int i = 0; i < attributes.length; ++i) {
            int difference = attributes[i] - mutableAttributes[i];
            if (difference <= 0) continue;
            reducedAttributes += difference;
        }
        String text = String.valueOf(resetPoints);
        if (reducedAttributes > 0) {
            text = text + " (" + -reducedAttributes + ")";
        }
        resetPointsLabel.setText(Localization.translate((String)"ui", (String)"resetpoints", (String)"points", (String)text));
    }

    public boolean cancelEnabled(int[] attributes, int[] mutableAttributes) {
        return !Arrays.equals(attributes, mutableAttributes);
    }

    public boolean confirmEnabled(int maxAttributes, int mutableAttributesTotal, int resetPoints, int[] attributes, int[] mutableAttributes) {
        int reducedAttributes = 0;
        for (int i = 0; i < attributes.length; ++i) {
            int difference = attributes[i] - mutableAttributes[i];
            if (difference <= 0) continue;
            reducedAttributes += difference;
        }
        return !Arrays.equals(attributes, mutableAttributes) && mutableAttributesTotal <= maxAttributes && reducedAttributes <= resetPoints;
    }
}

