/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.entries;

import java.awt.Rectangle;
import java.util.ArrayList;
import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.RPGResources;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerClassData;
import rpgclasses.forms.rpgmenu.MenuContainer;
import rpgclasses.forms.rpgmenu.MenuContainerForm;
import rpgclasses.forms.rpgmenu.components.EquipActiveSkillComponent;
import rpgclasses.forms.rpgmenu.entries.MenuEntry;
import rpgclasses.settings.RPGSettings;
import rpgclasses.ui.CustomUIManager;
import rpgclasses.ui.RPGSkillUIManager;

public class ActiveSkillsEntry
extends MenuEntry {
    public static int showManySlots = RPGSettings.settingsGetter.getBoolean("twelveSkillSlots") ? 12 : 6;

    public ActiveSkillsEntry() {
        super("activeskills");
    }

    @Override
    public void updateContent(MenuContainerForm mainForm, FormContentBox entryForm, MenuContainer container) {
        super.updateContent(mainForm, entryForm, container);
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        entryForm.addComponent((FormComponent)new FormContentIconButton(entryForm.getWidth() - 32 - 8, 8, FormInputSize.SIZE_32, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.slot_icons[style][showManySlots - 1], new GameMessage[0]).onClicked(c -> {
            showManySlots = showManySlots > 6 ? 6 : 12;
            for (RPGSkillUIManager rpgSkill : CustomUIManager.rpgSkills) {
                rpgSkill.updatePosition(RPGSkillUIManager.mainGameFormManager);
            }
            mainForm.updateContent(container, this.player);
        }));
        FormLabel label = (FormLabel)entryForm.addComponent((FormComponent)new FormLabel(Localization.translate((String)"ui", (String)"activeskillsuse") + "\n" + Localization.translate((String)"ui", (String)"activeskillsusetip1") + "\n" + Localization.translate((String)"ui", (String)"activeskillsusetip2") + "\n" + Localization.translate((String)"ui", (String)"activeskillsequipinstructions"), new FontOptions(12), -1, 10, 20, entryForm.getWidth() - 20 - 32 - 8));
        ArrayList<EquipableActiveSkill> equipableActiveSkills = new ArrayList<EquipableActiveSkill>();
        for (PlayerClassData classesDatum : this.playerData.getClassesData()) {
            for (int i = 0; i < classesDatum.getActiveSkillLevels().length; ++i) {
                int activeSkillLevel = classesDatum.getActiveSkillLevels()[i];
                if (classesDatum.getLevel(false) <= 0 || activeSkillLevel <= 0) continue;
                equipableActiveSkills.add(new EquipableActiveSkill(classesDatum.playerClass, classesDatum.playerClass.activeSkillsList.get(i), activeSkillLevel));
            }
        }
        int startY = Math.max(40, label.getY() + label.getHeight()) + 4;
        if (equipableActiveSkills.isEmpty()) {
            entryForm.addComponent((FormComponent)new FormLocalLabel("ui", "noactiveskills", new FontOptions(16), -1, 10, startY));
        } else {
            FormContentBox activeSkills = (FormContentBox)entryForm.addComponent((FormComponent)new FormContentBox(16, startY, entryForm.getWidth() - 32, entryForm.getHeight() - startY - 8));
            int columns = showManySlots > 6 ? 1 : 2;
            int spacingY = 8;
            int itemHeight = EquipActiveSkillComponent.height;
            int leftX = 16;
            int rightX = activeSkills.getWidth() / 2;
            for (int i = 0; i < equipableActiveSkills.size(); ++i) {
                EquipableActiveSkill equipableActiveSkill = (EquipableActiveSkill)equipableActiveSkills.get(i);
                PlayerClass playerClass = equipableActiveSkill.playerClass;
                ActiveSkill activeSkill = equipableActiveSkill.activeSkill;
                int activeSkillLevel = equipableActiveSkill.activeSkillLevel;
                int column = i % columns;
                int row = i / columns;
                int x = column == 0 ? leftX : rightX;
                int y = spacingY + row * (itemHeight + spacingY);
                equipableActiveSkill.component = (EquipActiveSkillComponent)activeSkills.addComponent((FormComponent)new EquipActiveSkillComponent(x, y, activeSkill, playerClass, this.player, activeSkillLevel, showManySlots, showManySlots > 6 ? entryForm.getWidth() - 32 : EquipActiveSkillComponent.shortWidth, newEquippedActiveSkills -> {
                    for (EquipableActiveSkill skill : equipableActiveSkills) {
                        skill.component.update((EquippedActiveSkill[])newEquippedActiveSkills, this.playerData);
                    }
                    container.updateEquippedActiveSkills.runAndSend((EquippedActiveSkill[])newEquippedActiveSkills);
                }));
            }
            int totalRows = (int)Math.ceil((float)equipableActiveSkills.size() / (float)columns);
            activeSkills.setContentBox(new Rectangle(0, 0, activeSkills.getWidth(), spacingY + totalRows * (itemHeight + spacingY)));
        }
    }

    public static class EquipableActiveSkill {
        public final PlayerClass playerClass;
        public final ActiveSkill activeSkill;
        public final int activeSkillLevel;
        public EquipActiveSkillComponent component;

        public EquipableActiveSkill(PlayerClass playerClass, ActiveSkill activeSkill, int activeSkillLevel) {
            this.playerClass = playerClass;
            this.activeSkill = activeSkill;
            this.activeSkillLevel = activeSkillLevel;
        }
    }
}

