/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.components;

import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.position.FormFixedPosition;
import necesse.gfx.forms.position.FormPosition;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.SpriteTooltip;
import necesse.gfx.gameTooltips.TooltipLocation;
import rpgclasses.RPGResources;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.forms.rpgmenu.BorderFormGameBackground;

public class SkillIconComponent
extends FormButton
implements FormPositionContainer {
    private FormPosition position;
    final Skill skill;
    private int skillLevel;
    final int width;
    final int height;
    boolean showLevelVersion;
    public static Star[] stars = new Star[]{new Star(0, 26, 0), new Star(6, 18, 0), new Star(12, 26, 0), new Star(18, 18, 0), new Star(24, 26, 0), new Star(0, 26, 1), new Star(6, 18, 1), new Star(12, 26, 1), new Star(18, 18, 1), new Star(24, 26, 1), new Star(0, 26, 2), new Star(6, 18, 2), new Star(12, 26, 2), new Star(18, 18, 2), new Star(24, 26, 2), new Star(0, 26, 3), new Star(6, 18, 3), new Star(12, 26, 3), new Star(18, 18, 3), new Star(24, 26, 3)};

    public SkillIconComponent(Skill skill, int skillLevel, int x, int y, int width, int height) {
        this.position = new FormFixedPosition(x, y);
        this.skill = skill;
        this.skillLevel = skillLevel;
        this.width = width;
        this.height = height;
        this.showLevelVersion = true;
        this.onClicked(e -> {
            this.showLevelVersion = !this.showLevelVersion;
        });
    }

    public void setSkillLevel(int skillLevel) {
        this.skillLevel = skillLevel;
    }

    public int getSkillLevel() {
        return this.skillLevel;
    }

    public void draw(TickManager tickManager, PlayerMob player, Rectangle rectangle) {
        int textureWidth = this.skill.texture.getWidth();
        int textureHeight = this.skill.texture.getWidth();
        int drawX = this.getX() + (this.width - textureWidth) / 2;
        int drawY = this.getY() + (this.height - textureHeight) / 2;
        this.skill.texture.initDraw().draw(drawX, drawY);
        for (int i = Math.max(0, this.skillLevel - 5); i < this.skillLevel && i < stars.length; ++i) {
            stars[i].draw(drawX, drawY);
        }
        if (this.isHovering()) {
            String[] extraTooltipsString;
            ListGameTooltips tooltips;
            int showLevel;
            int n = showLevel = this.skillLevel == 0 ? 1 : this.skillLevel;
            if (this.skill.containsComplexTooltips()) {
                if (this.showLevelVersion) {
                    tooltips = this.skill.getFinalToolTips(player, showLevel, false);
                    tooltips.add(" ");
                    tooltips.add(Localization.translate((String)"ui", (String)"clicktoseebase"));
                } else {
                    tooltips = this.skill.getBaseToolTips(player);
                    tooltips.add(" ");
                    tooltips.add(Localization.translate((String)"ui", (String)"clicktoseelevel", (String)"level", (Object)showLevel));
                }
            } else {
                tooltips = this.skill.getBaseToolTips(player);
            }
            GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)new BorderFormGameBackground(12), (TooltipLocation)TooltipLocation.FORM_FOCUS);
            for (String extraTooltip : extraTooltipsString = this.skill.getAllExtraTooltips(player, showLevel, this.showLevelVersion)) {
                GameTooltipManager.addTooltip((GameTooltips)new ListGameTooltips(extraTooltip), (GameBackground)new BorderFormGameBackground(12), (TooltipLocation)TooltipLocation.FORM_FOCUS);
            }
            GameTooltipManager.addTooltip((GameTooltips)new SpriteTooltip(this.skill.texture), (GameBackground)new BorderFormGameBackground(4), (TooltipLocation)TooltipLocation.FORM_FOCUS);
        }
    }

    public List<Rectangle> getHitboxes() {
        return SkillIconComponent.singleBox((Rectangle)new Rectangle(this.getX(), this.getY(), this.width, this.height));
    }

    public FormPosition getPosition() {
        return this.position;
    }

    public void setPosition(FormPosition position) {
        this.position = position;
    }

    public static class Star {
        int x;
        int y;
        int upgrades;

        public Star(int x, int y, int upgrades) {
            this.x = x;
            this.y = y;
            this.upgrades = upgrades;
        }

        public void draw(int iconDrawX, int iconDrawY) {
            RPGResources.UI_TEXTURES.star_textures[this.upgrades].initDraw().draw(this.x + iconDrawX, this.y + iconDrawY);
        }
    }
}

