/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.components;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicInteger;
import necesse.engine.Settings;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.events.FormEventListener;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.RPGResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.content.player.SkillsLogic.SkillsList;
import rpgclasses.data.PlayerClassData;
import rpgclasses.forms.rpgmenu.components.SkillIconComponent;

public class SkillComponent
extends FormContentBox {
    public static int width = 46;
    public static int height = 66;
    int currentSkillLevel;
    FormEventListener<FormInputEvent<FormButton>> onAdd;
    FormEventListener<FormInputEvent<FormButton>> onRemove;

    public SkillComponent(int x, int y, final Skill skill, final PlayerMob player, PlayerClassData classData, int currentSkillLevel, int[] mutableSkillLevels) {
        super(x, y, width, height);
        this.currentSkillLevel = currentSkillLevel;
        Color sameLevel = Settings.UI.activeTextColor;
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        Color differentLevel = style == 1 ? new Color(255, 255, 0) : new Color(102, 102, 0);
        AtomicInteger skillLevel = new AtomicInteger();
        skillLevel.set(currentSkillLevel);
        FormLocalLabel levelText = (FormLocalLabel)this.addComponent((FormComponent)new FormLocalLabel(this.getLevelText(skillLevel.get()), new FontOptions(12), 0, width / 2, 54));
        levelText.setColor(sameLevel);
        SkillIconComponent skillIconComponent = (SkillIconComponent)this.addComponent((FormComponent)new SkillIconComponent(skill, skillLevel.get(), 0, 0, width, 34));
        this.addComponent((FormComponent)new FormContentIconButton(width / 2 + 2, 36, FormInputSize.SIZE_16, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.addSmall_icon[style], new GameMessage[0]){

            protected void addTooltips(PlayerMob perspective) {
                int skillLevel;
                ListGameTooltips tooltips = null;
                if (skill.containsComplexTooltips() && (skillLevel = SkillComponent.this.getSkillLevel()) < skill.levelMax) {
                    tooltips = skill.getFinalToolTips(player, skillLevel + 1, true);
                }
                if (tooltips != null) {
                    GameTooltipManager.addTooltip(tooltips, (GameBackground)GameBackground.itemTooltip, (TooltipLocation)TooltipLocation.FORM_FOCUS);
                }
            }
        }.onClicked(c -> {
            int classLevel = classData.getLevel(false);
            int maxLevel = classData.getEffectiveSkillMaxLevel(skill, classLevel, mutableSkillLevels);
            if (skillLevel.get() >= maxLevel) {
                return;
            }
            boolean wellAssigned = true;
            int[] newMutableSkillLevels = (int[])mutableSkillLevels.clone();
            int n = skill.id;
            newMutableSkillLevels[n] = newMutableSkillLevels[n] + 1;
            SkillsList<Skill> skillsList = skill instanceof Passive ? classData.playerClass.passivesList : classData.playerClass.activeSkillsList;
            for (int i = 0; i < newMutableSkillLevels.length; ++i) {
                Skill skill1;
                if (i == skill.id || newMutableSkillLevels[i] <= (maxLevel = classData.getEffectiveSkillMaxLevel(skill1 = skillsList.get(i), classLevel, newMutableSkillLevels))) continue;
                wellAssigned = false;
                break;
            }
            if (!wellAssigned) {
                return;
            }
            if (skill instanceof ActiveSkill) {
                boolean hasRequired = true;
                ActiveSkill activeSkill = (ActiveSkill)skill;
                for (ActiveSkill.RequiredSkill requiredSkill : activeSkill.requiredSkills) {
                    if (mutableSkillLevels[requiredSkill.activeSkill.id] >= requiredSkill.activeSkillLevel) continue;
                    hasRequired = false;
                    break;
                }
                if (!hasRequired) {
                    return;
                }
            }
            if (skill instanceof Passive && skill.family != null) {
                boolean onlyInFamily = true;
                for (int i = 0; i < mutableSkillLevels.length; ++i) {
                    if (mutableSkillLevels[i] <= 0 || i == skill.id) continue;
                    Passive other = classData.playerClass.passivesList.get(i);
                    if (other.family == null || !other.family.equals(skill.family)) continue;
                    onlyInFamily = false;
                    break;
                }
                if (!onlyInFamily) {
                    return;
                }
            }
            int newLevel = skillLevel.incrementAndGet();
            levelText.setLocalization(this.getLevelText(newLevel));
            levelText.setColor(newLevel == currentSkillLevel ? sameLevel : differentLevel);
            skillIconComponent.setSkillLevel(newLevel);
            this.onAdd.onEvent(c);
        }));
        this.addComponent((FormComponent)new FormContentIconButton(width / 2 - 16 - 2, 36, FormInputSize.SIZE_16, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.removeSmall_icon[style], new GameMessage[0]){

            protected void addTooltips(PlayerMob perspective) {
                int skillLevel;
                ListGameTooltips tooltips = null;
                if (skill.containsComplexTooltips() && (skillLevel = SkillComponent.this.getSkillLevel()) > 1) {
                    tooltips = skill.getFinalToolTips(player, skillLevel - 1, true);
                }
                if (tooltips != null) {
                    GameTooltipManager.addTooltip(tooltips, (GameBackground)GameBackground.itemTooltip, (TooltipLocation)TooltipLocation.FORM_FOCUS);
                }
            }
        }.onClicked(c -> {
            if (skillLevel.get() > 0) {
                if (skill instanceof ActiveSkill) {
                    int isRequirement = SkillComponent.getIsRequirement(skill, classData, mutableSkillLevels);
                    if (skillLevel.get() <= isRequirement) {
                        return;
                    }
                }
                int newLevel = skillLevel.decrementAndGet();
                levelText.setLocalization(this.getLevelText(newLevel));
                levelText.setColor(newLevel == currentSkillLevel ? sameLevel : differentLevel);
                skillIconComponent.setSkillLevel(newLevel);
                this.onRemove.onEvent(c);
            }
        }));
    }

    private static int getIsRequirement(Skill skill, PlayerClassData classData, int[] mutableSkillLevels) {
        int isRequirement = 0;
        for (ActiveSkill activeSkill : classData.playerClass.activeSkillsList.getList()) {
            for (ActiveSkill.RequiredSkill requiredSkill : activeSkill.requiredSkills) {
                int levelRequired;
                if (requiredSkill == null || requiredSkill.activeSkill.id != skill.id || mutableSkillLevels[activeSkill.id] <= 0 || (levelRequired = requiredSkill.activeSkillLevel) <= isRequirement) continue;
                isRequirement = levelRequired;
            }
        }
        return isRequirement;
    }

    public GameMessage getLevelText(int skillLevel) {
        return new LocalMessage("ui", "lvl", new Object[]{"level", skillLevel});
    }

    public int getSkillLevel() {
        return this.currentSkillLevel;
    }

    public void addSkillLevel(int n) {
        this.currentSkillLevel += n;
    }

    public void setOnAdd(FormEventListener<FormInputEvent<FormButton>> onAdd) {
        this.onAdd = onAdd;
    }

    public void setOnRemove(FormEventListener<FormInputEvent<FormButton>> onRemove) {
        this.onRemove = onRemove;
    }
}

