/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.components;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.Renderer;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.forms.rpgmenu.BorderFormGameBackground;

public class MasteryIconComponent
extends FormButton {
    final Mastery mastery;
    final int x;
    final int y;
    final int width;
    final int height;
    public boolean hasMastery;

    public MasteryIconComponent(Mastery mastery, int x, int y, int width, int height, boolean hasMastery) {
        this.mastery = mastery;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.hasMastery = hasMastery;
    }

    public void draw(TickManager tickManager, PlayerMob player, Rectangle rectangle) {
        int textureWidth = this.mastery.texture.getWidth();
        int textureHeight = this.mastery.texture.getWidth();
        if (this.hasMastery) {
            Renderer.drawCircle((int)(this.x + this.width / 2), (int)(this.y + this.height / 2), (int)(this.width / 2), (int)20, (Color)new Color(0, 255, 0, 102), (boolean)true);
        }
        this.mastery.texture.initDraw().draw(this.x + (this.width - textureWidth) / 2, this.y + (this.height - textureHeight) / 2);
        if (this.isHovering()) {
            String[] extraTooltipsString;
            ListGameTooltips tooltips = this.mastery.getBaseToolTips(player);
            GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)new BorderFormGameBackground(12), (TooltipLocation)TooltipLocation.FORM_FOCUS);
            for (String extraTooltip : extraTooltipsString = this.mastery.getAllExtraTooltips(player, 1, true)) {
                GameTooltipManager.addTooltip((GameTooltips)new ListGameTooltips(Localization.translate((String)"extraskilldesc", (String)extraTooltip)), (GameBackground)new BorderFormGameBackground(12), (TooltipLocation)TooltipLocation.FORM_FOCUS);
            }
        }
    }

    public List<Rectangle> getHitboxes() {
        ArrayList<Rectangle> hitBoxes = new ArrayList<Rectangle>();
        hitBoxes.add(new Rectangle(this.x, this.y, this.width, this.height));
        return hitBoxes;
    }
}

