/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.components;

import java.util.function.Consumer;
import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.RPGResources;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.forms.rpgmenu.components.SkillIconComponent;
import rpgclasses.forms.rpgmenu.entries.ActiveSkillsEntry;

public class EquipActiveSkillComponent
extends FormContentBox {
    public static int height = 54;
    public static int shortWidth = 300;
    private final FormContentIconButton[] buttons = new FormContentIconButton[PlayerData.EQUIPPED_SKILLS_MAX];
    public final PlayerClass playerClass;
    public final ActiveSkill activeSkill;

    public EquipActiveSkillComponent(int x, int y, ActiveSkill activeSkill, PlayerClass playerClass, PlayerMob player, int skillLevel, int showManySlots, int width, Consumer<EquippedActiveSkill[]> onClick) {
        super(x, y, width, height);
        PlayerData playerData = PlayerDataList.getPlayerData(player);
        this.playerClass = playerClass;
        this.activeSkill = activeSkill;
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        this.addComponent((FormComponent)new SkillIconComponent(activeSkill, skillLevel, 0, 0, 34, 54));
        this.addComponent((FormComponent)new FormLocalLabel(this.getSkillText(activeSkill, skillLevel), new FontOptions(16), -1, 44, 0));
        for (int i = 0; i < showManySlots; ++i) {
            int finalI = i;
            this.buttons[i] = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(44 + 36 * i, 22, FormInputSize.SIZE_32, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.slot_icons[style][i], new GameMessage[]{new StaticMessage("[input=activeskillslot" + (i + 1) + "]")}).onClicked(c -> {
                EquippedActiveSkill[] newEquippedActiveSkills = (EquippedActiveSkill[])playerData.equippedActiveSkills.clone();
                boolean sameFamily = false;
                for (int j = 0; j < PlayerData.EQUIPPED_SKILLS_MAX; ++j) {
                    if (finalI == j || !newEquippedActiveSkills[j].isNotSameSkillButSameFamily(playerClass, activeSkill)) continue;
                    sameFamily = true;
                    break;
                }
                if (sameFamily) {
                    return;
                }
                EquippedActiveSkill oldEquippedActiveSkill = newEquippedActiveSkills[finalI];
                if (!player.isInCombat() && oldEquippedActiveSkill.canChange(player.getTime())) {
                    if (oldEquippedActiveSkill.isSameSkill(playerClass, activeSkill)) {
                        oldEquippedActiveSkill.empty();
                    } else {
                        boolean canChange = true;
                        for (int j = 0; j < PlayerData.EQUIPPED_SKILLS_MAX; ++j) {
                            EquippedActiveSkill equippedActiveSkill = newEquippedActiveSkills[j];
                            if (finalI == j || !equippedActiveSkill.isSameSkill(playerClass, activeSkill)) continue;
                            if (!equippedActiveSkill.canChange(player.getTime())) {
                                canChange = false;
                                break;
                            }
                            equippedActiveSkill.empty();
                        }
                        if (canChange) {
                            oldEquippedActiveSkill.update(playerClass, activeSkill);
                        }
                    }
                    onClick.accept(newEquippedActiveSkills);
                }
            }));
        }
        this.update(playerData.equippedActiveSkills, playerData);
    }

    public void update(EquippedActiveSkill[] newEquippedActiveSkills, PlayerData playerData) {
        for (int i = 0; i < ActiveSkillsEntry.showManySlots; ++i) {
            EquippedActiveSkill equippedActiveSkill;
            boolean sameFamily = false;
            boolean sameSkill = false;
            for (int j = 0; j < PlayerData.EQUIPPED_SKILLS_MAX; ++j) {
                if (i == j || newEquippedActiveSkills[j] == null) continue;
                if (newEquippedActiveSkills[j].isSameSkill(this.playerClass, this.activeSkill)) {
                    sameSkill = true;
                    break;
                }
                if (!newEquippedActiveSkills[j].isSameFamily(this.playerClass, this.activeSkill)) continue;
                sameFamily = true;
                break;
            }
            this.buttons[i].color = (equippedActiveSkill = newEquippedActiveSkills[i]).isSameSkill(this.playerClass, this.activeSkill) ? ButtonColor.GREEN : (sameSkill ? ButtonColor.BASE : (sameFamily ? ButtonColor.RED : (equippedActiveSkill.isEmpty() ? ButtonColor.YELLOW : (equippedActiveSkill.getActiveSkill().getLevel(playerData) > 0 ? ButtonColor.BASE : ButtonColor.YELLOW))));
        }
    }

    public GameMessage getSkillText(ActiveSkill activeSkill, int skillLevel) {
        return new StaticMessage(Localization.translate((String)"activeskills", (String)activeSkill.stringID) + " - " + Localization.translate((String)"ui", (String)"lvl", (String)"level", (Object)skillLevel));
    }
}

