/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.components;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import necesse.engine.Settings;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.events.FormEventListener;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.RPGResources;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.UpcomingPlayerClass;
import rpgclasses.forms.rpgmenu.components.ClassIconComponent;

public class ClassComponent
extends FormContentBox {
    public static int width = 104;
    public static int height = 116;
    public final AtomicInteger classLevel;
    public final Color sameLevel;
    public final Color differentLevel;
    public final FormLocalLabel levelText;
    public final PlayerClass playerClass;
    public final int currentClassLevel;
    ClassIconComponent classIconComponent;

    public ClassComponent(int x, int y, PlayerClass playerClass, int currentClassLevel) {
        super(x - width / 2, y - height / 2, width, height);
        this.playerClass = playerClass;
        this.currentClassLevel = currentClassLevel;
        this.sameLevel = Settings.UI.activeTextColor;
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        this.differentLevel = style == 1 ? new Color(255, 255, 0) : new Color(102, 102, 0);
        this.classLevel = new AtomicInteger();
        this.classLevel.set(currentClassLevel);
        this.levelText = (FormLocalLabel)this.addComponent((FormComponent)new FormLocalLabel(this.getLevelText(this.classLevel.get()), new FontOptions(16), 0, width / 2, 100));
        this.levelText.setColor(this.sameLevel);
        this.classIconComponent = (ClassIconComponent)this.addComponent((FormComponent)new ClassIconComponent(playerClass, 0, 0, width, 68));
    }

    public void addOnMod(Predicate<Integer> onMod) {
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        int center = width / 2;
        FormContentIconButton buttonAdd = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(center + 4, 72, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.add_icon[style], new GameMessage[0]).onClicked(c -> {
            if (onMod.test(this.classLevel.get() + 1)) {
                int newLevel = this.classLevel.incrementAndGet();
                this.levelText.setLocalization(this.getLevelText(newLevel));
                this.levelText.setColor(newLevel == this.currentClassLevel ? this.sameLevel : this.differentLevel);
            }
        }));
        FormContentIconButton buttonRemove = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(center - 4 - 24, 72, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.remove_icon[style], new GameMessage[0]).onClicked(c -> {
            if (onMod.test(this.classLevel.get() - 1)) {
                int newLevel = this.classLevel.decrementAndGet();
                this.levelText.setLocalization(this.getLevelText(newLevel));
                this.levelText.setColor(newLevel == this.currentClassLevel ? this.sameLevel : this.differentLevel);
            }
        }));
        FormContentIconButton buttonAdd10 = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(center + 4 + 24 + 2, 76, FormInputSize.SIZE_16, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.add10_icon[style], new GameMessage[0]).onClicked(c -> {
            int mod = Math.min(10, 999 - this.classLevel.get());
            if (onMod.test(this.classLevel.get() + mod)) {
                int newLevel = this.classLevel.addAndGet(mod);
                this.levelText.setLocalization(this.getLevelText(newLevel));
                this.levelText.setColor(newLevel == this.currentClassLevel ? this.sameLevel : this.differentLevel);
            }
        }));
        FormContentIconButton buttonRemove10 = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(center - 4 - 24 - 2 - 16, 76, FormInputSize.SIZE_16, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.remove10_icon[style], new GameMessage[0]).onClicked(c -> {
            int mod = Math.min(10, this.classLevel.get());
            if (onMod.test(this.classLevel.get() - mod)) {
                int newLevel = this.classLevel.addAndGet(-mod);
                this.levelText.setLocalization(this.getLevelText(newLevel));
                this.levelText.setColor(newLevel == this.currentClassLevel ? this.sameLevel : this.differentLevel);
            }
        }));
        if (this.playerClass instanceof UpcomingPlayerClass) {
            buttonAdd.setActive(false);
            buttonRemove.setActive(false);
            buttonAdd10.setActive(false);
            buttonRemove10.setActive(false);
        }
    }

    public void onClick(FormEventListener<FormInputEvent<FormButton>> listener) {
        this.classIconComponent.onClicked(listener);
    }

    public GameMessage getLevelText(int classLevel) {
        return new LocalMessage("ui", "level", new Object[]{"level", classLevel});
    }
}

