/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.components;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import rpgclasses.content.player.Attribute;
import rpgclasses.forms.rpgmenu.BorderFormGameBackground;

public class AttributeIconComponent
extends FormButton {
    final Attribute attribute;
    final int x;
    final int y;
    final int width;
    final int height;

    public AttributeIconComponent(Attribute attribute, int x, int y, int width, int height) {
        this.attribute = attribute;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void draw(TickManager tickManager, PlayerMob player, Rectangle rectangle) {
        int textureWidth = this.attribute.texture.getWidth();
        int textureHeight = this.attribute.texture.getWidth();
        this.attribute.texture.initDraw().draw(this.x + (this.width - textureWidth) / 2, this.y + (this.height - textureHeight) / 2);
        if (this.isHovering()) {
            String[] extraTooltipsString;
            ListGameTooltips tooltips = this.attribute.getBaseToolTips(player);
            GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)new BorderFormGameBackground(12), (TooltipLocation)TooltipLocation.FORM_FOCUS);
            for (String extraTooltip : extraTooltipsString = this.attribute.getAllExtraTooltips(player, 1, true)) {
                GameTooltipManager.addTooltip((GameTooltips)new ListGameTooltips(Localization.translate((String)"extraskilldesc", (String)extraTooltip)), (GameBackground)new BorderFormGameBackground(12), (TooltipLocation)TooltipLocation.FORM_FOCUS);
            }
        }
    }

    public List<Rectangle> getHitboxes() {
        ArrayList<Rectangle> hitBoxes = new ArrayList<Rectangle>();
        hitBoxes.add(new Rectangle(this.x, this.y, this.width, this.height));
        return hitBoxes;
    }
}

