/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu.components;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.atomic.AtomicInteger;
import necesse.engine.Settings;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.client.Client;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.events.FormEventListener;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.gfx.ui.GameInterfaceStyle;
import rpgclasses.RPGResources;
import rpgclasses.content.player.Attribute;
import rpgclasses.data.PlayerData;
import rpgclasses.forms.rpgmenu.components.AttributeIconComponent;

public class AttributeComponent
extends FormContentBox {
    public static int width = 104;
    public static int height = 144;
    public final AtomicInteger attributePoints;
    public final Color samePoints;
    public final Color differentPoints;
    public final FormLocalLabel levelText;
    public final FormLocalLabel pointsText;
    public final int currentAttributePoints;

    public AttributeComponent(Client client, int x, int y, Attribute attribute, int currentAttributePoints) {
        super(x - width / 2, y - height / 2, width, height);
        this.currentAttributePoints = currentAttributePoints;
        this.samePoints = Settings.UI.activeTextColor;
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        this.differentPoints = style == 1 ? new Color(255, 255, 0) : new Color(102, 102, 0);
        this.attributePoints = new AtomicInteger();
        this.attributePoints.set(currentAttributePoints);
        this.pointsText = (FormLocalLabel)this.addComponent((FormComponent)new FormLocalLabel(this.getPointsText(this.attributePoints.get()), new FontOptions(12), 0, width / 2, 92));
        this.pointsText.setColor(this.samePoints);
        this.levelText = (FormLocalLabel)this.addComponent((FormComponent)new FormLocalLabel(this.getLevelText(this.attributePoints.get()), new FontOptions(16), 0, width / 2, 112));
        int extraPoints = (Integer)client.getPlayer().buffManager.getModifier(attribute.ownModifier);
        if (extraPoints > 0) {
            this.addComponent((FormComponent)new FormLabel("(+" + extraPoints + ")", new FontOptions(12), 0, width / 2, 132));
        }
        this.addComponent((FormComponent)new AttributeIconComponent(attribute, 0, 0, width, 60));
    }

    public void addOnMod(FormEventListener<FormInputEvent<FormButton>> onMod) {
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        int center = width / 2;
        this.addComponent((FormComponent)new FormContentIconButton(center + 4, 64, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.add_icon[style], new GameMessage[0]).onClicked(c -> {
            if (this.attributePoints.get() < 999) {
                this.updateTexts(this.attributePoints.incrementAndGet());
                onMod.onEvent(c);
            }
        }));
        this.addComponent((FormComponent)new FormContentIconButton(center - 4 - 24, 64, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.remove_icon[style], new GameMessage[0]).onClicked(c -> {
            if (this.attributePoints.get() > 0) {
                this.updateTexts(this.attributePoints.decrementAndGet());
                onMod.onEvent(c);
            }
        }));
        this.addComponent((FormComponent)new FormContentIconButton(center + 4 + 24 + 2, 68, FormInputSize.SIZE_16, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.add10_icon[style], new GameMessage[0]).onClicked(c -> {
            if (this.attributePoints.get() < 999) {
                int mod = Math.min(10, 999 - this.attributePoints.get());
                this.updateTexts(this.attributePoints.addAndGet(mod));
                onMod.onEvent(c);
            }
        }));
        this.addComponent((FormComponent)new FormContentIconButton(center - 4 - 24 - 2 - 16, 68, FormInputSize.SIZE_16, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.remove10_icon[style], new GameMessage[0]).onClicked(c -> {
            if (this.attributePoints.get() > 0) {
                int mod = -Math.min(10, this.attributePoints.get());
                this.updateTexts(this.attributePoints.addAndGet(mod));
                onMod.onEvent(c);
            }
        }));
    }

    public void updateTexts(int usedPoints) {
        this.levelText.setLocalization(this.getLevelText(usedPoints));
        this.pointsText.setLocalization(this.getPointsText(usedPoints));
        this.pointsText.setColor(usedPoints == this.currentAttributePoints ? this.samePoints : this.differentPoints);
    }

    public GameMessage getLevelText(int usedPoints) {
        float level = PlayerData.pointsConversion(usedPoints);
        if (level == (float)((int)level)) {
            return new LocalMessage("ui", "level", new Object[]{"level", (int)level});
        }
        BigDecimal levelBD = new BigDecimal(Float.toString(level));
        levelBD = levelBD.setScale(2, RoundingMode.DOWN);
        return new LocalMessage("ui", "level", "level", levelBD.toString());
    }

    public GameMessage getPointsText(int usedPoints) {
        return new LocalMessage("ui", "points", new Object[]{"points", usedPoints});
    }
}

