/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import necesse.engine.Settings;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.client.Client;
import necesse.engine.platforms.Platform;
import necesse.engine.platforms.PlatformManager;
import necesse.engine.util.GameUtils;
import necesse.engine.window.GameWindow;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormBreakLine;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormComponentList;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormCustomButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.forms.presets.ExternalLinkForm;
import necesse.gfx.forms.presets.containerComponent.ContainerFormSwitcher;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonState;
import necesse.gfx.ui.GameInterfaceStyle;
import necesse.inventory.container.Container;
import rpgclasses.RPGMod;
import rpgclasses.RPGResources;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.forms.rpgmenu.MenuContainer;
import rpgclasses.forms.rpgmenu.components.PlayerDataComponent;
import rpgclasses.forms.rpgmenu.entries.ActiveSkillsEntry;
import rpgclasses.forms.rpgmenu.entries.AttributesEntry;
import rpgclasses.forms.rpgmenu.entries.ClassEntry;
import rpgclasses.forms.rpgmenu.entries.ClassesEntry;
import rpgclasses.forms.rpgmenu.entries.MasteryEntry;
import rpgclasses.forms.rpgmenu.entries.MenuEntry;
import rpgclasses.settings.RPGSettings;

public class MenuContainerForm
extends ContainerFormSwitcher<MenuContainer> {
    public static String modUrl = "https://steamcommunity.com/sharedfiles/filedetails/?id=3534267732";
    public Client client;
    private final Form principalForm;
    public static boolean showClassIcons = RPGSettings.settingsGetter.getBoolean("showClassIcons");
    public static final MenuEntry[] menuEntries = new MenuEntry[]{new AttributesEntry(), new ActiveSkillsEntry(), new ClassesEntry()};
    public static final MenuEntry masteryEntry = new MasteryEntry();
    public static MenuEntry actualEntry = menuEntries[0];
    public FormContentBox entries;
    public FormContentBox entryForm;
    PlayerDataComponent playerDataComponent;
    public static FormComponentList returnForm;
    public static FormInputSize SIZE_20_SMALL_FONT;

    public MenuContainerForm(Client client, MenuContainer container) {
        super(client, (Container)container);
        this.client = client;
        FormComponentList formComponents = returnForm = (FormComponentList)this.addComponent((FormComponent)new FormComponentList());
        this.principalForm = (Form)formComponents.addComponent((FormComponent)new Form(925, 500));
        this.entries = (FormContentBox)this.principalForm.addComponent((FormComponent)new FormContentBox(0, 46, 190, 274));
        LocalMessage rateMessage = new LocalMessage("ui", "rate");
        ((FormLocalTextButton)this.principalForm.addComponent((FormComponent)new FormLocalTextButton((GameMessage)rateMessage, (GameMessage)new StaticMessage(modUrl), 20, 326, 155, SIZE_20_SMALL_FONT, ButtonColor.BASE))).onClicked(arg_0 -> this.lambda$new$0((GameMessage)rateMessage, arg_0));
        FormBreakLine playerLevelBreakLike = (FormBreakLine)this.principalForm.addComponent((FormComponent)new FormBreakLine(FormBreakLine.ALIGN_BEGINNING, 10, 355, 175, true));
        playerLevelBreakLike.color = Settings.UI.activeTextColor;
        FormBreakLine middleVerticalLine = (FormBreakLine)this.principalForm.addComponent((FormComponent)new FormBreakLine(FormBreakLine.ALIGN_BEGINNING, this.entries.getWidth() + 10, 10, this.principalForm.getHeight() - 55, false));
        middleVerticalLine.color = Settings.UI.activeTextColor;
        this.playerDataComponent = (PlayerDataComponent)this.principalForm.addComponent((FormComponent)new PlayerDataComponent(12, 360, 226, 100));
        FormLabel titleComponent = (FormLabel)this.principalForm.addComponent((FormComponent)new FormLocalLabel("ui", "menutitle", new FontOptions(16), 0, 95, 20, 186));
        if (GameInterfaceStyle.styles.indexOf(Settings.UI) == 1) {
            titleComponent.setColor(new Color(255, 215, 0));
        } else {
            titleComponent.setColor(new Color(0, 51, 102));
        }
        FormLabel version = (FormLabel)this.principalForm.addComponent((FormComponent)new FormLabel(RPGMod.currentVersion, new FontOptions(10), 1, 921, 4));
        version.setColor(Settings.UI.activeTextColor);
        this.entryForm = (FormContentBox)this.principalForm.addComponent((FormComponent)new FormContentBox(this.entries.getWidth() + 20, 10, 925 - this.entries.getWidth() - 20 - 4, this.principalForm.getHeight() - 60));
        ((FormLocalTextButton)this.principalForm.addComponent((FormComponent)new FormLocalTextButton("ui", "closebutton", 4, this.principalForm.getHeight() - 40, this.principalForm.getWidth() - 8))).onClicked(e -> client.closeContainer(true));
        this.makeCurrent((FormComponent)formComponents);
        PlayerMob player = client.getPlayer();
        this.updateEntries(container, player, null);
        this.updateContent(container, player);
        this.playerDataComponent.updateContent(player);
    }

    public void updateEntries(MenuContainer container, final PlayerMob player, int[] classLevels) {
        this.entries.clearComponents();
        PlayerData playerData = PlayerDataList.getPlayerData(player);
        List showEntries = Arrays.stream(menuEntries).collect(Collectors.toCollection(ArrayList::new));
        if (playerData.totalMasteryPoints() > 0) {
            showEntries.add(1, masteryEntry);
        }
        for (int i = 0; i < playerData.getClassLevels().length; ++i) {
            PlayerClass playerClass = PlayerClass.classesList.get(i);
            if (!playerClass.isEnabled() || (classLevels == null ? playerData.getClassLevel(i) : classLevels[i]) <= 0) continue;
            showEntries.add(new ClassEntry("classes." + playerClass.stringID, playerClass));
        }
        if (showEntries.stream().noneMatch(entry -> Objects.equals(entry.name, MenuContainerForm.actualEntry.name))) {
            showEntries.add(actualEntry);
        }
        final int width = 178;
        final int height = showClassIcons ? 34 : 28;
        int space = 4;
        for (int i = 0; i < showEntries.size(); ++i) {
            final MenuEntry menuEntry = (MenuEntry)showEntries.get(i);
            this.entries.addComponent((FormComponent)new FormCustomButton(6, space + i * (height + space), width, height, new GameMessage[0]){

                public void draw(Color color, int i, int i1, PlayerMob playerMob) {
                    FontOptions fontOptions = new FontOptions(16).color(this.getTextColor());
                    Color textColor = menuEntry.getTextColor(player);
                    if (textColor != null) {
                        fontOptions.color(textColor);
                    }
                    if (!Objects.equals(MenuContainerForm.actualEntry.name, menuEntry.name)) {
                        if (this.isHovering()) {
                            fontOptions.alpha(204);
                        } else {
                            fontOptions.alpha(153);
                        }
                    }
                    String drawText = menuEntry.getDisplayName();
                    float drawX = (float)width / 2.0f - (float)FontManager.bit.getWidthCeil(drawText, fontOptions) / 2.0f + 10.0f;
                    FontManager.bit.drawString(drawX, (float)this.getY() + (float)(height - 16) / 2.0f, drawText, fontOptions);
                    GameTexture gameTexture = menuEntry.getTexture();
                    if (gameTexture != null && (!menuEntry.name.startsWith("classes.") || showClassIcons)) {
                        gameTexture.initDraw().size(height).draw(6, this.getY());
                    }
                }
            }.onClicked(e -> this.changeEntry(menuEntry, player)));
        }
        this.entries.setContentBox(new Rectangle(0, 0, this.entries.getWidth(), 12 + showEntries.size() * 40));
    }

    public void changeEntry(String entryName, PlayerMob player) {
        if (entryName.startsWith("classes.")) {
            String playerClassStringID = entryName.replace("classes.", "");
            PlayerClass playerClass = PlayerClass.classesList.stream().filter(pClass -> Objects.equals(pClass.stringID, playerClassStringID)).findFirst().orElse(null);
            if (playerClass != null) {
                this.changeEntry(new ClassEntry(entryName, playerClass), player);
            }
        } else {
            this.changeEntry((MenuEntry)Arrays.stream(menuEntries).filter(entry -> Objects.equals(entry.name, entryName)).findAny().orElse(null), player);
        }
    }

    public void changeEntry(MenuEntry entry, PlayerMob player) {
        if (entry != null) {
            actualEntry = entry;
        }
        this.updateContent((MenuContainer)this.container, player);
        this.updateEntries((MenuContainer)this.container, player, null);
    }

    public void updateContent(MenuContainer container, PlayerMob player) {
        this.entryForm.clearComponents();
        MenuContainerForm.actualEntry.client = this.client;
        MenuContainerForm.actualEntry.player = player;
        actualEntry.updateContent(this, this.entryForm, container);
    }

    public void onWindowResized(GameWindow window) {
        super.onWindowResized(window);
        this.principalForm.setPosMiddle(window.getHudWidth() / 2, window.getHudHeight() / 2);
    }

    public boolean shouldOpenInventory() {
        return false;
    }

    public boolean shouldShowToolbar() {
        return false;
    }

    private void openUrlOrShowExternalLink(GameMessage title, String url, GameTexture qrCodeTexture) {
        if (PlatformManager.getPlatform().getOperatingSystemFamily() == Platform.OperatingSystemFamily.Windows) {
            GameUtils.openURL((String)url);
        } else {
            ExternalLinkForm externalLink = new ExternalLinkForm(qrCodeTexture, url, title, () -> this.makeCurrent((FormComponent)returnForm));
            this.addAndMakeCurrentTemporary((FormComponent)externalLink);
        }
    }

    private /* synthetic */ void lambda$new$0(GameMessage rateMessage, FormInputEvent e) {
        this.openUrlOrShowExternalLink(rateMessage, modUrl, RPGResources.UI_TEXTURES.qr_texture);
    }

    static {
        SIZE_20_SMALL_FONT = new FormInputSize(20, 0, 4, 1){

            public DrawOptions getButtonDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> this.drawWidthComponent(Settings.UI.button_20.getButtonTexture(color, state), x, y, width, drawColor);
            }

            public DrawOptions getButtonDownDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> this.drawWidthComponent(Settings.UI.button_20.getButtonDownTexture(color, state), x, y, width, drawColor);
            }

            public DrawOptions getButtonEdgeDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> {};
            }

            public DrawOptions getButtonDownEdgeDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> {};
            }

            public DrawOptions getFormTabDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> this.drawTabWidthComponentFull((GameTexture)state.textureGetter.apply(Settings.UI.formtab_20), x, y, width, drawColor);
            }

            public DrawOptions getFormTabDownDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> this.drawTabWidthComponentFull((GameTexture)state.downTextureGetter.apply(Settings.UI.formtab_20), x, y, width, drawColor);
            }

            public DrawOptions getFormTabEdgeDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> this.drawTabWidthComponentEdgeFull((GameTexture)state.downTextureGetter.apply(Settings.UI.formtab_20), (GameTexture)state.textureGetter.apply(Settings.UI.formtabedge_20), x, y, width, drawColor);
            }

            public DrawOptions getFormTabDownEdgeDrawOptions(GameInterfaceStyle gameInterfaceStyle, ButtonColor color, ButtonState state, int x, int y, int width, Color drawColor) {
                return () -> this.drawTabWidthComponentEdgeFull((GameTexture)state.downTextureGetter.apply(Settings.UI.formtab_20), (GameTexture)state.textureGetter.apply(Settings.UI.formtabedge_20), x, y, width, drawColor);
            }

            public Color getButtonColor(GameInterfaceStyle gameInterfaceStyle, ButtonState state) {
                return Settings.UI.button_20.getButtonColor(Settings.UI, state);
            }

            public Color getTextColor(GameInterfaceStyle gameInterfaceStyle, ButtonState state) {
                return Settings.UI.button_20.getTextColor(Settings.UI, state);
            }

            public DrawOptions getInputDrawOptions(GameInterfaceStyle gameInterfaceStyle, int x, int y, int width) {
                return () -> this.drawWidthComponent(Settings.UI.textinput_20, x, y, width, Color.WHITE);
            }

            public FontOptions getFontOptions() {
                return new FontOptions(12);
            }

            public Rectangle getContentRectangle(int width) {
                return new Rectangle(2, 2, width - 4, 16);
            }
        };
    }
}

