/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.rpgmenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.inventory.container.Container;
import rpgclasses.content.player.Attribute;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.forms.rpgmenu.customactions.ClassUpdateCustomAction;
import rpgclasses.forms.rpgmenu.customactions.EquippedActiveSkillsCustomAction;
import rpgclasses.forms.rpgmenu.customactions.IntArrayCustomAction;
import rpgclasses.forms.rpgmenu.entries.ClassEntry;
import rpgclasses.packets.UpdateClientAttributesPacket;
import rpgclasses.packets.UpdateClientClassDataPacket;
import rpgclasses.packets.UpdateClientClassesPacket;
import rpgclasses.packets.UpdateClientEquippedActiveSkillsPacket;
import rpgclasses.packets.UpdateClientMasteryPacket;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.settings.RPGSettings;

public class MenuContainer
extends Container {
    public final IntArrayCustomAction updateAttributes;
    public final IntArrayCustomAction updateMasterySkills;
    public final IntArrayCustomAction updateClasses;
    public final ClassUpdateCustomAction updateClass;
    public final EquippedActiveSkillsCustomAction updateEquippedActiveSkills;

    public MenuContainer(final NetworkClient client, int uniqueSeed) {
        super(client, uniqueSeed);
        this.updateAttributes = (IntArrayCustomAction)this.registerAction(new IntArrayCustomAction(){

            @Override
            protected void run(int[] attributePoints) {
                if (client.isServer()) {
                    if (client.playerMob.isInCombat()) {
                        client.getServerClient().sendChatMessage((GameMessage)new LocalMessage("message", "noupdatesincombat"));
                        return;
                    }
                    ServerClient serverClient = client.getServerClient();
                    if (Arrays.stream(attributePoints).allMatch(attr -> attr < 1000 && attr >= 0)) {
                        PlayerData playerData;
                        int total = Arrays.stream(attributePoints).sum();
                        if (total <= (playerData = PlayerDataList.getPlayerData(serverClient.playerMob)).totalAttributePoints()) {
                            int reduced = 0;
                            for (int i = 0; i < attributePoints.length; ++i) {
                                int difference = playerData.getAttributePoints(i) - attributePoints[i];
                                if (difference <= 0) continue;
                                reduced += difference;
                            }
                            if (reduced > 0) {
                                if (playerData.getResets() >= reduced) {
                                    playerData.modResetsSendPacket(serverClient, -reduced);
                                } else {
                                    System.out.println("updateAttributes: Not enough Reset Points");
                                    return;
                                }
                            }
                            playerData.setAttributePointsUsed(attributePoints);
                            serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientAttributesPacket(playerData));
                            playerData.updateModifiersBuff(serverClient.playerMob);
                        } else {
                            System.out.println("updateAttributes: Not enough Attribute Points");
                        }
                    } else {
                        System.out.println("updateAttributes: At least one wrong assigned attribute level");
                    }
                }
            }

            @Override
            public int arrayLength() {
                return Attribute.attributesList.size();
            }
        });
        this.updateMasterySkills = (IntArrayCustomAction)this.registerAction(new IntArrayCustomAction(){

            @Override
            protected void run(int[] enabledMasterySkills) {
                if (client.isServer()) {
                    if (client.playerMob.isInCombat()) {
                        client.getServerClient().sendChatMessage((GameMessage)new LocalMessage("message", "noupdatesincombat"));
                        return;
                    }
                    ServerClient serverClient = client.getServerClient();
                    int total = enabledMasterySkills.length;
                    PlayerData playerData = PlayerDataList.getPlayerData(serverClient.playerMob);
                    if (total > playerData.totalMasteryPoints()) {
                        System.out.println("updateMasterySkills: Not enough Mastery Points");
                        return;
                    }
                    ArrayList<Integer> newMasterySkills = new ArrayList<Integer>(enabledMasterySkills.length);
                    for (int skill : enabledMasterySkills) {
                        newMasterySkills.add(skill);
                    }
                    int reduced = 0;
                    for (Integer masterySkill : playerData.masterySkills) {
                        if (newMasterySkills.contains(masterySkill)) continue;
                        reduced += 5;
                    }
                    if (reduced > 0) {
                        if (playerData.getResets() >= reduced) {
                            playerData.modResetsSendPacket(serverClient, -reduced);
                        } else {
                            System.out.println("updateMasterySkills: Not enough Reset Points");
                            return;
                        }
                    }
                    playerData.setMasterySkills(newMasterySkills);
                    serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientMasteryPacket(playerData));
                    playerData.updateAllBuffs(serverClient.playerMob);
                }
            }
        });
        this.updateClasses = (IntArrayCustomAction)this.registerAction(new IntArrayCustomAction(){

            @Override
            protected void run(int[] classLevels) {
                if (client.isServer()) {
                    PlayerData playerData;
                    if (client.playerMob.isInCombat()) {
                        client.getServerClient().sendChatMessage((GameMessage)new LocalMessage("message", "noupdatesincombat"));
                        return;
                    }
                    ServerClient serverClient = client.getServerClient();
                    int multiClass = RPGSettings.multiClass();
                    if (multiClass != 0 && Arrays.stream(classLevels).filter(level -> level > 0).count() > (long)multiClass) {
                        System.out.println("updateClasses: You cannot have more than " + multiClass + " different classes");
                        return;
                    }
                    if (Arrays.stream(classLevels).anyMatch(pClass -> pClass >= 1000 || pClass < 0)) {
                        System.out.println("updateClasses: At least one wrong assigned class level");
                        return;
                    }
                    int total = Arrays.stream(classLevels).sum();
                    if (total > (playerData = PlayerDataList.getPlayerData(serverClient.playerMob)).totalClassPoints()) {
                        System.out.println("updateClasses: Not enough Class Points");
                        return;
                    }
                    int reduced = 0;
                    for (int i = 0; i < classLevels.length; ++i) {
                        int difference = playerData.getClassLevel(i) - classLevels[i];
                        if (difference <= 0) continue;
                        reduced += difference;
                    }
                    if (reduced > 0) {
                        if (playerData.getResets() >= reduced * 2) {
                            playerData.modResetsSendPacket(serverClient, -reduced * 2);
                        } else {
                            System.out.println("updateClasses: Not enough Reset Points");
                            return;
                        }
                    }
                    playerData.setClassLevels(classLevels);
                    for (int classID = 0; classID < classLevels.length; ++classID) {
                        int maxEffectiveLevel;
                        int skillID;
                        boolean someChange = false;
                        int classLevel = classLevels[classID];
                        PlayerClassData classData = playerData.getClassesData()[classID];
                        for (skillID = 0; skillID < classData.getActiveSkillLevels().length; ++skillID) {
                            ActiveSkill activeSkill;
                            int activeSkillLevel = classData.getActiveSkillLevels()[skillID];
                            if (activeSkillLevel <= 0 || (maxEffectiveLevel = classData.getEffectiveSkillMaxLevel(activeSkill = classData.playerClass.activeSkillsList.get(skillID), classLevel, classData.getActiveSkillLevels())) >= activeSkillLevel) continue;
                            classData.setActiveSkillLevel(skillID, maxEffectiveLevel);
                            this.checkActiveSkillRequirements(classData, activeSkill, maxEffectiveLevel);
                            someChange = true;
                        }
                        for (skillID = 0; skillID < classData.getPassiveLevels().length; ++skillID) {
                            Passive passive;
                            int passiveLevel = classData.getPassiveLevels()[skillID];
                            if (passiveLevel <= 0 || (maxEffectiveLevel = classData.getEffectiveSkillMaxLevel(passive = classData.playerClass.passivesList.get(skillID), classLevel, classData.getPassiveLevels())) >= passiveLevel) continue;
                            classData.setPassiveLevel(skillID, maxEffectiveLevel);
                            someChange = true;
                        }
                        if (!someChange) continue;
                        serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientClassDataPacket(classData));
                    }
                    serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientClassesPacket(playerData));
                    playerData.updateAllBuffs(serverClient.playerMob);
                    boolean someEquippedUpdate = false;
                    for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
                        if (equippedActiveSkill.isEmpty()) continue;
                        PlayerClassData playerClassData = playerData.getClassesData()[equippedActiveSkill.getPlayerClass().id];
                        if (equippedActiveSkill.isInCooldown(client.playerMob.getTime()) || playerClassData.getLevel(true) >= 1 && playerClassData.getActiveSkillLevels()[equippedActiveSkill.getActiveSkill().id] >= 1) continue;
                        equippedActiveSkill.empty();
                        someEquippedUpdate = true;
                    }
                    if (someEquippedUpdate) {
                        serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientEquippedActiveSkillsPacket(playerData));
                    }
                }
            }

            private void checkActiveSkillRequirements(PlayerClassData classData, ActiveSkill activeSkill, int newActiveSkillLevel) {
                block0: for (int thisActiveSkillID = 0; thisActiveSkillID < classData.getActiveSkillLevels().length; ++thisActiveSkillID) {
                    int thisActiveSkillLevel = classData.getActiveSkillLevels()[thisActiveSkillID];
                    if (thisActiveSkillLevel <= 0) continue;
                    ActiveSkill thisActiveSkill = classData.playerClass.activeSkillsList.get(thisActiveSkillID);
                    if (thisActiveSkill.requiredSkills.isEmpty()) continue;
                    for (ActiveSkill.RequiredSkill requiredSkill : thisActiveSkill.requiredSkills) {
                        if (requiredSkill.activeSkill.id != activeSkill.id) continue;
                        if (requiredSkill.activeSkillLevel <= newActiveSkillLevel) continue block0;
                        classData.setActiveSkillLevel(thisActiveSkillID, 0);
                        this.checkActiveSkillRequirements(classData, thisActiveSkill, 0);
                        continue block0;
                    }
                }
            }

            @Override
            public int arrayLength() {
                return PlayerClass.classesList.size();
            }
        });
        this.updateClass = (ClassUpdateCustomAction)this.registerAction(new ClassUpdateCustomAction(){

            @Override
            protected void run(int classID, int[] passiveLevels, int[] activeSkillLevels) {
                if (client.isServer()) {
                    if (client.playerMob.isInCombat() && !client.playerMob.buffManager.hasBuff((Buff)RPGBuffs.PASSIVES.OVER_LEVEL)) {
                        client.playerMob.getServerClient().sendChatMessage((GameMessage)new LocalMessage("message", "noupdatesincombat"));
                        System.out.println("updateClass: No updates in combat");
                        return;
                    }
                    ServerClient serverClient = client.getServerClient();
                    PlayerData playerData = PlayerDataList.getPlayerData(serverClient.playerMob);
                    PlayerClassData classData = playerData.getClassesData()[classID];
                    String familyInvalid = null;
                    String levelsInvalid = null;
                    HashSet<String> passiveFamilies = new HashSet<String>();
                    for (int i = 0; i < passiveLevels.length; ++i) {
                        Passive passive = classData.playerClass.passivesList.get(i);
                        int assignedLevel = passiveLevels[i];
                        if (assignedLevel > 0 && passive.family != null) {
                            if (passiveFamilies.contains(passive.family)) {
                                familyInvalid = passive.family + " (" + passive.stringID + ")";
                                break;
                            }
                            passiveFamilies.add(passive.family);
                        }
                        int effectiveMax = classData.getEffectiveSkillMaxLevel(passive, classData.getLevel(true), passiveLevels);
                        if (assignedLevel >= 0 && assignedLevel <= effectiveMax) continue;
                        levelsInvalid = passive.stringID;
                        break;
                    }
                    if (familyInvalid != null) {
                        System.out.println("updateClass: Repeated Passive Family: " + familyInvalid);
                        return;
                    }
                    if (levelsInvalid != null) {
                        System.out.println("updateClass: Wrong assigned Passive Level: " + levelsInvalid);
                        return;
                    }
                    String requirementsInvalid = null;
                    for (int i = 0; i < activeSkillLevels.length; ++i) {
                        boolean hasRequired;
                        ActiveSkill skill = classData.playerClass.activeSkillsList.get(i);
                        int assignedLevel = activeSkillLevels[i];
                        int effectiveMax = classData.getEffectiveSkillMaxLevel(classData.playerClass.activeSkillsList.get(i), classData.getLevel(true), activeSkillLevels);
                        if (assignedLevel < 0 || assignedLevel > effectiveMax) {
                            levelsInvalid = skill.stringID;
                            break;
                        }
                        if (assignedLevel <= 0 || (hasRequired = ClassEntry.hasRequired(skill, activeSkillLevels))) continue;
                        requirementsInvalid = skill.stringID;
                        break;
                    }
                    if (requirementsInvalid != null) {
                        System.out.println("updateClass: Not accomplished active skill requirements: " + requirementsInvalid);
                        return;
                    }
                    if (levelsInvalid != null) {
                        System.out.println("updateClass: Wrong assigned Active Skill Level: " + levelsInvalid);
                        return;
                    }
                    int totalPassive = Arrays.stream(passiveLevels).sum();
                    if (totalPassive <= classData.totalPassivePoints(true)) {
                        int totalActiveSkill = Arrays.stream(activeSkillLevels).sum();
                        if (totalActiveSkill <= classData.totalActiveSkillPoints(true)) {
                            classData.setPassiveLevels(passiveLevels);
                            classData.setActiveSkillLevels(activeSkillLevels);
                            serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientClassDataPacket(classData));
                            playerData.updateAllBuffs(serverClient.playerMob);
                            boolean someEquippedUpdate = false;
                            for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
                                if (equippedActiveSkill.isEmpty() || equippedActiveSkill.isInCooldown(client.playerMob.getTime()) || !equippedActiveSkill.sameClass(classData) || classData.getActiveSkillLevels()[equippedActiveSkill.getActiveSkill().id] >= 1) continue;
                                equippedActiveSkill.empty();
                                someEquippedUpdate = true;
                            }
                            if (someEquippedUpdate) {
                                serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientEquippedActiveSkillsPacket(playerData));
                            }
                        } else {
                            System.out.println("updateClass: Not enough Active Skill Points");
                        }
                    } else {
                        System.out.println("updateClass: Not enough Passive Points");
                    }
                }
            }
        });
        this.updateEquippedActiveSkills = (EquippedActiveSkillsCustomAction)this.registerAction(new EquippedActiveSkillsCustomAction(){

            @Override
            protected void run(EquippedActiveSkill[] equippedActiveSkills) {
                if (client.isServer()) {
                    ServerClient serverClient = client.getServerClient();
                    if (client.playerMob.isInCombat()) {
                        serverClient.sendChatMessage((GameMessage)new LocalMessage("message", "noupdatesincombat"));
                        System.out.println("updateEquippedActiveSkills: No updates in combat");
                        return;
                    }
                    PlayerMob player = client.playerMob;
                    PlayerData playerData = PlayerDataList.getPlayerData(player);
                    boolean allCorrect = true;
                    for (EquippedActiveSkill equippedActiveSkill : equippedActiveSkills) {
                        PlayerClassData playerClassData;
                        if (equippedActiveSkill == null || equippedActiveSkill.getPlayerClass() == null || equippedActiveSkill.getActiveSkill() == null || (playerClassData = playerData.getClassesData()[equippedActiveSkill.getPlayerClass().id]).getLevel(true) >= 1 && playerClassData.getActiveSkillLevels()[equippedActiveSkill.getActiveSkill().id] >= 1) continue;
                        allCorrect = false;
                        break;
                    }
                    if (!allCorrect) {
                        System.out.println("updateEquippedActiveSkills: Some Active Skill is not unlocked");
                        return;
                    }
                    boolean duplicated = false;
                    for (int i = 0; i < PlayerData.EQUIPPED_SKILLS_MAX; ++i) {
                        for (int j = 0; j < PlayerData.EQUIPPED_SKILLS_MAX; ++j) {
                            if (i == j || !equippedActiveSkills[i].isSameSkill(equippedActiveSkills[j])) continue;
                            duplicated = true;
                        }
                    }
                    if (duplicated) {
                        System.out.println("updateEquippedActiveSkills: Can't equip duplicated Active Skills");
                        return;
                    }
                    boolean changedInCooldown = false;
                    for (int i = 0; i < PlayerData.EQUIPPED_SKILLS_MAX; ++i) {
                        EquippedActiveSkill equippedActiveSkill;
                        equippedActiveSkill = equippedActiveSkills[i];
                        EquippedActiveSkill serverEquippedActiveSkill = playerData.equippedActiveSkills[i];
                        if (equippedActiveSkill.isEmpty() || serverEquippedActiveSkill.isEmpty()) {
                            equippedActiveSkill.restartCooldown();
                        }
                        if (serverEquippedActiveSkill.isEmpty()) continue;
                        if (equippedActiveSkill.isSameSkill(serverEquippedActiveSkill)) {
                            equippedActiveSkill.setCooldown(serverEquippedActiveSkill);
                            continue;
                        }
                        if (!serverEquippedActiveSkill.canChange(player.getTime())) {
                            changedInCooldown = true;
                            continue;
                        }
                        equippedActiveSkill.restartCooldown();
                    }
                    if (changedInCooldown) {
                        System.out.println("updateEquippedActiveSkills: Can't change Active Skills in cooldown or in use");
                        return;
                    }
                    boolean sameFamily = false;
                    block4: for (int i = 0; i < equippedActiveSkills.length; ++i) {
                        EquippedActiveSkill equippedActiveSkill = equippedActiveSkills[i];
                        if (equippedActiveSkill == null || equippedActiveSkill.isEmpty()) continue;
                        for (int j = 0; j < equippedActiveSkills.length; ++j) {
                            if (i == j || !equippedActiveSkills[j].isNotSameSkillButSameFamily(equippedActiveSkill)) continue;
                            sameFamily = true;
                            continue block4;
                        }
                    }
                    if (sameFamily) {
                        System.out.println("updateEquippedActiveSkills: Can't use different Active Skills in same family");
                        return;
                    }
                    playerData.equippedActiveSkills = equippedActiveSkills;
                    serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientEquippedActiveSkillsPacket(playerData));
                }
            }
        });
    }
}

