/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.forms.customiteminventory;

import java.awt.Rectangle;
import java.util.function.Supplier;
import necesse.engine.Settings;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.client.Client;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameColor;
import necesse.gfx.fairType.TypeParsers;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabelEdit;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.forms.presets.containerComponent.ContainerForm;
import necesse.gfx.forms.presets.containerComponent.object.OEInventoryContainerForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.gfx.ui.GameInterfaceStyle;
import necesse.inventory.InventoryItem;
import necesse.inventory.container.item.ItemInventoryContainer;
import necesse.inventory.item.miscItem.InternalInventoryItemInterface;
import rpgclasses.RPGResources;

public class CustomItemInventoryForm<T extends ItemInventoryContainer>
extends ContainerForm<T> {
    public static int shownColumns = 4;
    public FormLabelEdit label;
    public FormContentIconButton edit;
    public LocalMessage renameTip;
    public FormContainerSlot[] slots;
    public FormContentBox slotsForm;
    public FormContentIconButton addColumnButton;
    public FormContentIconButton removeColumnButton;

    public CustomItemInventoryForm(Client client, T container) {
        super(client, 418, 100, container);
        FormContentIconButton sortButton;
        FormContentIconButton lootAllButton;
        InventoryItem inventoryItem = container.getInventoryItem();
        InternalInventoryItemInterface item = ((ItemInventoryContainer)container).inventoryItem;
        FontOptions labelOptions = new FontOptions(20);
        this.label = (FormLabelEdit)this.addComponent((FormComponent)new FormLabelEdit("", labelOptions, Settings.UI.activeTextColor, 5, 5, this.getWidth() - 10, 50), -1000);
        this.label.onMouseChangedTyping(e -> this.runEditUpdate());
        this.label.onSubmit(e -> this.runEditUpdate());
        this.label.allowCaretSetTyping = item.canChangePouchName();
        this.label.allowItemAppend = true;
        this.label.setParsers(OEInventoryContainerForm.getParsers((FontOptions)labelOptions));
        this.label.setText(inventoryItem == null ? "NULL" : inventoryItem.getItemDisplayName());
        FormFlow iconFlow = new FormFlow(this.getWidth() - 4);
        this.renameTip = new LocalMessage("ui", "renamebutton");
        if (item.canChangePouchName()) {
            this.edit = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.container_rename, new GameMessage[]{this.renameTip}));
            this.edit.onClicked(e -> {
                this.label.setTyping(!this.label.isTyping());
                this.runEditUpdate();
            });
        }
        if (item.canQuickStackInventory()) {
            lootAllButton = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.inventory_quickstack_out, new GameMessage[0]){

                public GameTooltips getTooltips(PlayerMob perspective) {
                    GameWindow window = WindowManager.getWindow();
                    StringTooltips tooltips = new StringTooltips(Localization.translate((String)"ui", (String)"inventoryquickstack"));
                    if (!window.isKeyDown(340) && !window.isKeyDown(344)) {
                        tooltips.add(Localization.translate((String)"ui", (String)"shiftmoreinfo"), GameColor.LIGHT_GRAY);
                    } else {
                        tooltips.add(Localization.translate((String)"ui", (String)"inventoryquickstackinfo", (String)"key", (String)(TypeParsers.getInputParseString((Control)Control.INV_LOCK) + "+" + TypeParsers.getInputParseString((int)-100))), GameColor.LIGHT_GRAY, 400);
                    }
                    return tooltips;
                }
            });
            lootAllButton.onClicked(e -> container.quickStackButton.runAndSend());
            lootAllButton.setCooldown(500);
            sortButton = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.container_loot_all, new GameMessage[0]){

                public GameTooltips getTooltips(PlayerMob perspective) {
                    GameWindow window = WindowManager.getWindow();
                    StringTooltips tooltips = new StringTooltips(Localization.translate((String)"ui", (String)"inventorytransferall"));
                    if (!window.isKeyDown(340) && !window.isKeyDown(344)) {
                        tooltips.add(Localization.translate((String)"ui", (String)"shiftmoreinfo"), GameColor.LIGHT_GRAY);
                    } else {
                        tooltips.add(Localization.translate((String)"ui", (String)"inventorytransferallinfo", (String)"key", (String)(TypeParsers.getInputParseString((Control)Control.INV_LOCK) + "+" + TypeParsers.getInputParseString((int)-100))), GameColor.LIGHT_GRAY, 400);
                    }
                    return tooltips;
                }
            });
            sortButton.mirrorY();
            sortButton.onClicked(e -> container.transferAll.runAndSend());
            sortButton.setCooldown(500);
        }
        if (item.canRestockInventory()) {
            lootAllButton = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.inventory_quickstack_in, new GameMessage[]{new LocalMessage("ui", "inventoryrestock")}));
            lootAllButton.onClicked(e -> container.restockButton.runAndSend());
            lootAllButton.setCooldown(500);
        }
        lootAllButton = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.container_loot_all, new GameMessage[]{new LocalMessage("ui", "inventorylootall")}));
        lootAllButton.onClicked(e -> container.lootButton.runAndSend());
        lootAllButton.setCooldown(500);
        if (item.canSortInventory()) {
            sortButton = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.inventory_sort, new GameMessage[]{new LocalMessage("ui", "inventorysort")}));
            sortButton.onClicked(e -> container.sortButton.runAndSend());
            sortButton.setCooldown(500);
        }
        if (item.canDisablePickup()) {
            final Supplier<Boolean> isDisabled = () -> {
                InventoryItem invItem = container.getInventoryItem();
                return invItem != null && container.inventoryItem.isPickupDisabled(invItem);
            };
            FormContentIconButton disablePickupButton = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, null, new GameMessage[0], (ItemInventoryContainer)container){
                final /* synthetic */ ItemInventoryContainer val$container;
                {
                    this.val$container = itemInventoryContainer;
                    super(arg0, arg1, arg2, arg3, arg4, arg5);
                }

                protected void drawContent(int x, int y, int width, int height) {
                    this.setIcon((Boolean)isDisabled.get() != false ? Settings.UI.button_escaped_20 : Settings.UI.button_checked_20);
                    super.drawContent(x, y, width, height);
                }

                public GameTooltips getTooltips(PlayerMob perspective) {
                    return this.val$container.inventoryItem.getPickupToggleTooltip(((Boolean)isDisabled.get()).booleanValue());
                }
            });
            disablePickupButton.onClicked(e -> container.setPickupDisabled.runAndSend((Boolean)isDisabled.get() == false));
        }
        this.label.setWidth(iconFlow.next() - 10);
        int style = GameInterfaceStyle.styles.indexOf(Settings.UI);
        FormFlow iconFlow2 = new FormFlow(this.getWidth() - 4);
        this.addColumnButton = (FormContentIconButton)((FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow2.next(-26) - 24, 0, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.add_icon[style], new GameMessage[]{new LocalMessage("ui", "addcolumn")}))).onClicked(e -> {
            if (shownColumns < (int)Math.ceil((float)this.slots.length / 10.0f)) {
                ++shownColumns;
                this.runEditColumns();
                this.setY(this.getY() - 40);
            }
        });
        this.removeColumnButton = (FormContentIconButton)((FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(iconFlow2.next(-26) - 24, 0, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)RPGResources.UI_TEXTURES.remove_icon[style], new GameMessage[]{new LocalMessage("ui", "removecolumn")}))).onClicked(e -> {
            if (shownColumns > 1) {
                --shownColumns;
                this.runEditColumns();
                this.setY(this.getY() + 40);
            }
        });
        this.runEditColumns();
    }

    protected void runEditUpdate() {
        InternalInventoryItemInterface item = ((ItemInventoryContainer)this.container).inventoryItem;
        if (item.canChangePouchName()) {
            if (this.label.isTyping()) {
                this.edit.setIcon(Settings.UI.container_rename_save);
                this.renameTip = new LocalMessage("ui", "savebutton");
            } else {
                InventoryItem inventoryItem = ((ItemInventoryContainer)this.container).getInventoryItem();
                if (inventoryItem == null) {
                    return;
                }
                if (!this.label.getText().equals(item.getPouchName(inventoryItem))) {
                    item.setPouchName(inventoryItem, this.label.getText());
                    ((ItemInventoryContainer)this.container).renameButton.runAndSend(this.label.getText());
                }
                this.edit.setIcon(Settings.UI.container_rename);
                this.renameTip = new LocalMessage("ui", "renamebutton");
                this.label.setText(inventoryItem.getItemDisplayName());
            }
            this.edit.setTooltips(new GameMessage[]{this.renameTip});
        }
    }

    protected void runEditColumns() {
        int slotsBoxY = 34;
        int slotsBoxHeight = 8 + 40 * shownColumns;
        if (this.slotsForm == null) {
            this.slotsForm = (FormContentBox)this.addComponent((FormComponent)new FormContentBox(0, slotsBoxY, this.getWidth(), slotsBoxHeight));
            FormFlow flow = new FormFlow(2);
            this.addSlots(flow);
            flow.next(4);
            this.slotsForm.setContentBox(new Rectangle(0, 0, this.getWidth(), flow.next()));
        } else {
            this.slotsForm.setHeight(slotsBoxHeight);
        }
        int formHeight = slotsBoxY + slotsBoxHeight + 2 + 28;
        this.setHeight(formHeight);
        this.addColumnButton.setY(formHeight - 28);
        this.removeColumnButton.setY(formHeight - 28);
    }

    protected void addSlots(FormFlow flow) {
        this.slots = new FormContainerSlot[((ItemInventoryContainer)this.container).INVENTORY_END - ((ItemInventoryContainer)this.container).INVENTORY_START + 1];
        int currentY = flow.next();
        for (int i = 0; i < this.slots.length; ++i) {
            int slotIndex = i + ((ItemInventoryContainer)this.container).INVENTORY_START;
            int x = i % 10;
            if (x == 0) {
                currentY = flow.next(40);
            }
            this.slots[i] = (FormContainerSlot)this.slotsForm.addComponent((FormComponent)new FormContainerSlot(this.client, this.container, slotIndex, 4 + x * 40, currentY));
        }
    }
}

