/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.objectEntity.interfaces.OEInventory;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.gameObject.CandlePedestalObject;
import necesse.level.gameObject.ColumnObject;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.RockObject;
import necesse.level.gameObject.StreetlampObject;
import necesse.level.gameObject.TrainingDummyObject;
import necesse.level.gameObject.TreeObject;
import necesse.level.gameObject.WallObject;
import necesse.level.gameObject.furniture.RoomFurniture;
import necesse.level.maps.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rpgclasses.content.player.Attribute;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Passives.BasicPassive;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.packets.ShowModExpPacket;
import rpgclasses.packets.UpdateClientExpPacket;
import rpgclasses.packets.UpdateClientResetsPacket;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.settings.RPGSettings;

public class PlayerData {
    public static int EQUIPPED_SKILLS_MAX = 12;
    public static int MAX_EXP = 2000000000;
    public static String prefixDataName = "rpgmod_";
    public static String expDataName = prefixDataName + "exp";
    public static String resetsDataName = prefixDataName + "resets";
    public static String attributesDataName = prefixDataName + "attributes";
    public static String masteryDataName = prefixDataName + "mastery";
    public static String classesDataName = prefixDataName + "classes";
    public static String equippedActiveSkillsDataName = prefixDataName + "equippedactives";
    public static String lastDeathDataName = prefixDataName + "lastdeath";
    public static String grabbedObjectDataName = prefixDataName + "grabbedobject";
    public final String playerName;
    public final long worldUniqueID;
    private int exp = 0;
    private int resets = 0;
    private int[] attributePointsUsed = new int[Attribute.attributesList.size()];
    public List<Integer> masterySkills = new ArrayList<Integer>();
    private int[] classLevels = new int[PlayerClass.classesList.size()];
    private PlayerClassData[] classesData = new PlayerClassData[PlayerClass.classesList.size()];
    public EquippedActiveSkill[] equippedActiveSkills = new EquippedActiveSkill[EQUIPPED_SKILLS_MAX];
    public long lastDeath;
    public GameObject grabbedObject;

    public PlayerData(String playerName, long worldUniqueID) {
        int i;
        this.playerName = playerName;
        this.worldUniqueID = worldUniqueID;
        for (i = 0; i < this.classesData.length; ++i) {
            this.classesData[i] = new PlayerClassData(i, playerName);
        }
        for (i = 0; i < EQUIPPED_SKILLS_MAX; ++i) {
            this.equippedActiveSkills[i] = new EquippedActiveSkill();
        }
    }

    public void loadData(PlayerMob player, @NotNull LoadData loadData) {
        this.loadData(loadData.getInt(expDataName, 0, false), loadData.getInt(resetsDataName, 0, false));
        this.loadDataAttributes(loadData);
        this.loadDataMastery(loadData);
        this.loadDataClasses(loadData);
        this.loadDataClassesData(this.classLevels, loadData);
        this.loadDataEquippedActiveSkills(player, loadData);
        this.loadDataMisc(loadData);
    }

    public void loadData(int exp, int resets) {
        this.loadDataExp(exp);
        this.loadDataResets(resets);
    }

    public void loadDataExp(int exp) {
        this.exp = exp;
    }

    public void loadDataResets(int resets) {
        this.resets = resets;
    }

    public void loadDataAttributes(LoadData loadData) {
        for (Attribute attribute : Attribute.attributesList) {
            this.attributePointsUsed[attribute.id] = loadData.getInt(attributesDataName + "_" + attribute.stringID, 0, false);
        }
    }

    public void loadDataMastery(LoadData loadData) {
        String[] strings;
        this.masterySkills.clear();
        for (String string : strings = loadData.getStringArray(masteryDataName, new String[0], false)) {
            Mastery mastery = Mastery.masterySkills.get(string);
            if (mastery == null) continue;
            this.masterySkills.add(mastery.id);
        }
    }

    public void loadDataClasses(LoadData loadData) {
        for (PlayerClass playerClass : PlayerClass.classesList) {
            this.classLevels[playerClass.id] = loadData.getInt(classesDataName + "_" + playerClass.stringID, 0, false);
        }
    }

    public void loadDataClassesData(@NotNull int[] classLevels, LoadData loadData) {
        boolean update = classLevels.length == PlayerClass.classesList.size();
        this.classesData = new PlayerClassData[classLevels.length];
        for (int i = 0; i < this.classesData.length; ++i) {
            PlayerClassData classData = new PlayerClassData(i, this.playerName);
            if (update) {
                classData.loadData(loadData);
            }
            this.classesData[i] = classData;
        }
    }

    public void loadDataEquippedActiveSkills(PlayerMob player, LoadData loadData) {
        this.equippedActiveSkills = new EquippedActiveSkill[EQUIPPED_SKILLS_MAX];
        for (int i = 0; i < EQUIPPED_SKILLS_MAX; ++i) {
            this.equippedActiveSkills[i] = EquippedActiveSkill.loadData(player, loadData, i);
        }
    }

    public void loadDataMisc(LoadData loadData) {
        this.lastDeath = loadData.getLong(lastDeathDataName, 0L, false);
        int grabbedObjectID = loadData.getInt(grabbedObjectDataName, -1, false);
        this.grabbedObject = grabbedObjectID == -1 ? null : ObjectRegistry.getObject((int)grabbedObjectID);
    }

    public void saveData(@NotNull SaveData saveData) {
        saveData.addInt(expDataName, this.exp);
        saveData.addInt(resetsDataName, this.resets);
        for (Attribute attribute : Attribute.attributesList) {
            saveData.addInt(attributesDataName + "_" + attribute.stringID, this.attributePointsUsed[attribute.id]);
        }
        saveData.addStringArray(masteryDataName, (String[])this.masterySkills.stream().map(index -> Mastery.masterySkillsList.get((int)index.intValue()).stringID).toArray(String[]::new));
        for (PlayerClass playerClass : PlayerClass.classesList) {
            saveData.addInt(classesDataName + "_" + playerClass.stringID, this.classLevels[playerClass.id]);
        }
        for (Iterator<Object> iterator : this.classesData) {
            ((PlayerClassData)((Object)iterator)).saveData(saveData);
        }
        for (int i = 0; i < EQUIPPED_SKILLS_MAX; ++i) {
            if (this.equippedActiveSkills[i] == null) {
                this.equippedActiveSkills[i] = new EquippedActiveSkill();
            }
            this.equippedActiveSkills[i].saveData(saveData, i);
        }
        saveData.addLong(lastDeathDataName, this.lastDeath);
        saveData.addInt(grabbedObjectDataName, this.grabbedObject == null ? -1 : this.grabbedObject.getID());
    }

    public void setAttributes(@NotNull int[] attributePoints) {
        this.attributePointsUsed = attributePoints;
    }

    public void setClassLevels(@NotNull int[] classLevels) {
        this.classLevels = classLevels.length != PlayerClass.classesList.size() ? new int[PlayerClass.classesList.size()] : classLevels;
    }

    public void setMasterySkills(List<Integer> masterySkills) {
        this.masterySkills.clear();
        this.masterySkills.addAll(masterySkills);
    }

    public int getBaseExp() {
        return this.exp;
    }

    public int getExp() {
        int maxExp = MAX_EXP - RPGSettings.startingExperience();
        if (this.exp > maxExp) {
            return MAX_EXP;
        }
        return this.exp + RPGSettings.startingExperience();
    }

    public int[] getAttributePointsUsed() {
        return this.attributePointsUsed;
    }

    public float getAttribute(int id, @NotNull PlayerMob player) {
        return this.getAttribute(Attribute.attributesList.get(id), player);
    }

    public float getAttribute(Attribute attribute, @NotNull PlayerMob player) {
        return PlayerData.pointsConversion(this.getAttributePoints(attribute.id)) + (float)((Integer)player.buffManager.getModifier(attribute.ownModifier)).intValue();
    }

    public float getEndurance(@NotNull PlayerMob player) {
        return this.getAttribute(0, player);
    }

    public float getSpeed(@NotNull PlayerMob player) {
        return this.getAttribute(1, player);
    }

    public float getStrength(@NotNull PlayerMob player) {
        return this.getAttribute(2, player);
    }

    public float getIntelligence(@NotNull PlayerMob player) {
        return this.getAttribute(3, player);
    }

    public float getGrace(@NotNull PlayerMob player) {
        return this.getAttribute(4, player);
    }

    public static float pointsConversion(int amount) {
        if (amount <= 10) {
            return amount;
        }
        float total = 0.0f;
        float valor = 1.0f;
        for (int i = 1; i <= amount; ++i) {
            if (i > 10) {
                valor *= 0.99f;
            }
            total += valor;
        }
        return total;
    }

    public void setAttributePointsUsed(int[] attributePointsUsed) {
        this.attributePointsUsed = attributePointsUsed;
    }

    public int getAttributePoints(int id) {
        return id < 0 || id >= this.attributePointsUsed.length ? 0 : this.attributePointsUsed[id];
    }

    public boolean hasMasterySkill(Mastery mastery) {
        return this.masterySkills.contains(mastery.id);
    }

    public boolean hasMasterySkill(int id) {
        return this.masterySkills.contains(id);
    }

    public int[] getClassLevels() {
        int[] trueClassLevels = new int[this.classLevels.length];
        for (int i = 0; i < this.classLevels.length; ++i) {
            trueClassLevels[i] = this.getClassLevel(i);
        }
        return trueClassLevels;
    }

    public int getClassLevel(int id) {
        return id < 0 || id >= this.classLevels.length ? 0 : (PlayerClass.classesList.get(id).isEnabled() ? this.classLevels[id] : 0);
    }

    public PlayerClassData[] getClassesData() {
        return this.classesData;
    }

    public int getResets() {
        return this.resets;
    }

    public void modResetsSendPacket(@NotNull ServerClient serverClient, int resets) {
        this.resets += resets;
        serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientResetsPacket(PlayerDataList.getPlayerData(serverClient.playerMob)));
    }

    public int getExpActual() {
        return this.getExp() - this.getExpRequiredForLevel(this.getLevel());
    }

    public int getExpNext() {
        return this.getExpRequiredForLevel(this.getLevel() + 1) - this.getExpRequiredForLevel(this.getLevel());
    }

    public int getExpRequiredForLevel(int level) {
        return level * RPGSettings.firstExperienceReq() + RPGSettings.experienceReqInc() * (level * (level - 1)) / 2 + RPGSettings.squareExperienceReqInc() * (level * (level - 1) * (2 * level - 1)) / 6 + RPGSettings.cubeExperienceReqInc() * (int)Math.pow((double)(level * (level - 1)) / 2.0, 2.0);
    }

    public int getLevel() {
        int level = 0;
        while (this.getExpRequiredForLevel(level + 1) <= this.getExp()) {
            ++level;
        }
        return level;
    }

    public void updateAllBuffs(PlayerMob player) {
        this.updateModifiersBuff(player);
        boolean isServer = player.isServer();
        if (!player.buffManager.hasBuff((Buff)RPGBuffs.PASSIVES.HOLY_DAMAGE)) {
            player.buffManager.addBuff(new ActiveBuff((Buff)RPGBuffs.PASSIVES.HOLY_DAMAGE, (Mob)player, 1000, null), isServer);
        }
        for (int i = 0; i < Mastery.masterySkillsList.size(); ++i) {
            PlayerClassData[] mastery = Mastery.masterySkillsList.get(i);
            if (this.hasMasterySkill(i)) {
                mastery.giveMasteryBuff((Mob)player);
                continue;
            }
            mastery.removePassiveBuffs(player);
        }
        boolean someOverlevel = Arrays.stream(this.getClassLevels()).sum() > this.totalClassPoints() || Arrays.stream(this.getAttributePointsUsed()).sum() > this.totalAttributePoints() || this.masterySkills.size() > this.totalMasteryPoints();
        for (PlayerClassData classesDatum : this.classesData) {
            boolean validClass;
            PlayerClass playerClass = classesDatum.playerClass;
            int classLevel = this.getClassLevel(playerClass.id);
            boolean bl = validClass = classLevel > 0;
            if (validClass && !someOverlevel && (classesDatum.usedPassivePoints() > playerClass.totalPassivePoints(classLevel) || classesDatum.usedActiveSkillPoints() > playerClass.totalActiveSkillPoints(classLevel))) {
                someOverlevel = true;
            }
            for (int i = 0; i < classesDatum.getPassiveLevels().length; ++i) {
                Passive passive = playerClass.passivesList.get(i);
                if (passive instanceof BasicPassive) continue;
                if (validClass) {
                    int level = classesDatum.getPassiveLevels()[i];
                    if (level > 0) {
                        passive.givePassiveBuff(player, this, level);
                        continue;
                    }
                    passive.removePassiveBuffs(player);
                    continue;
                }
                passive.removePassiveBuffs(player);
            }
        }
        if (isServer) {
            boolean hasOverlevelBuff = player.buffManager.hasBuff((Buff)RPGBuffs.PASSIVES.OVER_LEVEL);
            if (someOverlevel && !hasOverlevelBuff) {
                player.buffManager.addBuff(new ActiveBuff((Buff)RPGBuffs.PASSIVES.OVER_LEVEL, (Mob)player, 1000, null), true);
            } else if (!someOverlevel && hasOverlevelBuff) {
                player.buffManager.removeBuff((Buff)RPGBuffs.PASSIVES.OVER_LEVEL, true);
            }
        }
    }

    public void updateModifiersBuff(@NotNull PlayerMob player) {
        player.buffManager.addBuff(new ActiveBuff((Buff)RPGBuffs.PASSIVES.MODIFIERS, (Mob)player, 1000, null), player.isServer(), true);
    }

    public void modExpSendPacket(ServerClient serverClient, int amount) {
        boolean levelUp;
        if (amount == 0) {
            return;
        }
        int oldLevel = this.getLevel();
        if (amount > 0) {
            if (this.exp > MAX_EXP - amount) {
                amount = MAX_EXP - this.exp;
                if (amount <= 0) {
                    return;
                }
                this.exp = MAX_EXP;
            } else {
                this.exp += amount;
            }
        } else if (this.exp + amount < 0) {
            amount = -this.exp;
            if (amount == 0) {
                return;
            }
            this.exp = 0;
        } else {
            this.exp += amount;
        }
        int newLevel = this.getLevel();
        boolean bl = levelUp = newLevel > oldLevel;
        if (levelUp) {
            int levelsGained = newLevel - oldLevel;
            this.modResetsSendPacket(serverClient, levelsGained * 5);
            for (int level = oldLevel + 1; level <= newLevel; ++level) {
                serverClient.sendChatMessage((GameMessage)new LocalMessage("message", "newlevel", new Object[]{"level", level}));
            }
        }
        serverClient.getServer().network.sendToClientsAtEntireLevel((Packet)new ShowModExpPacket(serverClient.playerMob.getX(), serverClient.playerMob.getY(), amount, levelUp), serverClient.getLevel());
        serverClient.getServer().network.sendToAllClients((Packet)new UpdateClientExpPacket(PlayerDataList.getPlayerData(serverClient.playerMob)));
    }

    public int totalAttributePoints() {
        return this.getLevel() * 2;
    }

    public int totalMasteryPoints() {
        return this.getLevel() / 20;
    }

    public int totalClassPoints() {
        return this.getLevel();
    }

    /*
     * WARNING - void declaration
     */
    public void setupPacket(@NotNull PacketWriter writer) {
        writer.putNextString(this.playerName);
        writer.putNextLong(this.worldUniqueID);
        writer.putNextInt(this.exp);
        writer.putNextInt(this.resets);
        writer.putNextInts(this.attributePointsUsed);
        writer.putNextInt(this.masterySkills.size());
        writer.putNextInts(this.masterySkills.stream().mapToInt(Integer::intValue).toArray());
        writer.putNextInts(this.classLevels);
        for (PlayerClassData playerClassData : this.classesData) {
            playerClassData.setupPacket(writer);
        }
        for (EquippedActiveSkill equippedActiveSkill : this.equippedActiveSkills) {
            void var5_9;
            if (equippedActiveSkill == null) {
                EquippedActiveSkill equippedActiveSkill2 = new EquippedActiveSkill();
            }
            var5_9.setupPacket(writer);
        }
        writer.putNextLong(this.lastDeath);
        writer.putNextInt(this.grabbedObject == null ? -1 : this.grabbedObject.getID());
    }

    @NotNull
    public static PlayerData applyPacket(@NotNull PacketReader reader) {
        int i;
        int[] masteryArray;
        PlayerData playerData = new PlayerData(reader.getNextString(), reader.getNextLong());
        playerData.exp = reader.getNextInt();
        playerData.resets = reader.getNextInt();
        playerData.attributePointsUsed = reader.getNextInts(Attribute.attributes.size());
        int masterySize = reader.getNextInt();
        for (int i2 : masteryArray = reader.getNextInts(masterySize)) {
            playerData.masterySkills.add(i2);
        }
        playerData.classLevels = reader.getNextInts(PlayerClass.classesList.size());
        for (i = 0; i < PlayerClass.classesList.size(); ++i) {
            playerData.classesData[i] = PlayerClassData.applyPacket(reader);
        }
        for (i = 0; i < EQUIPPED_SKILLS_MAX; ++i) {
            playerData.equippedActiveSkills[i] = EquippedActiveSkill.applyPacket(reader);
        }
        playerData.lastDeath = reader.getNextLong();
        int grabbedObjectID = reader.getNextInt();
        playerData.grabbedObject = grabbedObjectID == -1 ? null : ObjectRegistry.getObject((int)grabbedObjectID);
        return playerData;
    }

    @Nullable
    public static GameObject isGrabbableObject(Level level, int tileX, int tileY) {
        GameObject object = level.getObject(tileX, tileY);
        if (object == null) {
            return null;
        }
        if (object.getID() <= 0) {
            return null;
        }
        if (object.toolType == ToolType.UNBREAKABLE) {
            return null;
        }
        if (object.isMultiTile()) {
            return null;
        }
        if (level.entityManager.getObjectEntity(tileX, tileY) instanceof OEInventory) {
            return null;
        }
        return object instanceof WallObject || object instanceof RockObject || object instanceof ColumnObject || object instanceof RoomFurniture || object instanceof StreetlampObject || object instanceof CandlePedestalObject || object instanceof TrainingDummyObject || object instanceof TreeObject ? object : null;
    }

    public int getInUseActiveSkillSlotIndex() {
        for (int i = 0; i < this.equippedActiveSkills.length; ++i) {
            if (!this.equippedActiveSkills[i].isInUse()) continue;
            return i;
        }
        return -1;
    }

    public EquippedActiveSkill getInUseActiveSkillSlot() {
        int index = this.getInUseActiveSkillSlotIndex();
        return index != -1 ? this.equippedActiveSkills[index] : null;
    }

    public ActiveSkill getInUseActiveSkill() {
        EquippedActiveSkill equippedActiveSkill = this.getInUseActiveSkillSlot();
        return equippedActiveSkill == null ? null : equippedActiveSkill.getActiveSkill();
    }

    public void removeInUseActiveSkillSlot() {
        EquippedActiveSkill equippedActiveSkill = this.getInUseActiveSkillSlot();
        if (equippedActiveSkill != null) {
            equippedActiveSkill.restartCooldown();
        }
    }
}

