/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.data;

import java.util.Arrays;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.content.player.SkillsLogic.SkillsList;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class PlayerClassData {
    public final String prefixDataName;
    public final String passivesDataName;
    public final String activeSkillsDataName;
    public final PlayerClass playerClass;
    public final String playerName;
    private int[] passiveLevels;
    private int[] activeSkillLevels;

    public PlayerClassData(int classID, String playerName) {
        this.playerClass = PlayerClass.classesList.get(classID);
        this.playerName = playerName;
        this.passiveLevels = new int[this.playerClass.passivesList.size()];
        this.activeSkillLevels = new int[this.playerClass.activeSkillsList.size()];
        this.prefixDataName = "rpgmod_" + this.playerClass.stringID + "_";
        this.passivesDataName = this.prefixDataName + "passive-";
        this.activeSkillsDataName = this.prefixDataName + "active-";
    }

    public PlayerData getPlayerData(boolean isServer) {
        return PlayerDataList.getPlayerData(this.playerName, isServer);
    }

    public int getLevel(boolean isServer) {
        return this.playerClass.getLevel(this.getPlayerData(isServer));
    }

    public int totalPassivePoints(boolean isServer) {
        return this.playerClass.totalPassivePoints(this.getLevel(isServer));
    }

    public int totalActiveSkillPoints(boolean isServer) {
        return this.playerClass.totalActiveSkillPoints(this.getLevel(isServer));
    }

    public int usedPassivePoints() {
        return Arrays.stream(this.passiveLevels).sum();
    }

    public int usedActiveSkillPoints() {
        return Arrays.stream(this.activeSkillLevels).sum();
    }

    public void loadData(LoadData loadData) {
        int i;
        int[] oldSavePassives = loadData.getIntArray(this.prefixDataName + "passives", null, false);
        int[] oldSaveActiveSkills = loadData.getIntArray(this.prefixDataName + "actives", null, false);
        if (oldSavePassives != null) {
            this.passiveLevels = oldSavePassives.length != this.playerClass.passivesList.size() ? new int[this.playerClass.passivesList.size()] : oldSavePassives;
        } else {
            this.passiveLevels = new int[this.playerClass.passivesList.size()];
            for (i = 0; i < this.playerClass.passivesList.getList().size(); ++i) {
                this.passiveLevels[i] = loadData.getInt(this.passivesDataName + this.playerClass.passivesList.get((int)i).stringID, 0, false);
            }
        }
        if (oldSaveActiveSkills != null) {
            this.activeSkillLevels = oldSaveActiveSkills.length != this.playerClass.activeSkillsList.size() ? new int[this.playerClass.activeSkillsList.size()] : oldSaveActiveSkills;
        } else {
            this.activeSkillLevels = new int[this.playerClass.activeSkillsList.size()];
            for (i = 0; i < this.playerClass.activeSkillsList.getList().size(); ++i) {
                this.activeSkillLevels[i] = loadData.getInt(this.activeSkillsDataName + this.playerClass.activeSkillsList.get((int)i).stringID, 0, false);
            }
        }
    }

    public int[] getPassiveLevels() {
        return this.passiveLevels;
    }

    public void setPassiveLevels(int[] passiveLevels) {
        this.passiveLevels = passiveLevels;
    }

    public void setPassiveLevel(int skillID, int level) {
        this.passiveLevels[skillID] = level;
    }

    public int[] getActiveSkillLevels() {
        return this.activeSkillLevels;
    }

    public void setActiveSkillLevels(int[] activeSkillLevels) {
        this.activeSkillLevels = activeSkillLevels;
    }

    public void setActiveSkillLevel(int skillID, int level) {
        this.activeSkillLevels[skillID] = level;
    }

    public void saveData(SaveData saveData) {
        int i;
        for (i = 0; i < this.playerClass.passivesList.getList().size(); ++i) {
            if (this.passiveLevels[i] <= 0) continue;
            saveData.addInt(this.passivesDataName + this.playerClass.passivesList.get((int)i).stringID, this.passiveLevels[i]);
        }
        for (i = 0; i < this.playerClass.activeSkillsList.getList().size(); ++i) {
            if (this.activeSkillLevels[i] <= 0) continue;
            saveData.addInt(this.activeSkillsDataName + this.playerClass.activeSkillsList.get((int)i).stringID, this.activeSkillLevels[i]);
        }
    }

    public static PlayerClassData applyPacket(PacketReader reader) {
        int id = reader.getNextInt();
        String playerName = reader.getNextString();
        PlayerClassData classData = new PlayerClassData(id, playerName);
        classData.passiveLevels = reader.getNextInts(classData.playerClass.passivesList.size());
        classData.activeSkillLevels = reader.getNextInts(classData.playerClass.activeSkillsList.size());
        return classData;
    }

    public void setupPacket(PacketWriter writer) {
        writer.putNextInt(this.playerClass.id);
        writer.putNextString(this.playerName);
        writer.putNextInts(this.passiveLevels);
        writer.putNextInts(this.activeSkillLevels);
    }

    public int getEffectiveSkillMaxLevel(Skill skill, int classLevel, int[] skillLevels) {
        boolean isPassive = skill instanceof Passive;
        SkillsList<Skill> skillsList = isPassive ? this.playerClass.passivesList : this.playerClass.activeSkillsList;
        int availablePoints = PlayerClassData.getAvailableSkillPointsAtLevel(skill.requiredClassLevel, classLevel, isPassive, skillLevels, skillsList, skill.id);
        return Math.min(skill.levelMax, availablePoints);
    }

    public static int getMaxSkillPointsAtLevel(int requiredLevel, int classLevel, boolean isPassive) {
        int maxPoints = classLevel - requiredLevel + 1;
        if (maxPoints <= 0) {
            return 0;
        }
        return isPassive ? maxPoints * 2 : maxPoints;
    }

    public static int getAvailableSkillPointsAtLevel(int requiredLevel, int classLevel, boolean isPassive, int[] skillLevels, SkillsList<? extends Skill> skillsList, int skillIdToExclude) {
        int maxPoints = PlayerClassData.getMaxSkillPointsAtLevel(requiredLevel, classLevel, isPassive);
        if (maxPoints == 0) {
            return 0;
        }
        int usedPoints = PlayerClassData.getUsedSkillPointsAtLevel(requiredLevel, skillLevels, skillsList, skillIdToExclude);
        int available = maxPoints - usedPoints;
        return Math.max(0, available);
    }

    public static int getUsedSkillPointsAtLevel(int requiredLevel, int[] skillLevels, SkillsList<? extends Skill> skillsList, int skillIdToExclude) {
        int usedPoints = 0;
        for (int i = 0; i < skillsList.size(); ++i) {
            int skillLevel;
            Skill skill = skillsList.get(i);
            if (skill.id == skillIdToExclude || (skillLevel = skillLevels[i]) <= 0 || skill.requiredClassLevel < requiredLevel) continue;
            usedPoints += skillLevels[i];
        }
        return usedPoints;
    }
}

