/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.data;

import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.BiConsumer;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormExpressionWheel;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.Item;
import necesse.level.maps.hudManager.HudDrawElement;
import necesse.level.maps.hudManager.floatText.UniqueFloatText;
import org.jetbrains.annotations.NotNull;
import rpgclasses.RPGResources;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.content.player.Mastery.MasterySkills.Chronomancer;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimplePassiveBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.packets.ActiveAbilityRunPacket;
import rpgclasses.registry.RPGModifiers;

public class EquippedActiveSkill {
    protected PlayerClass playerClass;
    protected ActiveSkill activeSkill;
    protected long lastUse;
    protected int cooldown;

    public EquippedActiveSkill() {
        this.playerClass = null;
        this.activeSkill = null;
    }

    public EquippedActiveSkill(int classID, int activeSkillID) {
        if (classID != -1 && activeSkillID != -1) {
            this.playerClass = PlayerClass.classesList.get(classID);
            this.activeSkill = this.playerClass.activeSkillsList.get(activeSkillID);
        }
    }

    public PlayerClass getPlayerClass() {
        return this.playerClass;
    }

    public ActiveSkill getActiveSkill() {
        return this.activeSkill;
    }

    public void modifyForm(FormExpressionWheel.Expression expression, Field drawIcon2, Field displayName) throws IllegalAccessException {
        displayName.set(expression, new LocalMessage("activeskills", this.activeSkill == null ? "empty" : this.activeSkill.stringID));
        drawIcon2.set(expression, new ActiveSkillDrawOptionsModifier());
    }

    public void saveData(SaveData saveData, int position) {
        String dataKeyPrefix = PlayerData.prefixDataName + "equippedactives" + position + "_";
        saveData.addInt(dataKeyPrefix + "class", this.playerClass == null ? -1 : this.playerClass.id);
        saveData.addInt(dataKeyPrefix + "activeSkill", this.activeSkill == null ? -1 : this.activeSkill.id);
        saveData.addLong(dataKeyPrefix + "lastUse", this.lastUse);
        saveData.addInt(dataKeyPrefix + "cooldown", this.cooldown);
    }

    public static EquippedActiveSkill loadData(PlayerMob player, LoadData loadData, int position) {
        String dataKeyPrefix = PlayerData.equippedActiveSkillsDataName + position + "_";
        int classID = loadData.getInt(dataKeyPrefix + "class", -1, false);
        int activeSkillID = loadData.getInt(dataKeyPrefix + "activeSkill", -1, false);
        long lastUse = loadData.getLong(dataKeyPrefix + "lastUse", 0L, false);
        EquippedActiveSkill equippedActiveSkill = new EquippedActiveSkill(classID, activeSkillID);
        equippedActiveSkill.lastUse = lastUse == -100L && (equippedActiveSkill.activeSkill instanceof SimplePassiveBuffActiveSkill || equippedActiveSkill.activeSkill instanceof SimpleTranformationActiveSkill) ? player.getTime() : lastUse;
        equippedActiveSkill.cooldown = loadData.getInt(dataKeyPrefix + "cooldown", 0);
        return equippedActiveSkill;
    }

    public void setupPacket(PacketWriter writer) {
        writer.putNextInt(this.playerClass == null ? -1 : this.playerClass.id);
        writer.putNextInt(this.activeSkill == null ? -1 : this.activeSkill.id);
        writer.putNextLong(this.lastUse);
        writer.putNextInt(this.cooldown);
    }

    public static EquippedActiveSkill applyPacket(PacketReader reader) {
        int classID = reader.getNextInt();
        int activeSkillID = reader.getNextInt();
        long lastUse = reader.getNextLong();
        int cooldown = reader.getNextInt();
        EquippedActiveSkill equippedActiveSkill = new EquippedActiveSkill(classID, activeSkillID);
        equippedActiveSkill.lastUse = lastUse;
        equippedActiveSkill.cooldown = cooldown;
        return equippedActiveSkill;
    }

    public boolean isInUse() {
        return this.lastUse == -100L;
    }

    public String getCooldownLeftString(int cooldownLeft) {
        if (this.isInUse()) {
            return Localization.translate((String)"ui", (String)"inuse");
        }
        return EquippedActiveSkill.getTimeLeftString(cooldownLeft);
    }

    public static String getTimeLeftString(int cooldownLeft) {
        String amountString = cooldownLeft < 1000 ? String.format("%.1fs", Float.valueOf((float)cooldownLeft / 1000.0f)) : cooldownLeft / 1000 + "s";
        return amountString;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getCooldownLeft(long currentTime) {
        long cooldownLeftLong;
        long lastUse = this.lastUse;
        int cooldown = this.getCooldown();
        if (this.isInUse()) {
            return 0;
        }
        long l = cooldownLeftLong = lastUse == 0L || currentTime == 0L ? 0L : (long)cooldown - (currentTime - lastUse);
        int cooldownLeft = cooldownLeftLong > Integer.MAX_VALUE ? 0 : (cooldownLeftLong < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)cooldownLeftLong);
        return cooldownLeft;
    }

    public boolean isInCooldown(long currentTime) {
        long lastUse = this.lastUse;
        int cooldown = this.getCooldown();
        return (long)cooldown - (currentTime - lastUse) > 0L;
    }

    public boolean isSameSkill(EquippedActiveSkill equippedActiveSkill) {
        return !equippedActiveSkill.isEmpty() && this.isSameSkill(equippedActiveSkill.playerClass, equippedActiveSkill.activeSkill);
    }

    public boolean isSameSkill(ActiveSkill activeSkill) {
        return this.isSameSkill(activeSkill.playerClass, activeSkill);
    }

    public boolean isSameSkill(PlayerClass playerClass, ActiveSkill activeSkill) {
        return !this.isEmpty() && this.playerClass.id == playerClass.id && this.activeSkill.id == activeSkill.id;
    }

    public boolean isSameFamily(EquippedActiveSkill equippedActiveSkill) {
        return !equippedActiveSkill.isEmpty() && this.isSameFamily(equippedActiveSkill.playerClass, equippedActiveSkill.activeSkill);
    }

    public boolean isSameFamily(PlayerClass playerClass, ActiveSkill activeSkill) {
        return !this.isEmpty() && activeSkill.family != null && this.playerClass.id == playerClass.id && Objects.equals(this.activeSkill.family, activeSkill.family);
    }

    public boolean isNotSameSkillButSameFamily(EquippedActiveSkill equippedActiveSkill) {
        return this.isSameFamily(equippedActiveSkill) && !this.isSameSkill(equippedActiveSkill);
    }

    public boolean isNotSameSkillButSameFamily(PlayerClass playerClass, ActiveSkill activeSkill) {
        return this.isSameFamily(playerClass, activeSkill) && !this.isSameSkill(playerClass, activeSkill);
    }

    public boolean sameClass(PlayerClassData classData) {
        return this.sameClass(classData.playerClass);
    }

    public boolean sameClass(PlayerClass playerClass) {
        return playerClass.id == this.playerClass.id;
    }

    public boolean isEmpty() {
        return this.playerClass == null || this.activeSkill == null;
    }

    public void empty() {
        this.playerClass = null;
        this.activeSkill = null;
        this.lastUse = 0L;
        this.cooldown = 0;
    }

    public void update(PlayerClass playerClass, ActiveSkill activeSkill) {
        this.empty();
        this.playerClass = playerClass;
        this.activeSkill = activeSkill;
    }

    public void startCooldown(PlayerMob player, PlayerData playerData, long currentTime, int skillLevel) {
        this.startCooldown(player, playerData, currentTime, skillLevel, 0);
    }

    public void startCooldown(PlayerMob player, PlayerData playerData, long currentTime, int skillLevel, int addedCooldown) {
        this.startCustomCooldown(playerData, currentTime, this.activeSkill.getCooldown(player, skillLevel) + addedCooldown);
    }

    public void startCustomCooldown(PlayerData playerData, long currentTime, int cooldown) {
        this.lastUse = currentTime;
        float mod = 1.0f;
        if (playerData != null && playerData.hasMasterySkill(Mastery.CHRONOMANCER)) {
            mod -= Chronomancer.params[0].value();
        }
        this.cooldown = (int)((float)cooldown * mod);
    }

    public void modCooldown(int mod) {
        this.cooldown = Math.max(0, this.cooldown + mod);
    }

    public void restartCooldown() {
        this.lastUse = 0L;
        this.cooldown = 0;
    }

    public void setInUse() {
        this.lastUse = -100L;
        this.cooldown = 0;
    }

    public void setCooldown(EquippedActiveSkill equippedActiveSkill) {
        this.startCustomCooldown(null, equippedActiveSkill.lastUse, equippedActiveSkill.cooldown);
    }

    public boolean canChange(long currentTime) {
        if (this.isEmpty()) {
            return true;
        }
        if (this.isInUse()) {
            return false;
        }
        return !this.isInCooldown(currentTime);
    }

    public void tryClientRun(final PlayerMob player, int skillSlot) {
        if (player.isClient()) {
            String canActiveError = this.canActive(player);
            if (canActiveError != null) {
                if (!canActiveError.isEmpty()) {
                    UniqueFloatText text = new UniqueFloatText(player.getX(), player.getY() - 20, Localization.translate((String)"message", (String)canActiveError), new FontOptions(16).outline().color(new Color(200, 100, 100)), "activeerror"){

                        public int getAnchorX() {
                            return player.getX();
                        }

                        public int getAnchorY() {
                            return player.getY() - 20;
                        }
                    };
                    player.getLevel().hudManager.addElement((HudDrawElement)text);
                }
                return;
            }
            int seed = Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom);
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            int activeSkillLevel = this.activeSkill.getLevel(playerData);
            this.activeSkill.runClient(player, playerData, activeSkillLevel, seed, this.isInUse());
            player.getClient().network.sendPacket((Packet)new ActiveAbilityRunPacket(player.getClient().getSlot(), skillSlot));
        }
    }

    public void run(PlayerMob player) {
        int seed = Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom);
        PlayerData playerData = PlayerDataList.getPlayerData(player);
        int activeSkillLevel = this.activeSkill.getLevel(playerData);
        if (player.isClient()) {
            this.activeSkill.runClient(player, playerData, activeSkillLevel, seed, this.isInUse());
        }
        if (player.isServer()) {
            this.activeSkill.runServer(player, playerData, activeSkillLevel, seed, this.isInUse());
        }
    }

    public String canActive(PlayerMob player) {
        int cooldownLeft;
        boolean isInUse;
        ActiveSkill inUseSkill;
        if (((Boolean)player.buffManager.getModifier(RPGModifiers.NO_SKILLS)).booleanValue()) {
            return "";
        }
        if (this.isEmpty()) {
            return "equipfirst";
        }
        ActiveSkill activeSkill = this.activeSkill;
        PlayerData playerData = PlayerDataList.getPlayerData(player);
        PlayerClassData playerClassData = playerData.getClassesData()[this.playerClass.id];
        int activeSkillLevel = playerClassData.getActiveSkillLevels()[activeSkill.id];
        if (playerClassData.getLevel(player.isServer()) < 1 || activeSkillLevel < 1) {
            return "noactiveskill";
        }
        boolean isInUseSkill = activeSkill.isInUseSkill();
        if (!(!isInUseSkill || (inUseSkill = playerData.getInUseActiveSkill()) == null || inUseSkill == this.activeSkill || this.activeSkill instanceof SimpleTranformationActiveSkill && inUseSkill instanceof SimpleTranformationActiveSkill)) {
            return "anotheractiveskillinuse";
        }
        boolean bl = isInUse = isInUseSkill && this.isInUse();
        if (isInUse && !activeSkill.canUseIfIsInUse()) {
            return "activeskillinuse";
        }
        long currentTime = player.getLevel().getTime();
        if (!isInUse && (cooldownLeft = this.getCooldownLeft(currentTime)) > 0) {
            return "incooldown";
        }
        return activeSkill.canActive(player, playerData, activeSkillLevel, isInUse);
    }

    public class ActiveSkillDrawOptionsModifier
    implements BiConsumer<Point, PlayerMob> {
        @Override
        public void accept(Point pos, PlayerMob player) {
            int cooldownLeft;
            int size = 34;
            GameTexture gameTexture = EquippedActiveSkill.this.activeSkill == null ? RPGResources.emptyActiveSkill_texture : EquippedActiveSkill.this.activeSkill.texture;
            gameTexture.initDraw().pos(pos.x - size / 2, pos.y - size / 2 + 5).draw();
            if (EquippedActiveSkill.this.playerClass != null && EquippedActiveSkill.this.activeSkill != null && ((cooldownLeft = EquippedActiveSkill.this.getCooldownLeft(player.getTime())) > 0 || EquippedActiveSkill.this.isInUse())) {
                String cooldownLeftString = EquippedActiveSkill.this.getCooldownLeftString(cooldownLeft);
                FontOptions options = new FontOptions(Item.tipFontOptions);
                options.color(new Color(255, 102, 102));
                int width = FontManager.bit.getWidthCeil(cooldownLeftString, options);
                FontManager.bit.drawString((float)pos.x + (float)size / 2.0f - (float)width, (float)pos.y + (float)size / 2.0f - 5.0f + 12.0f, cooldownLeftString, options);
            }
        }

        @Override
        @NotNull
        public BiConsumer<Point, PlayerMob> andThen(@NotNull BiConsumer<? super Point, ? super PlayerMob> after) {
            return BiConsumer.super.andThen(after);
        }
    }
}

