/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.ListGameTooltips;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ComplexExtraToolTip;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.utils.RPGColors;

public abstract class Skill {
    public int id;
    public final String stringID;
    public final String color;
    public final int levelMax;
    public final int requiredClassLevel;
    public GameTexture texture;
    public PlayerClass playerClass;
    public String family = null;
    public static String[] changes = new String[]{"skilllevel", "playerlevel"};

    public Skill(String stringID, String color, int levelMax, int requiredClassLevel) {
        this.stringID = stringID;
        this.color = color;
        this.levelMax = levelMax;
        this.requiredClassLevel = requiredClassLevel;
    }

    public ListGameTooltips getBaseToolTips(PlayerMob player) {
        ListGameTooltips tooltips = new ListGameTooltips();
        for (String string : this.getToolTipsText(player)) {
            if (string.contains("[[") && string.contains("]]")) {
                string = this.baseToolTipsReplaces(player, string);
                SkillParam[] params = this.getParams();
                for (int i = 0; i < params.length; ++i) {
                    SkillParam param = params[i];
                    string = string.replaceAll("\\[\\[" + i + "]]", param.baseParamValue());
                }
                for (String change : changes) {
                    string = string.replaceAll("<" + change + ">", Localization.translate((String)"skillsdesckeys", (String)change));
                }
            }
            tooltips.add(string);
        }
        return tooltips;
    }

    public String baseToolTipsReplaces(PlayerMob player, String string) {
        return string;
    }

    public Skill setFamily(String family) {
        this.family = family;
        return this;
    }

    public abstract List<String> getToolTipsText(PlayerMob var1);

    public abstract void initResources();

    public int getLevel(PlayerMob player) {
        return this.getLevel(PlayerDataList.getPlayerData(player));
    }

    public int getLevel(PlayerData playerData) {
        return this.getLevel(playerData.getClassesData()[this.playerClass.id]);
    }

    public int getLevel(PlayerClassData classData) {
        return classData.getPassiveLevels()[this.id];
    }

    public void registry() {
    }

    public ListGameTooltips getFinalToolTips(PlayerMob player, int skillLevel, boolean onlyChanges) {
        if (!this.containsComplexTooltips() || skillLevel <= 0) {
            return this.getBaseToolTips(player);
        }
        PlayerData playerData = PlayerDataList.getPlayerData(player);
        if (playerData == null) {
            return this.getBaseToolTips(player);
        }
        ListGameTooltips tooltips = new ListGameTooltips();
        List<String> raw = this.getToolTipsText(player);
        raw.set(0, raw.get(0) + " - " + Localization.translate((String)"ui", (String)"level", (String)"level", (Object)skillLevel));
        for (String string : raw) {
            if (string.contains("[[") && string.contains("]]")) {
                string = this.finalToolTipsReplaces(player, string, playerData, skillLevel);
                SkillParam[] params = this.getParams();
                for (int i = 0; i < params.length; ++i) {
                    SkillParam param = params[i];
                    string = string.replaceAll("\\[\\[" + i + "]]", param.paramValue(playerData.getLevel(), skillLevel));
                }
                tooltips.add(string);
                continue;
            }
            if (onlyChanges) continue;
            tooltips.add(string);
        }
        return tooltips;
    }

    public String finalToolTipsReplaces(PlayerMob player, String string, PlayerData playerData, int skillLevel) {
        return string;
    }

    public String[] getAllExtraTooltips() {
        String[] baseTooltips = this.getExtraTooltips();
        if (this.addManaUsageExtraToolTip()) {
            String[] result = new String[baseTooltips.length + 1];
            System.arraycopy(baseTooltips, 0, result, 0, baseTooltips.length);
            result[baseTooltips.length] = "manausage";
            return result;
        }
        return baseTooltips;
    }

    public String[] getExtraTooltips() {
        return new String[0];
    }

    public String[] getAllExtraTooltips(PlayerMob player, int skillLevel, boolean processFinal) {
        String[] tooltips = (String[])this.getAllExtraTooltips().clone();
        PlayerData playerData = processFinal ? PlayerDataList.getPlayerData(player) : null;
        for (int i = 0; i < tooltips.length; ++i) {
            String extraToolTip = tooltips[i];
            String tooltip = Localization.translate((String)"extraskilldesc", (String)extraToolTip);
            SkillParam[] params = ComplexExtraToolTip.get(extraToolTip);
            if (params != null && params.length > 0) {
                int j;
                if (processFinal) {
                    for (j = 0; j < params.length; ++j) {
                        SkillParam param = params[j];
                        tooltip = tooltip.replaceAll("\\[\\[" + j + "]]", param.paramValue(playerData.getLevel(), skillLevel));
                    }
                } else {
                    for (j = 0; j < params.length; ++j) {
                        SkillParam param = params[j];
                        tooltip = tooltip.replaceAll("\\[\\[" + j + "]]", param.baseParamValue());
                    }
                    for (String change : changes) {
                        tooltip = tooltip.replaceAll("<" + change + ">", Localization.translate((String)"skillsdesckeys", (String)change));
                    }
                }
            }
            tooltips[i] = tooltip;
        }
        return tooltips;
    }

    public boolean containsComplexTooltips() {
        return false;
    }

    public static Point2D.Float getDir(Mob mob) {
        float dirY;
        float dirX;
        if (mob.dx == 0.0f && mob.dy == 0.0f) {
            Point2D.Float dir = Skill.getDirFromFacing(mob.getDir());
            dirX = dir.x;
            dirY = dir.y;
        } else {
            dirX = mob.dx;
            dirY = mob.dy;
            float magnitude = (float)Math.sqrt(dirX * dirX + dirY * dirY);
            if (magnitude != 0.0f) {
                dirX /= magnitude;
                dirY /= magnitude;
            }
            Point2D.Float expected = Skill.getDirFromFacing(mob.getDir());
            if (expected.x != 0.0f && dirX > 0.0f != expected.x > 0.0f) {
                dirX = expected.x;
            }
            if (expected.y != 0.0f && dirY > 0.0f != expected.y > 0.0f) {
                dirY = expected.y;
            }
        }
        return new Point2D.Float(dirX, dirY);
    }

    private static Point2D.Float getDirFromFacing(int dir) {
        switch (dir) {
            case 0: {
                return new Point2D.Float(0.0f, -1.0f);
            }
            case 1: {
                return new Point2D.Float(1.0f, 0.0f);
            }
            case 2: {
                return new Point2D.Float(0.0f, 1.0f);
            }
            case 3: {
                return new Point2D.Float(-1.0f, 0.0f);
            }
        }
        return new Point2D.Float(0.0f, 0.0f);
    }

    public int getColorInt() {
        return RPGColors.getColorInt(this.color);
    }

    public Color getColor() {
        return RPGColors.getColor(this.color);
    }

    public abstract SkillParam[] getParams();

    public boolean addManaUsageExtraToolTip() {
        return false;
    }
}

