/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.Passives;

import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.buffs.Skill.SecondaryPassiveBuff;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.data.PlayerData;

public abstract class SimpleBuffPassive
extends Passive {
    public boolean containsComplexTooltips;

    public SimpleBuffPassive(String stringID, String color, int levelMax, int requiredClassLevel, boolean containsComplexTooltips) {
        super(stringID, color, levelMax, requiredClassLevel);
        this.containsComplexTooltips = containsComplexTooltips;
    }

    public SimpleBuffPassive(String stringID, String color, int levelMax, int requiredClassLevel) {
        this(stringID, color, levelMax, requiredClassLevel, true);
    }

    @Override
    public void givePassiveBuff(PlayerMob player, PlayerData playerData, int passiveLevel) {
        boolean differentOldLevel;
        ActiveBuff oldAb = player.buffManager.getBuff(this.getBuffStringID());
        int oldLevel = oldAb == null ? 0 : oldAb.getGndData().getInt("skillLevel");
        boolean bl = differentOldLevel = oldLevel != passiveLevel;
        if (differentOldLevel) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)this.getBuffStringID()), (Mob)player, 1000, null);
            ab.getGndData().setInt("skillLevel", passiveLevel);
            player.buffManager.addBuff(ab, player.isServer(), oldAb != null);
        }
    }

    public void giveDatalessSecondaryPassiveBuff(Mob target, float duration) {
        this.giveDatalessSecondaryPassiveBuff(target, (int)(duration * 1000.0f));
    }

    public void giveDatalessSecondaryPassiveBuff(Mob target, int duration) {
        ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)this.getSecondaryBuffStringID()), target, duration, null);
        target.buffManager.addBuff(ab, target.isServer());
    }

    public void giveSecondaryPassiveBuff(PlayerMob player, Mob target, int passiveLevel, float duration) {
        this.giveSecondaryPassiveBuff(player, target, passiveLevel, (int)(duration * 1000.0f));
    }

    public void giveSecondaryPassiveBuff(PlayerMob player, Mob target, int passiveLevel, int duration) {
        ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)this.getSecondaryBuffStringID()), target, duration, null);
        ab.getGndData().setInt("skillLevel", passiveLevel);
        ab.getGndData().setInt("playerLevel", passiveLevel);
        target.buffManager.addBuff(ab, player.isServer());
    }

    @Override
    public void removePassiveBuffs(PlayerMob player) {
        player.buffManager.removeBuff(this.getBuffStringID(), true);
    }

    @Override
    public void registry() {
        SecondaryPassiveBuff secondaryPassiveBuff;
        super.registry();
        PrincipalPassiveBuff principalPassiveBuff = this.getBuff();
        if (principalPassiveBuff != null) {
            BuffRegistry.registerBuff((String)this.getBuffStringID(), (Buff)principalPassiveBuff);
        }
        if ((secondaryPassiveBuff = this.getSecondaryBuff()) != null) {
            BuffRegistry.registerBuff((String)this.getSecondaryBuffStringID(), (Buff)secondaryPassiveBuff);
        }
    }

    public abstract PrincipalPassiveBuff getBuff();

    public SecondaryPassiveBuff getSecondaryBuff() {
        return null;
    }

    public String getBuffStringID() {
        return this.stringID + this.buffsStringID();
    }

    public String getSecondaryBuffStringID() {
        return this.stringID + "2" + this.buffsStringID();
    }

    @Override
    public boolean containsComplexTooltips() {
        return this.containsComplexTooltips;
    }

    public String buffsStringID() {
        return "passivebuff";
    }
}

