/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.Passives;

import java.util.ArrayList;
import java.util.List;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameTexture;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.data.PlayerData;

public abstract class Passive
extends Skill {
    public Passive(String stringID, String color, int levelMax, int requiredClassLevel) {
        super(stringID, color, levelMax, requiredClassLevel);
    }

    @Override
    public Passive setFamily(String family) {
        this.family = family;
        return this;
    }

    @Override
    public List<String> getToolTipsText(PlayerMob player) {
        ArrayList<String> tooltips = new ArrayList<String>();
        tooltips.add("\u00a7" + this.color + Localization.translate((String)"passives", (String)this.stringID));
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"passivesdesc", (String)this.stringID));
        if (this.requiredClassLevel > 1) {
            tooltips.add(" ");
            tooltips.add(Localization.translate((String)"ui", (String)"requiredclasslevel", (String)"level", (Object)this.requiredClassLevel));
        }
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"ui", (String)"maxlevel", (String)"level", (Object)this.levelMax));
        return tooltips;
    }

    @Override
    public void initResources() {
        this.texture = GameTexture.fromFile((String)("passives/" + this.stringID));
    }

    public boolean isBasic() {
        return false;
    }

    public abstract void givePassiveBuff(PlayerMob var1, PlayerData var2, int var3);

    public abstract void removePassiveBuffs(PlayerMob var1);

    @Override
    public boolean containsComplexTooltips() {
        return true;
    }
}

