/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.Passives;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import rpgclasses.content.player.SkillsLogic.ModifierBuffs.ModifierBuff;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.data.PlayerData;

public class BasicPassive
extends Passive {
    public List<ModifierBuff<?>> attributeModifiers = new ArrayList();
    public String[] extraTooltips;
    public boolean onlyTransformed = false;

    public BasicPassive(String stringID, String color, int levelMax, int requiredClassLevel, String[] extraTooltips, ModifierBuff<?> ... modifierBuffs) {
        super(stringID, color, levelMax, requiredClassLevel);
        Collections.addAll(this.attributeModifiers, modifierBuffs);
        this.extraTooltips = extraTooltips;
    }

    public BasicPassive(String stringID, String color, int levelMax, int requiredClassLevel, ModifierBuff<?> ... modifierBuffs) {
        this(stringID, color, levelMax, requiredClassLevel, new String[0], modifierBuffs);
    }

    public BasicPassive setOnlyTransformed() {
        this.onlyTransformed = true;
        return this;
    }

    @Override
    public List<String> getToolTipsText(PlayerMob player) {
        ArrayList<String> tooltips = new ArrayList<String>();
        tooltips.add("\u00a7" + this.color + Localization.translate((String)"passives", (String)this.stringID));
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"ui", (String)"eachlevel"));
        tooltips.add(" ");
        for (ModifierBuff<?> attributeModifier : this.attributeModifiers) {
            tooltips.add(attributeModifier.getTooltip());
        }
        if (this.onlyTransformed) {
            tooltips.add(" ");
            tooltips.add(Localization.translate((String)"ui", (String)"onlytranformed"));
        }
        if (this.requiredClassLevel > 1) {
            tooltips.add(" ");
            tooltips.add(Localization.translate((String)"ui", (String)"requiredclasslevel", (String)"level", (Object)this.requiredClassLevel));
        }
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"ui", (String)"maxlevel", (String)"level", (Object)this.levelMax));
        return tooltips;
    }

    public void applyBuff(ActiveBuff activeBuff, float level) {
        for (ModifierBuff<?> attributeModifier : this.attributeModifiers) {
            attributeModifier.applyBuff(activeBuff, level);
        }
    }

    @Override
    public void givePassiveBuff(PlayerMob player, PlayerData playerData, int level) {
    }

    @Override
    public void removePassiveBuffs(PlayerMob player) {
    }

    @Override
    public boolean containsComplexTooltips() {
        return false;
    }

    @Override
    public String[] getExtraTooltips() {
        return this.extraTooltips;
    }

    @Override
    public SkillParam[] getParams() {
        return new SkillParam[0];
    }
}

