/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.Params;

import java.util.Objects;
import necesse.engine.localization.Localization;
import rpgclasses.content.player.SkillsLogic.Params.SkillParamColors;

public class SkillParam {
    public String color;
    public String schema;
    public int addedDecimals;
    public int decimals;
    public int round;

    public SkillParam(String schema, SkillParamColors color) {
        this.schema = schema;
        this.color = color == null ? null : color.color;
        this.decimals = 1;
        this.round = 0;
    }

    public SkillParam(String schema) {
        this(schema, SkillParamColors.NORMAL);
    }

    public static SkillParam complexParam(float value, SkillParamColors color) {
        if (value == 1.0f) {
            return new SkillParam("<playerlevel> x <skilllevel>", color);
        }
        String valueString = String.valueOf(value);
        if (valueString.endsWith(".0")) {
            valueString = valueString.replace(".0", "");
        }
        return new SkillParam(valueString + " x <playerlevel> x <skilllevel>", color);
    }

    public static SkillParam complexParam(float value) {
        return SkillParam.complexParam(value, SkillParamColors.NORMAL);
    }

    public static SkillParam damageParam(float value) {
        return SkillParam.complexParam(value, SkillParamColors.DAMAGE);
    }

    public static SkillParam healingParam(float value) {
        return SkillParam.complexParam(value, SkillParamColors.HEALING).setDecimals(0);
    }

    public static SkillParam manaParam(float value) {
        return SkillParam.manaParam(value, true);
    }

    public static SkillParam manaParam(float value, boolean scales) {
        String valueString = String.valueOf(value);
        if (valueString.endsWith(".0")) {
            valueString = valueString.replace(".0", "");
        }
        if (!scales) {
            return new SkillParam(valueString, SkillParamColors.MANA);
        }
        float valueScale = value / 5.0f;
        String valueScaleString = String.valueOf(valueScale);
        if (valueScaleString.endsWith(".0")) {
            valueScaleString = valueScaleString.replace(".0", "");
        }
        return new SkillParam(valueString + " + " + valueScaleString + " x <skilllevel>", SkillParamColors.MANA);
    }

    public static SkillParam staticParam(float value) {
        String valueString = String.valueOf(value);
        if (valueString.endsWith(".0")) {
            valueString = valueString.replace(".0", "");
        }
        return new SkillParam(valueString, null);
    }

    public SkillParam setDecimals(int addedDecimals, int decimals) {
        this.addedDecimals = addedDecimals;
        this.decimals = decimals + addedDecimals;
        return this;
    }

    public SkillParam setDecimals(int decimals) {
        this.decimals = decimals;
        return this;
    }

    public SkillParam roundCeil() {
        this.round = 1;
        return this;
    }

    public SkillParam roundFloor() {
        this.round = -1;
        return this;
    }

    public float value(int playerLevel, int skillLevel) {
        return this.value(playerLevel, skillLevel, false);
    }

    public float value(int playerLevel, int skillLevel, boolean isVisual) {
        String[] tokens = this.schema.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.parseSection(tokens[i], playerLevel, skillLevel);
        }
        float result = 0.0f;
        float currentTerm = 0.0f;
        String operator = "+";
        String pendingOp = "+";
        String[] stringArray = tokens;
        int n = stringArray.length;
        block21: for (int i = 0; i < n; ++i) {
            String token;
            switch (token = stringArray[i]) {
                case "+": 
                case "-": {
                    result = pendingOp.equals("+") ? (result += currentTerm) : (result -= currentTerm);
                    pendingOp = token;
                    operator = "+";
                    currentTerm = 0.0f;
                    continue block21;
                }
                case "*": 
                case "x": {
                    operator = "*";
                    continue block21;
                }
                default: {
                    try {
                        float value;
                        switch (token) {
                            case "<skilllevel>": {
                                value = skillLevel;
                                break;
                            }
                            case "<playerlevel>": {
                                value = playerLevel;
                                break;
                            }
                            default: {
                                value = Float.parseFloat(token);
                            }
                        }
                        if (operator.equals("*")) {
                            currentTerm *= value;
                            continue block21;
                        }
                        currentTerm = value;
                        continue block21;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Not valid schema");
                    }
                }
            }
        }
        result = pendingOp.equals("+") ? (result += currentTerm) : (result -= currentTerm);
        return this.round(result, isVisual);
    }

    public float round(float value, boolean isVisual) {
        float fValue;
        int factor = (int)Math.pow(10.0, this.decimals);
        float f = fValue = isVisual || this.addedDecimals == 0 ? value : value / (float)((int)Math.pow(10.0, this.addedDecimals));
        if (this.round == 0) {
            return (float)Math.round(fValue * (float)factor) / (float)factor;
        }
        if (this.round == 1) {
            return (float)Math.ceil(fValue * (float)factor) / (float)factor;
        }
        return (float)Math.floor(fValue * (float)factor) / (float)factor;
    }

    public float valuePlayer(int playerLevel) {
        return this.value(playerLevel, 0);
    }

    public float value(int skillLevel) {
        return this.value(0, skillLevel);
    }

    public float value() {
        return this.value(0, 0);
    }

    public String parseSection(String section, int playerLevel, int skillLevel) {
        if (Objects.equals(section, "playerlevel")) {
            return String.valueOf(playerLevel);
        }
        if (Objects.equals(section, "skilllevel")) {
            return String.valueOf(skillLevel);
        }
        return section;
    }

    public String baseParamValue() {
        CharSequence[] sections = this.schema.split(" ");
        for (int i = 0; i < sections.length; ++i) {
            sections[i] = this.parseSection(sections[i]);
        }
        return this.getColorStart() + String.join((CharSequence)" ", sections) + this.getColorEnd();
    }

    public String parseSection(String section) {
        if (section.startsWith("<") && section.endsWith(">")) {
            return Localization.translate((String)"skillsdesckeys", (String)section.replaceAll("<", "").replaceAll(">", ""));
        }
        return section;
    }

    public String paramValue(int playerLevel, int skillLevel) {
        String value = String.valueOf(this.value(playerLevel, skillLevel, true));
        if (value.endsWith(".0")) {
            value = value.replace(".0", "");
        }
        return this.getColorStart() + value + this.getColorEnd();
    }

    public String getColorStart() {
        return this.color == null ? "" : "\u00a7" + this.color;
    }

    public String getColorEnd() {
        return this.color == null ? "" : "\u00a70";
    }

    public int valueInt(int playerLevel, int skillLevel) {
        this.decimals = 0;
        this.addedDecimals = 0;
        return Math.round(this.value(playerLevel, skillLevel));
    }

    public int valuePlayerInt(int playerLevel) {
        return this.valueInt(playerLevel, 0);
    }

    public int valueInt(int skillLevel) {
        return this.valueInt(0, skillLevel);
    }

    public int valueInt() {
        return this.valueInt(0, 0);
    }
}

