/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.ModifierBuffs;

import java.util.Objects;
import necesse.engine.modifiers.Modifier;
import necesse.engine.modifiers.ModifierValue;
import necesse.entity.mobs.buffs.ActiveBuff;

public abstract class ModifierBuff<T> {
    public final Modifier<T> modifier;
    public final T value;
    public boolean setMin = false;
    public boolean setMax = false;
    public T maxMod;
    public T minMod;

    public ModifierBuff(Modifier<T> modifier, T value) {
        this.modifier = modifier;
        this.value = value;
    }

    public ModifierBuff<T> doSetMin() {
        this.setMin = true;
        return this;
    }

    public ModifierBuff<T> doSetMin(T minMod) {
        this.setMin = true;
        this.maxMod = minMod;
        return this;
    }

    public ModifierBuff<T> doSetMax() {
        this.setMax = true;
        return this;
    }

    public ModifierBuff<T> doSetMax(T maxMod) {
        this.setMax = true;
        this.maxMod = maxMod;
        return this;
    }

    public void applyBuff(ActiveBuff activeBuff, float level) {
        T value = this.scaledValue(level);
        activeBuff.addModifier(this.modifier, value);
        ModifierValue modifierValue = new ModifierValue(this.modifier);
        if (value instanceof Integer) {
            int base = (Integer)value;
            if (this.setMin) {
                modifierValue.min((Object)(base + (Integer)this.minMod));
            }
            if (this.setMax) {
                modifierValue.max((Object)(base + (Integer)this.maxMod));
            }
        } else if (value instanceof Float) {
            float base = ((Float)value).floatValue();
            if (this.setMin) {
                modifierValue.min((Object)Float.valueOf(base + ((Float)this.minMod).floatValue()));
            }
            if (this.setMax) {
                modifierValue.max((Object)Float.valueOf(base + ((Float)this.maxMod).floatValue()));
            }
        }
        activeBuff.addModifierLimits(this.modifier, modifierValue.limits);
    }

    public String getLocalizationString() {
        String stringID = this.modifier.stringID;
        if (stringID.startsWith("rangedam") || stringID.startsWith("range") && !stringID.startsWith("ranged")) {
            return stringID.replace("range", "ranged");
        }
        if (Objects.equals(stringID, "attackmovementmod")) {
            return "attackmovement";
        }
        if (Objects.equals(stringID, "incomingdamagemod")) {
            return "incdamage";
        }
        if (Objects.equals(stringID, "staminacapacity")) {
            return "staminacap";
        }
        if (Objects.equals(stringID, "alldamage")) {
            return "damage";
        }
        return stringID;
    }

    public abstract String getTooltip();

    public abstract T scaledValue(float var1);
}

