/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.ActiveSkills;

import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketMobMount;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.RPGResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGModifiers;

public abstract class SimpleTranformationActiveSkill
extends ActiveSkill {
    public SimpleTranformationActiveSkill(String stringID, String color, int levelMax, int requiredClassLevel) {
        super(stringID, color, levelMax, requiredClassLevel);
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        if (isInUse) {
            this.removeTransformationOnRun(player);
        } else {
            if (((Float)player.buffManager.getModifier(RPGModifiers.TRANSFORMATION_DELAY)).floatValue() > 0.0f) {
                player.dismount();
                ActiveBuff ab = new ActiveBuff(RPGBuffs.TRANSFORMING, (Mob)player, (int)((float)this.castingDuration() * ((Float)player.buffManager.getModifier(RPGModifiers.TRANSFORMATION_DELAY)).floatValue()), null);
                ab.getGndData().setInt("transformationType", 0);
                ab.getGndData().setString("transformation", this.stringID);
                ab.getGndData().setInt("particlesColor", this.getColorInt());
                player.buffManager.addBuff(ab, true);
            } else {
                this.transform(player);
            }
            for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
                if (equippedActiveSkill.getActiveSkill() == this || !equippedActiveSkill.isInUse()) continue;
                equippedActiveSkill.startCooldown(player, playerData, player.getTime(), activeSkillLevel);
            }
        }
    }

    @Override
    public String canActive(PlayerMob player, PlayerData playerData, int activeSkillLevel, boolean isInUSe) {
        if (player.isRiding() && !isInUSe && !(playerData.getInUseActiveSkill() instanceof SimpleTranformationActiveSkill)) {
            return "canotusemounted";
        }
        return super.canActive(player, playerData, activeSkillLevel, isInUSe);
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        if (isInUse) {
            SoundManager.playSound((GameSound)GameResources.swoosh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player).volume(0.35f).pitch(1.0f));
        } else {
            if (((Float)player.buffManager.getModifier(RPGModifiers.TRANSFORMATION_DELAY)).floatValue() <= 0.0f) {
                SoundManager.playSound((GameSound)GameResources.swoosh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player).volume(0.35f).pitch(1.0f));
            }
            for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
                if (equippedActiveSkill.getActiveSkill() == this || !equippedActiveSkill.isInUse()) continue;
                equippedActiveSkill.startCooldown(player, playerData, player.getTime(), activeSkillLevel);
            }
        }
    }

    @Override
    public boolean isInUseSkill() {
        return true;
    }

    public void removeTransformationOnRun(PlayerMob player) {
        Mob mount2 = player.getMount();
        if (mount2 != null) {
            mount2.remove();
        }
    }

    public int castingDuration() {
        return 3000;
    }

    public void transform(PlayerMob player) {
        player.dismount();
        SkillTransformationMountMob transformationMob = (SkillTransformationMountMob)MobRegistry.getMob((String)this.getMobStringID(), (Level)player.getLevel());
        transformationMob.applyData(this.playerClass, this);
        transformationMob.colorInt = this.getColorInt();
        transformationMob.setPos(player.x, player.y, true);
        transformationMob.dx = player.dx;
        transformationMob.dy = player.dy;
        player.mount((Mob)transformationMob, true, player.x, player.y, true);
        player.getLevel().entityManager.mobs.add((Entity)transformationMob);
        player.getServer().network.sendToClientsWithEntity((Packet)new PacketMobMount(player.getUniqueID(), transformationMob.getUniqueID(), true, player.x, player.y), (RegionPositionGetter)player);
    }

    @Override
    public void registry() {
        super.registry();
        MobRegistry.registerMob((String)this.getMobStringID(), this.getMobClass(), (boolean)false);
    }

    @Override
    public void initResources() {
        super.initResources();
        if (this.initMobTexture()) {
            RPGResources.mobsTexture.put(this.getMobStringID(), GameTexture.fromFile((String)("mobs/transformations/" + this.getMobStringID())));
        }
    }

    public boolean initMobTexture() {
        return false;
    }

    public abstract Class<? extends SkillTransformationMountMob> getMobClass();

    public String getMobStringID() {
        return this.stringID + "mob";
    }
}

