/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.ActiveSkills;

import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import rpgclasses.buffs.Skill.PassiveActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.data.PlayerData;

public abstract class SimplePassiveBuffActiveSkill
extends ActiveSkill {
    public SimplePassiveBuffActiveSkill(String stringID, String color, int levelMax, int requiredClassLevel) {
        super(stringID, color, levelMax, requiredClassLevel);
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        if (isInUse && player.buffManager.hasBuff(this.getBuffStringID())) {
            this.removeBuffOnRun(player);
        } else {
            this.giveBuffOnRun(player, activeSkillLevel);
        }
    }

    @Override
    public boolean isInUseSkill() {
        return true;
    }

    public void giveBuffOnRun(PlayerMob player, int activeSkillLevel) {
        this.giveBuff(player, (Mob)player, activeSkillLevel);
    }

    public void giveBuff(PlayerMob buffOwner, Mob target, int activeSkillLevel) {
        ActiveBuff ab = this.getActiveBuff(target, activeSkillLevel);
        target.buffManager.addBuff(ab, buffOwner.isServer());
    }

    public void removeBuffOnRun(PlayerMob player) {
        this.removeBuff((Mob)player);
    }

    public void removeBuff(Mob target) {
        target.buffManager.removeBuff(this.getBuffStringID(), true);
    }

    public ActiveBuff getActiveBuff(String buffID, Mob target, int activeSkillLevel) {
        ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)buffID), target, 1000, null);
        ab.getGndData().setInt("skillLevel", activeSkillLevel);
        return ab;
    }

    public ActiveBuff getActiveBuff(Mob target, int activeSkillLevel) {
        return this.getActiveBuff(this.getBuffStringID(), target, activeSkillLevel);
    }

    @Override
    public void registry() {
        super.registry();
        BuffRegistry.registerBuff((String)this.getBuffStringID(), (Buff)this.getBuff());
    }

    public abstract PassiveActiveSkillBuff getBuff();

    public String getBuffStringID() {
        return this.stringID + "passiveactiveskillbuff";
    }
}

