/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.ActiveSkills;

import java.util.List;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGModifiers;

public abstract class CastActiveSkill
extends ActiveSkill {
    public CastActiveSkill(String stringID, String color, int levelMax, int requiredClassLevel) {
        super(stringID, color, levelMax, requiredClassLevel);
    }

    @Override
    public void addInfoTooltips(List<String> tooltips) {
        super.addInfoTooltips(tooltips);
        float rawCast = this.castTime();
        float seconds = rawCast / 1000.0f;
        String formattedCast = seconds == (float)((int)seconds) ? Integer.toString((int)seconds) : String.format("%.2f", Float.valueOf(seconds));
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"ui", (String)"activeskillcast", (String)"seconds", (String)formattedCast));
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        if (isInUse) {
            this.castedRunServer(player, playerData, activeSkillLevel, seed);
        } else if (((Float)player.buffManager.getModifier(RPGModifiers.CAST_TIME)).floatValue() > 0.0f) {
            ActiveBuff ab = new ActiveBuff(RPGBuffs.CASTING, (Mob)player, (int)((float)this.castTime() * ((Float)player.buffManager.getModifier(RPGModifiers.CAST_TIME)).floatValue()), null);
            ab.getGndData().setInt("particlesColor", this.getColorInt());
            player.buffManager.addBuff(ab, true);
        } else {
            this.castedRunServer(player, playerData, activeSkillLevel, seed);
            playerData.getInUseActiveSkillSlot().startCooldown(player, playerData, player.getTime(), activeSkillLevel);
        }
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        if (isInUse) {
            this.castedRunClient(player, playerData, activeSkillLevel, seed);
        } else if (((Float)player.buffManager.getModifier(RPGModifiers.CAST_TIME)).floatValue() <= 0.0f) {
            this.castedRunClient(player, playerData, activeSkillLevel, seed);
            playerData.getInUseActiveSkillSlot().startCooldown(player, playerData, player.getTime(), activeSkillLevel);
        }
    }

    public void castedRunServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        this.castedRun(player, playerData, activeSkillLevel, seed);
    }

    public void castedRunClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        this.castedRun(player, playerData, activeSkillLevel, seed);
    }

    public void castedRun(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
    }

    @Override
    public boolean isInUseSkill() {
        return true;
    }

    public int castTime() {
        return 3000;
    }
}

