/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.SkillsLogic.ActiveSkills;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.gfx.gameTexture.GameTexture;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;

public abstract class ActiveSkill
extends Skill {
    public boolean newRow;
    public List<RequiredSkill> requiredSkills = new ArrayList<RequiredSkill>();

    public ActiveSkill(String stringID, String color, int levelMax, int requiredClassLevel) {
        super(stringID, color, levelMax, requiredClassLevel);
    }

    @Override
    public ActiveSkill setFamily(String family) {
        this.family = family;
        return this;
    }

    public ActiveSkill addRequiredSkill(ActiveSkill activeSkill, int activeSkillLevel, PlayerClass playerClass) {
        this.requiredSkills.add(new RequiredSkill(activeSkill, activeSkillLevel, playerClass));
        return this;
    }

    public ActiveSkill addRequiredMaxedSkill(ActiveSkill activeSkill, PlayerClass playerClass) {
        this.requiredSkills.add(RequiredSkill.maxLevel(activeSkill, playerClass));
        return this;
    }

    public ActiveSkill setNewRow(boolean newRow) {
        this.newRow = newRow;
        return this;
    }

    @Override
    public List<String> getToolTipsText(PlayerMob player) {
        ArrayList<String> tooltips = new ArrayList<String>();
        tooltips.add("\u00a7" + this.color + Localization.translate((String)"activeskills", (String)this.stringID));
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"activeskillsdesc", (String)this.stringID));
        this.addManaToolTip(tooltips);
        this.addInfoTooltips(tooltips);
        tooltips.add(" ");
        int modCooldown = this.getCooldownModPerLevel();
        if (modCooldown == 0) {
            float cooldown = this.getBaseCooldown(player);
            float seconds = cooldown / 1000.0f;
            String formattedCooldown = seconds == (float)((int)seconds) ? Integer.toString((int)seconds) : String.format("%.2f", Float.valueOf(seconds));
            tooltips.add(Localization.translate((String)"ui", (String)"activeskillcooldown", (String)"seconds", (String)formattedCooldown));
        } else {
            tooltips.add(Localization.translate((String)"ui", (String)"activeskillcooldownmod"));
        }
        if (this.requiredClassLevel > 1 || !this.requiredSkills.isEmpty()) {
            tooltips.add(" ");
            if (this.requiredClassLevel > 1) {
                tooltips.add(Localization.translate((String)"ui", (String)"requiredclasslevel", (String)"level", (Object)this.requiredClassLevel));
            }
            if (!this.requiredSkills.isEmpty()) {
                for (RequiredSkill requiredSkill : this.requiredSkills) {
                    requiredSkill.addToolTips(tooltips);
                }
            }
        }
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"ui", (String)"maxlevel", (String)"level", (Object)this.levelMax));
        return tooltips;
    }

    @Override
    public String baseToolTipsReplaces(PlayerMob player, String string) {
        float cooldown = this.getBaseCooldown(player);
        int modCooldown = this.getCooldownModPerLevel();
        float seconds = cooldown / 1000.0f;
        String formattedCooldown = seconds == (float)((int)seconds) ? Integer.toString((int)seconds) : String.format("%.2f", Float.valueOf(seconds));
        float modSeconds = Math.abs(modCooldown / 1000);
        String formattedModCooldown = modSeconds == (float)((int)modSeconds) ? Integer.toString((int)modSeconds) : String.format("%.2f", Float.valueOf(modSeconds));
        string = string.replaceAll("\\[\\[cooldown]]", formattedCooldown + " " + (modCooldown > 0 ? "+" : "-") + " " + formattedModCooldown + " <skilllevel>");
        SkillParam manaParam = this.getManaParam();
        if (manaParam != null) {
            string = string.replaceAll("\\[\\[mana]]", manaParam.baseParamValue());
        }
        return string;
    }

    @Override
    public String finalToolTipsReplaces(PlayerMob player, String string, PlayerData playerData, int skillLevel) {
        int modCooldown;
        float cooldown = this.getBaseCooldown(player);
        float seconds = (cooldown + (float)((modCooldown = this.getCooldownModPerLevel()) * skillLevel)) / 1000.0f;
        String formattedCooldown = seconds == (float)((int)seconds) ? Integer.toString((int)seconds) : String.format("%.2f", Float.valueOf(seconds));
        string = string.replaceAll("\\[\\[cooldown]]", formattedCooldown);
        SkillParam manaParam = this.getManaParam();
        if (manaParam != null) {
            string = string.replaceAll("\\[\\[mana]]", manaParam.paramValue(playerData.getLevel(), skillLevel));
        }
        return string;
    }

    public void addManaToolTip(List<String> tooltips) {
        SkillParam manaParam = this.getManaParam();
        if (manaParam != null) {
            tooltips.add(" ");
            if (this.consumesManaPerSecond()) {
                tooltips.add(Localization.translate((String)"ui", (String)"consumesmanapersecond"));
            } else {
                tooltips.add(Localization.translate((String)"ui", (String)"consumesmana"));
            }
        }
    }

    public void addInfoTooltips(List<String> tooltips) {
    }

    @Override
    public void initResources() {
        this.texture = GameTexture.fromFile((String)("activeskills/" + this.stringID));
    }

    public void run(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUSe) {
        boolean enoughMana = true;
        if (!isInUSe) {
            float manaUsage;
            float consumedStamina = this.consumedStamina(player);
            if (consumedStamina > 0.0f) {
                StaminaBuff.useStaminaAndGetValid((Mob)player, (float)consumedStamina);
            }
            if ((manaUsage = this.manaUsage(activeSkillLevel)) > 0.0f) {
                if (manaUsage > player.getMana()) {
                    enoughMana = false;
                }
                player.useMana(manaUsage, player.isServer() ? player.getServerClient() : null);
            }
        }
        int addedCooldown = enoughMana ? 0 : this.getCooldown(player, activeSkillLevel);
        long useTime = player.getTime();
        for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
            if (equippedActiveSkill.getActiveSkill() != this) continue;
            if (equippedActiveSkill.getActiveSkill().isInUseSkill() && !equippedActiveSkill.isInUse()) {
                equippedActiveSkill.setInUse();
                continue;
            }
            equippedActiveSkill.startCooldown(player, playerData, useTime, activeSkillLevel, addedCooldown);
        }
    }

    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        this.run(player, playerData, activeSkillLevel, seed, isInUse);
    }

    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        this.run(player, playerData, activeSkillLevel, seed, isInUse);
    }

    public String canActive(PlayerMob player, PlayerData playerData, int activeSkillLevel, boolean isInUSe) {
        float consumedStamina;
        if (!isInUSe && (consumedStamina = this.consumedStamina(player)) > 0.0f && ActiveSkill.getStamina(player) < consumedStamina) {
            return "notenoughstamina";
        }
        return null;
    }

    public abstract int getBaseCooldown(PlayerMob var1);

    public int getCooldown(PlayerMob player, int activeSkillLevel) {
        return this.getBaseCooldown(player) + activeSkillLevel * this.getCooldownModPerLevel();
    }

    public int getCooldownModPerLevel() {
        return 0;
    }

    @Override
    public boolean containsComplexTooltips() {
        return true;
    }

    public float consumedStaminaBase() {
        return 0.0f;
    }

    public float consumedStamina(PlayerMob player) {
        float staminaUSage = ((Float)player.buffManager.getModifier(BuffModifiers.STAMINA_USAGE)).floatValue();
        return this.consumedStaminaBase() * staminaUSage;
    }

    public boolean isInUseSkill() {
        return false;
    }

    public boolean canUseIfIsInUse() {
        return true;
    }

    public static float getStamina(PlayerMob player) {
        float capacityMod = ((Float)player.buffManager.getModifier(BuffModifiers.STAMINA_CAPACITY)).floatValue();
        ActiveBuff activeBuff = player.buffManager.getBuff(BuffRegistry.STAMINA_BUFF);
        if (activeBuff == null) {
            return capacityMod;
        }
        GNDItemMap gndData = activeBuff.getGndData();
        if (gndData.getBoolean("onCooldown")) {
            return 0.0f;
        }
        return Math.abs(1.0f - gndData.getFloat("stamina")) * capacityMod;
    }

    public static Point2D.Float getRandomClosePlace(PlayerMob player) {
        float angle = GameRandom.globalRandom.getIntBetween(0, 359);
        int distance = GameRandom.globalRandom.getIntBetween(32, 64);
        return new Point2D.Float(player.x + GameMath.cos((float)angle) * (float)distance, player.y + GameMath.sin((float)angle) * (float)distance);
    }

    @Override
    public int getLevel(PlayerData playerData) {
        return playerData.getClassesData()[this.playerClass.id].getActiveSkillLevels()[this.id];
    }

    public SkillParam getManaParam() {
        return null;
    }

    public boolean consumesManaPerSecond() {
        return false;
    }

    @Override
    public boolean addManaUsageExtraToolTip() {
        return this.getManaParam() != null && !this.consumesManaPerSecond();
    }

    public float manaUsage(int activeSkillLevel) {
        SkillParam manaParam = this.getManaParam();
        if (manaParam == null || this.consumesManaPerSecond()) {
            return 0.0f;
        }
        return manaParam.value(activeSkillLevel);
    }

    public static class RequiredSkill {
        public final ActiveSkill activeSkill;
        public final int activeSkillLevel;
        public final PlayerClass playerClass;

        public RequiredSkill(ActiveSkill activeSkill, int activeSkillLevel, PlayerClass playerClass) {
            this.activeSkill = activeSkill;
            this.activeSkillLevel = activeSkillLevel;
            this.playerClass = playerClass;
        }

        public static RequiredSkill maxLevel(ActiveSkill activeSkill, PlayerClass playerClass) {
            return new RequiredSkill(activeSkill, activeSkill.levelMax, playerClass);
        }

        public void addToolTips(List<String> tooltips) {
            String skillName = Localization.translate((String)"activeskills", (String)this.activeSkill.stringID);
            tooltips.add(Localization.translate((String)"ui", (String)"requiredactiveskill", (Object[])new Object[]{"skill", skillName, "level", this.activeSkillLevel}));
        }
    }
}

