/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.Passives;

import aphorea.utils.AphColors;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.trails.LightningTrail;
import necesse.entity.trails.Trail;
import necesse.entity.trails.TrailVector;
import necesse.gfx.GameResources;
import necesse.gfx.gameFont.FontManager;
import necesse.level.maps.Level;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.packets.PacketMobResetBuffTime;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.utils.RPGColors;
import rpgclasses.utils.RPGUtils;

public class Stormbound
extends SimpleBuffPassive {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("11 - 0.5 x <skilllevel>"), SkillParam.damageParam(1.0f), SkillParam.staticParam(1.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public Stormbound(int levelMax, int requiredClassLevel) {
        super("stormbound", RPGColors.HEX.lighting, levelMax, requiredClassLevel);
    }

    @Override
    public PrincipalPassiveBuff getBuff() {
        return new PrincipalPassiveBuff(){

            public void serverTick(ActiveBuff activeBuff) {
                super.serverTick(activeBuff);
                int time = activeBuff.getGndData().getInt("time", 0);
                if ((time += 50) > (int)(params[0].value(this.getLevel(activeBuff)) * 1000.0f)) {
                    time = 0;
                    Mob target = RPGUtils.getRandomTarget(activeBuff.owner, 500);
                    PlayerMob player = (PlayerMob)activeBuff.owner;
                    if (target != null) {
                        target.isServerHit(new GameDamage(DamageTypeRegistry.MAGIC, params[1].value(this.getPlayerLevel(player), this.getLevel(activeBuff))), player.x, player.y, 0.0f, (Attacker)player);
                        RPGBuffs.applyStun(target, params[2].value());
                        player.getServer().network.sendToClientsAtEntireLevel((Packet)new LightningPacket(target.getX(), target.getY()), player.getLevel());
                    }
                    player.getServer().network.sendToClientsAtEntireLevel((Packet)new PacketMobResetBuffTime(player.getUniqueID(), Stormbound.this.getBuffStringID()), player.getLevel());
                }
                activeBuff.getGndData().setInt("time", time);
            }

            public void clientTick(ActiveBuff activeBuff) {
                super.clientTick(activeBuff);
                int time = activeBuff.getGndData().getInt("time", 0);
                activeBuff.getGndData().setInt("time", time += 50);
            }

            public void drawIcon(int x, int y, ActiveBuff activeBuff) {
                super.drawIcon(x, y, activeBuff);
                int time = activeBuff.getGndData().getInt("time", 0) - 50;
                String text = EquippedActiveSkill.getTimeLeftString((int)(params[0].value(this.getLevel(activeBuff)) * 1000.0f) - time);
                int width = FontManager.bit.getWidthCeil(text, durationFontOptions);
                FontManager.bit.drawString((float)(x + 28 - width), (float)(y + 30 - FontManager.bit.getHeightCeil(text, durationFontOptions)), text, durationFontOptions);
            }
        };
    }

    public static class LightningPacket
    extends Packet {
        public final int x;
        public final int y;

        public LightningPacket(byte[] data) {
            super(data);
            PacketReader reader = new PacketReader((Packet)this);
            this.x = reader.getNextInt();
            this.y = reader.getNextInt();
        }

        public LightningPacket(int x, int y) {
            this.x = x;
            this.y = y;
            PacketWriter writer = new PacketWriter((Packet)this);
            writer.putNextInt(x);
            writer.putNextInt(y);
        }

        public void processClient(NetworkPacket packet, Client client) {
            Level level = client.getLevel();
            SoundManager.playSound((GameSound)GameResources.electricExplosion, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(1.2f).pitch(0.8f));
            float initialMoveX = GameRandom.globalRandom.getIntBetween(-20, 20);
            float initialMoveY = GameRandom.globalRandom.getIntBetween(-20, 20);
            for (int i = 0; i < 6; ++i) {
                int j;
                float finalMoveY;
                float finalMoveX;
                if (i == 0) {
                    finalMoveX = 0.0f;
                    finalMoveY = 0.0f;
                } else {
                    finalMoveX = GameRandom.globalRandom.getIntBetween(50, 80) * (GameRandom.globalRandom.getChance(0.5f) ? -1 : 1);
                    finalMoveY = GameRandom.globalRandom.getIntBetween(50, 80) * (GameRandom.globalRandom.getChance(0.5f) ? -1 : 1);
                }
                float prevX = this.x;
                float prevY = this.y;
                LightningTrail trail = new LightningTrail(new TrailVector(prevX, prevY, 0.0f, 0.0f, i == 0 ? 16.0f : GameRandom.globalRandom.getFloatBetween(8.0f, 12.0f), 0.0f), level, level.isCave ? AphColors.dark_magic : AphColors.lighting);
                level.entityManager.addTrail((Trail)trail);
                int n = j = i == 0 ? 1 : i + 2;
                while (j < 6) {
                    float progression = (float)j / 10.0f;
                    float height = 500.0f * progression;
                    float newX = (float)(this.x + GameRandom.globalRandom.getIntBetween(-5, 5)) + finalMoveY * (1.0f - progression) + initialMoveX * progression;
                    float newY = (float)(this.y + GameRandom.globalRandom.getIntBetween(-5, 5)) + finalMoveX * (1.0f - progression) + initialMoveY * progression;
                    trail.addNewPoint(new TrailVector(newX, newY, newX - prevX, newY - prevY, trail.thickness, height));
                    prevX = newX;
                    prevY = newY;
                    ++j;
                }
            }
        }
    }
}

